/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.io;

import b.b;
import java.io.InputStream;
import java.util.logging.Logger;

public class PositionInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in.jmrtd");
    private static final long MARK_NOT_SET = -1L;
    private InputStream carrier;
    private long position;
    private long markedPosition;

    public PositionInputStream(InputStream inputStream) {
        this.carrier = inputStream;
        this.position = 0L;
        this.markedPosition = -1L;
    }

    @Override
    public int read() {
        int n = this.carrier.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.carrier.read(byArray, n, n2);
        this.position += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) {
        long l2 = this.carrier.skip(l);
        if (l2 <= 0L) {
            LOGGER.warning(b.a("Carrier (").append(this.carrier.getClass().getCanonicalName()).append(")'s skip(").append(l).append(") only skipped ").append(l2).append(", position = ").append(this.position).toString());
        }
        this.position += l2;
        return l2;
    }

    @Override
    public synchronized void mark(int n) {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.mark(n);
        positionInputStream.markedPosition = positionInputStream.position;
    }

    @Override
    public synchronized void reset() {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.reset();
        positionInputStream.position = positionInputStream.markedPosition;
    }

    @Override
    public boolean markSupported() {
        return this.carrier.markSupported();
    }

    public long getPosition() {
        return this.position;
    }
}

