/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.managers;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.handlers.GetDynamicLanguageHandler;
import vn.kalapa.ekyc.managers.KLPCDNManager;
import vn.kalapa.ekyc.models.KalapaAllLanguageModel;
import vn.kalapa.ekyc.models.KalapaCDNObj;
import vn.kalapa.ekyc.models.LanguageModelContent;
import vn.kalapa.ekyc.models.LanguageModelData;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nKLPLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,128:1\n8676#2,2:129\n9358#2,4:131\n13579#2,2:137\n13579#2,2:139\n13579#2,2:141\n215#3,2:135\n*S KotlinDebug\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n*L\n36#1:129,2\n36#1:131,4\n55#1:137,2\n67#1:139,2\n83#1:141,2\n41#1:135,2\n*E\n"})
public final class KLPLanguageManager {
    @NotNull
    public static final KLPLanguageManager INSTANCE = new KLPLanguageManager();
    @NotNull
    private static final HashMap<String, HashMap<String, String>> languageMap = new HashMap();
    private static KLPLanguage language;

    private KLPLanguageManager() {
    }

    private final void loadResourcesMap(Context object) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Resources resources = object.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        String string2 = object.getPackageName();
        resources.getIdentifier("string", "values", string2);
        Field[] fieldArray = R.string.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields");
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)fieldArray.length), (int)16);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, Object>(n);
        for (Field field : fieldArray) {
            int n2 = field.getInt(null);
            Pair pair = TuplesKt.to((Object)field.getName(), (Object)resources.getString(n2));
            Object object2 = pair.getFirst();
            linkedHashMap2.put(object2, pair.getSecond());
        }
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            Helpers.Companion.printLog("Resources: " + string3 + ": " + string4);
        }
    }

    private final void setDictionary(KLPLanguage kLPLanguage, Map<String, String> ... mapArray) {
        HashMap<String, String> hashMap = languageMap.get(kLPLanguage.name());
        if (hashMap == null) {
            HashMap hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap();
        }
        for (Map<String, String> map : mapArray) {
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                hashMap.put(string2, string3);
            }
        }
        languageMap.put(kLPLanguage.name(), hashMap);
    }

    @NotNull
    public final String get(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"key");
        Object object2 = language;
        if (object2 != null) {
            HashMap<String, HashMap<String, String>> hashMap = languageMap;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
            if ((object2 = hashMap.get(((Enum)object2).name())) != null && (object2 = (String)((HashMap)object2).get(object)) != null) {
                object = object2;
            }
        }
        return object;
    }

    @Nullable
    public final KalapaCDNObj pullVersion(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void pullOrGetLanguage(@NotNull Activity object, @NotNull String languageModelDataArray, @Nullable String object22) {
        void var3_8;
        LanguageModelData[] languageModelDataArray2;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)n, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)languageModelDataArray2, (String)"baseURL");
        KalapaAllLanguageModel kalapaAllLanguageModel = KLPCDNManager.INSTANCE.loadLanguageFromCache((Context)n, (String)var3_8);
        if (kalapaAllLanguageModel != null) {
            if (kalapaAllLanguageModel.getError() != null) {
                n = kalapaAllLanguageModel.getError().getCode();
                int n2 = 200;
                if (n != null && n == n2 && kalapaAllLanguageModel.getData() != null) {
                    for (LanguageModelData languageModelData : kalapaAllLanguageModel.getData()) {
                        Object object2 = languageModelData.getContent();
                        if (!(object2 != null && (object2 = ((LanguageModelContent)object2).getSDK()) != null && object2.isEmpty() ^ true)) continue;
                        INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(languageModelData.getCode()), languageModelData.getContent().getSDK(), languageModelData.getContent().getAPP_DEMO());
                    }
                }
            }
            Helpers.Companion.printLog("Loaded language from cached successfully");
            return;
        }
        KalapaAllLanguageModel kalapaAllLanguageModel2 = (KalapaAllLanguageModel)new GetDynamicLanguageHandler().execute(new String[]{languageModelDataArray2}).get();
        if (kalapaAllLanguageModel2 != null && kalapaAllLanguageModel2.getError() != null) {
            languageModelDataArray2 = kalapaAllLanguageModel2.getError().getCode();
            int n3 = 200;
            if (languageModelDataArray2 != null && languageModelDataArray2.intValue() == n3 && kalapaAllLanguageModel2.getData() != null) {
                void var3_13;
                languageModelDataArray2 = kalapaAllLanguageModel2.getData();
                boolean bl = false;
                int n4 = languageModelDataArray2.length;
                while (var3_13 < n4) {
                    LanguageModelData languageModelData = languageModelDataArray2[var3_13];
                    Object object3 = languageModelData.getContent();
                    if (object3 != null && (object3 = ((LanguageModelContent)object3).getSDK()) != null && object3.isEmpty() ^ true) {
                        INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(languageModelData.getCode()), languageModelData.getContent().getSDK(), languageModelData.getContent().getAPP_DEMO());
                    }
                    KLPCDNManager.INSTANCE.saveJsonStringIntoFile((Context)n, kalapaAllLanguageModel2);
                    ++var3_13;
                }
            }
        }
    }

    public final void pullModel(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
    }

    public final void setLocale(@NotNull Context context, @NotNull String string2) {
        Locale locale;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"languageCode");
        Locale locale2 = locale;
        Locale.setDefault(new Locale(string2));
        context = context2.getResources().getConfiguration();
        context.setLocale(locale2);
        context2.getApplicationContext().createConfigurationContext((Configuration)context);
    }

    @NotNull
    public final KLPLanguageManager setLanguage(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        Helpers.Companion companion = Helpers.Companion;
        Object object = new Object[1];
        int n = 0;
        Object object2 = language;
        if (object2 != null) {
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
        } else {
            object2 = "null";
        }
        KLPLanguage.Companion companion2 = KLPLanguage.Companion;
        object[n] = "setLanguage from " + (Object)object2 + " to " + companion2.fromCountryCode(string2);
        companion.printLog(object);
        language = companion2.fromCountryCode(string2);
        companion.printLog("setLocale from " + Locale.getDefault() + " - " + string2);
        object = Intrinsics.areEqual((Object)string2, (Object)"vi") ? "vi" : (Intrinsics.areEqual((Object)string2, (Object)"ko") ? "ko" : "en");
        this.setLocale(context, (String)object);
        companion.printLog("setLocale to " + Locale.getDefault() + " - " + string2);
        return this;
    }

    public static enum KLPLanguage {
        ENGLISH,
        VIETNAMESE,
        KOREAN;

        @NotNull
        public static final Companion Companion = new Companion(null);

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final KLPLanguage fromCountryCode(@NotNull String string2) {
                KLPLanguage kLPLanguage;
                block3: {
                    block2: {
                        block0: {
                            block1: {
                                String string3 = string2;
                                Intrinsics.checkNotNullParameter((Object)string3, (String)"code");
                                int n = string3.hashCode();
                                if (n == 3241) break block0;
                                if (n == 3428) break block1;
                                if (n != 3763 || !string2.equals("vi")) break block2;
                                kLPLanguage = VIETNAMESE;
                                break block3;
                            }
                            if (!string2.equals("ko")) break block2;
                            kLPLanguage = KOREAN;
                            break block3;
                        }
                        string2.equals("en");
                    }
                    kLPLanguage = ENGLISH;
                }
                return kLPLanguage;
            }
        }
    }
}

