package vn.kalapa.ekyc.managers

import android.app.Activity
import android.content.Context
import android.content.res.Resources
import vn.kalapa.R
import vn.kalapa.ekyc.KalapaSDKConfig
import vn.kalapa.ekyc.handlers.GetDynamicLanguageHandler
import vn.kalapa.ekyc.models.KalapaCDNObj
import vn.kalapa.ekyc.utils.Common
import vn.kalapa.ekyc.utils.Helpers
import java.lang.ref.WeakReference
import java.util.Locale


// Singleton way
object KLPLanguageManager {
    private val languageMap = HashMap<String, HashMap<String, String>>()
    private lateinit var language: KLPLanguage
    fun get(key: String): String {
        return if (this::language.isInitialized) {
            //            Helpers.printLog("get $language $key ${(languageMap[language.name])?.get(key) ?: key}")
            (languageMap[language.name])?.get(key) ?: key
        } else key
    }

    private fun loadResourcesMap(context: Context) {
        val resources: Resources = context.resources
        val packageName = context.packageName
        val stringResIds = resources.getIdentifier("string", "values", packageName)
        val fields = R.string::class.java.fields

        val allStrings = fields.associate { field ->
            val id = field.getInt(null)
            field.name to resources.getString(id)
        }

        allStrings.forEach { (name, value) ->
            Helpers.printLog("Resources: $name: $value")
        }
    }

    fun pullVersion(baseURL: String): KalapaCDNObj? {
        return null
    }

    fun pullOrGetLanguage(
        activity: Activity,
        baseURL: String,
        language: String,
        version: String?,
        customer: String?
    ): KalapaSDKConfig.KLPLanguageConfig? {

        // Check if there are saved versions. If version params are not equal to current version, pull no matter what.
        // Check if there is a cached file; if not, pull no matter what.
        KLPCDNManager.loadLanguageFromCache(activity, version)?.let { cacheResult ->
            var finalM: Boolean? = null
            var finalP: Int? = null
            if (cacheResult.error?.code == 0 && cacheResult.data != null) {
                cacheResult.data.forEach { dataItem ->
                    if (dataItem.data?.SDK?.isNotEmpty() == true) {
                        setDictionary(KLPLanguage.fromCountryCode(language), dataItem.data.SDK, dataItem.data.APP_DEMO)
                    }
                    if (finalM == null || !(finalM as Boolean)) finalM = dataItem.m77232917
                    if (finalP == null || !Common.isP(finalP as Int)) finalP = dataItem.p93337

                }
                Helpers.printLog("Loaded language from cache successfully")
                // Return the first valid cached language configuration
                return KalapaSDKConfig.KLPLanguageConfig(finalM, finalP)
            }
        }
        // If no valid cache is found, pull new language data and save it to the cache
        val newLanguageData = GetDynamicLanguageHandler(WeakReference(activity))
            .execute(baseURL, language, customer)
            .get()
        newLanguageData?.let {
            if (it.error?.code == 0 && it.data != null) {
                if (it.data.data?.SDK?.isNotEmpty() == true && it.data.data.APP_DEMO.isNotEmpty()) {
                    setDictionary(KLPLanguage.fromCountryCode(language), it.data.data.SDK, it.data.data.APP_DEMO)
                    // Save the new data to cache
                    KLPCDNManager.saveJsonStringIntoFile(activity, it)
                    return KalapaSDKConfig.KLPLanguageConfig(it.data.m77232917, it.data.p93337)
                }
            }
        }
        // If everything fails, return null
        return null
    }

    fun pullModel(baseURL: String) {

    }

    private fun setDictionary(language: KLPLanguage, vararg dictionaries: Map<String, String>) {
        var keyMap = languageMap[language.name] ?: HashMap()
        dictionaries.forEach {
            for (key in it.keys) {
//                Helpers.printLog("$key ${it[key]}")
                keyMap[key] = it[key] ?: key
            }
        }
        languageMap[language.name] = keyMap
//        Helpers.printLog(languageMap)
    }


    fun setLocale(context: Context, languageCode: String) {
        val locale = Locale(languageCode)
        Locale.setDefault(locale)
        val config = context.resources.configuration
        config.setLocale(locale)
        context.applicationContext.createConfigurationContext(config)
    }

    fun setLanguage(context: Context, language: String): KLPLanguageManager {
        Helpers.printLog("setLanguage from ${if (this::language.isInitialized) this.language else "null"} to ${KLPLanguage.fromCountryCode(language)}")
//        Toast.makeText(activity,activity.getString(R.string.TEST_LANGUAGE),Toast.LENGTH_LONG).show()
        this.language = KLPLanguage.fromCountryCode(language)
        Helpers.printLog("setLocale from ${Locale.getDefault()} - $language")
        setLocale(context, if (language == "vi") "vi" else if (language == "ko") "ko" else "en")
        Helpers.printLog("setLocale to ${Locale.getDefault()} - $language")
        return this
    }

    enum class KLPLanguage {
        ENGLISH, VIETNAMESE, KOREAN;

        companion object {
            fun fromCountryCode(code: String): KLPLanguage {

                return when (code) {
                    "en" -> ENGLISH
                    "vi" -> VIETNAMESE
                    "ko" -> KOREAN
                    else -> ENGLISH
                }
            }
        }
    }

}