package vn.kalapa.ekyc.managers

import android.app.Activity
import android.content.Context
import android.content.SharedPreferences

object KLPSharedPreferenceManager {

    private val CARD_MODEL_VERSION_KEY = "klp_card_model_version"
    private val LANGUAGE_VERSION_KEY = "klp_language_version"

    private var prefs: SharedPreferences? = null
    fun init(activity: Activity) {
        this.prefs = activity.getSharedPreferences(activity.packageName, Context.MODE_PRIVATE)
    }

    fun getLanguageVersion(): String {
        return prefs?.getString(LANGUAGE_VERSION_KEY, "0.0.0") ?: "0.0.0"
    }

    fun getCardModelVersion(): String {
        return prefs?.getString(CARD_MODEL_VERSION_KEY, "0.0.0") ?: "0.0.0"
    }

    fun updateLanguageVersion(version: String) {
        savePrefs(LANGUAGE_VERSION_KEY, version)
    }

    fun updateModelVersion(version: String) {
        savePrefs(CARD_MODEL_VERSION_KEY, version)
    }

    private fun savePrefs(key: String, value: Any) {
        val editor = prefs?.edit()
        editor?.putString(key, value.toString())
        editor?.apply()
    }

}