package vn.kalapa.ekyc.models

import com.google.gson.Gson
import com.google.gson.annotations.SerializedName
import vn.kalapa.ekyc.utils.Helpers

// To parse the JSON, install Klaxon and do:
//
//   val welcome8 = Welcome8.fromJson(jsonString)


data class KalapaLanguageModel(
    val data: LanguageModelData?,
    val error: MyError?,
) {
    fun toJson() = Gson().toJson(this)

    companion object {
        fun fromJson(json: String): KalapaLanguageModel {
            Helpers.printLog("KalapaLanguageModel.fromJson $json")
            return Gson().fromJson(json, KalapaLanguageModel::class.java)
        }// klaxon.parse<KalapaLanguageModel>(json)
    }
}

data class KalapaAllLanguageModel(
    val data: Array<LanguageModelData>?,
    val error: MyError?
) {
    fun toJson(): String = Gson().toJson(this)

    companion object {
        fun fromJson(json: String): KalapaAllLanguageModel = Gson().fromJson(json, KalapaAllLanguageModel::class.java)
    }
}

data class LanguageModelData(
    val data: LanguageModelContent?,  // Fix nested field
    val created_time: String,
    val version_id: String,
    val m77232917: Boolean,
    val p93337: Int
) {
    fun toJson() = Gson().toJson(this)// klaxon.toJsonString(this)

    companion object {
        fun fromJson(json: String): LanguageModelData {
            Helpers.printLog("LanguageModelData.fromJson $json")
            return Gson().fromJson(json, LanguageModelData::class.java)
        }// klaxon.parse<LanguageModelData>(json)
    }
}

data class LanguageModelContent(
    val APP_DEMO: Map<String, String>,
    val SDK: Map<String, String>
) {
    fun toJson() = Gson().toJson(this)// klaxon.toJsonString(this)

    companion object {
        fun fromJson(json: String): LanguageModelContent = Gson().fromJson(json, LanguageModelContent::class.java)//klaxon.parse<LanguageModelDataData>(json)
    }
}
