/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Exception;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    public final int tagNo;
    public final boolean explicit;
    public final ASN1Encodable obj;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            return ASN1TaggedObject.getInstance(aSN1TaggedObject.getObject());
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object object) {
        if (object != null && !(object instanceof ASN1TaggedObject)) {
            if (object instanceof byte[]) {
                try {
                    return ASN1TaggedObject.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("failed to construct tagged object from byte[]: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("unknown object in getInstance: ")));
        }
        return (ASN1TaggedObject)object;
    }

    public ASN1TaggedObject(boolean bl, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            this.tagNo = n;
            bl = bl || aSN1Encodable instanceof ASN1Choice;
            ASN1TaggedObject aSN1TaggedObject = this;
            aSN1TaggedObject.explicit = bl;
            aSN1TaggedObject.obj = aSN1Encodable;
            return;
        }
        throw new NullPointerException("'obj' cannot be null");
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            return false;
        }
        aSN1Primitive = (ASN1TaggedObject)aSN1Primitive;
        if (((ASN1TaggedObject)aSN1Primitive2).tagNo == ((ASN1TaggedObject)aSN1Primitive).tagNo && ((ASN1TaggedObject)aSN1Primitive2).explicit == ((ASN1TaggedObject)aSN1Primitive).explicit) {
            ASN1Primitive aSN1Primitive2 = ((ASN1TaggedObject)aSN1Primitive2).obj.toASN1Primitive();
            return aSN1Primitive2 == (aSN1Primitive = ((ASN1TaggedObject)aSN1Primitive).obj.toASN1Primitive()) || aSN1Primitive2.asn1Equals(aSN1Primitive);
        }
        return false;
    }

    @Override
    public int hashCode() {
        ASN1TaggedObject aSN1TaggedObject = this;
        int n = aSN1TaggedObject.tagNo;
        int n2 = aSN1TaggedObject.explicit ? 15 : 240;
        return n ^ n2 ^ this.obj.toASN1Primitive().hashCode();
    }

    @Override
    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public ASN1Primitive getObject() {
        return this.obj.toASN1Primitive();
    }

    @Override
    public ASN1Encodable getObjectParser(int n, boolean bl) {
        if (n != 4) {
            if (n != 16) {
                if (n != 17) {
                    if (bl) {
                        return this.getObject();
                    }
                    throw new ASN1Exception(a.a("implicit tagging not implemented for tag: ", n));
                }
                return ASN1Set.getInstance(this, bl).parser();
            }
            return ASN1Sequence.getInstance(this, bl).parser();
        }
        return ASN1OctetString.getInstance(this, bl).parser();
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    public ASN1Primitive toDERObject() {
        ASN1TaggedObject aSN1TaggedObject = this;
        boolean bl = aSN1TaggedObject.explicit;
        int n = aSN1TaggedObject.tagNo;
        ASN1Encodable aSN1Encodable = aSN1TaggedObject.obj;
        return new DERTaggedObject(bl, n, aSN1Encodable);
    }

    @Override
    public ASN1Primitive toDLObject() {
        ASN1TaggedObject aSN1TaggedObject = this;
        boolean bl = aSN1TaggedObject.explicit;
        int n = aSN1TaggedObject.tagNo;
        ASN1Encodable aSN1Encodable = aSN1TaggedObject.obj;
        return new DLTaggedObject(bl, n, aSN1Encodable);
    }

    @Override
    public abstract void encode(ASN1OutputStream var1, boolean var2);

    public String toString() {
        return b.b.a("[").append(this.tagNo).append("]").append(this.obj).toString();
    }
}

