/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatusInfo;

public class CertResponse
extends ASN1Object {
    private ASN1Integer certReqId;
    private PKIStatusInfo status;
    private CertifiedKeyPair certifiedKeyPair;
    private ASN1OctetString rspInfo;

    private CertResponse(ASN1Sequence aSN1Encodable) {
        this.certReqId = ASN1Integer.getInstance(aSN1Encodable.getObjectAt(0));
        this.status = PKIStatusInfo.getInstance(aSN1Encodable.getObjectAt(1));
        if (aSN1Encodable.size() >= 3) {
            if (aSN1Encodable.size() == 3) {
                if ((aSN1Encodable = aSN1Encodable.getObjectAt(2)) instanceof ASN1OctetString) {
                    this.rspInfo = ASN1OctetString.getInstance(aSN1Encodable);
                } else {
                    this.certifiedKeyPair = CertifiedKeyPair.getInstance(aSN1Encodable);
                }
            } else {
                this.certifiedKeyPair = CertifiedKeyPair.getInstance(aSN1Encodable.getObjectAt(2));
                this.rspInfo = ASN1OctetString.getInstance(aSN1Encodable.getObjectAt(3));
            }
        }
    }

    public static CertResponse getInstance(Object object) {
        if (object instanceof CertResponse) {
            return (CertResponse)object;
        }
        if (object != null) {
            return new CertResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertResponse(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo) {
        this(aSN1Integer, pKIStatusInfo, null, null);
    }

    public CertResponse(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo, CertifiedKeyPair certifiedKeyPair, ASN1OctetString aSN1OctetString) {
        if (aSN1Integer != null) {
            if (pKIStatusInfo != null) {
                CertResponse certResponse = this;
                certResponse.certReqId = aSN1Integer;
                certResponse.status = pKIStatusInfo;
                certResponse.certifiedKeyPair = certifiedKeyPair;
                certResponse.rspInfo = aSN1OctetString;
                return;
            }
            throw new IllegalArgumentException("'status' cannot be null");
        }
        throw new IllegalArgumentException("'certReqId' cannot be null");
    }

    public ASN1Integer getCertReqId() {
        return this.certReqId;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.certifiedKeyPair;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1OctetString aSN1OctetString;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(this.certReqId);
        aSN1EncodableVector.add(this.status);
        CertifiedKeyPair certifiedKeyPair = this.certifiedKeyPair;
        if (certifiedKeyPair != null) {
            aSN1EncodableVector2.add(certifiedKeyPair);
        }
        if ((aSN1OctetString = this.rspInfo) != null) {
            aSN1EncodableVector2.add(aSN1OctetString);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

