/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ScryptParams
extends ASN1Object {
    private final byte[] salt;
    private final BigInteger costParameter;
    private final BigInteger blockSize;
    private final BigInteger parallelizationParameter;
    private final BigInteger keyLength;

    public ScryptParams(byte[] object, int n, int n2, int n3) {
        ScryptParams scryptParams = bigInteger;
        byte[] byArray = object;
        BigInteger bigInteger = BigInteger.valueOf(n);
        object = BigInteger.valueOf(n2);
        BigInteger bigInteger2 = BigInteger.valueOf(n3);
        scryptParams(byArray, bigInteger, (BigInteger)object, bigInteger2, null);
    }

    public ScryptParams(byte[] object, int n, int n2, int n3, int n4) {
        ScryptParams scryptParams = bigInteger;
        byte[] byArray = object;
        BigInteger bigInteger = BigInteger.valueOf(n);
        object = BigInteger.valueOf(n2);
        BigInteger bigInteger2 = BigInteger.valueOf(n3);
        BigInteger bigInteger3 = BigInteger.valueOf(n4);
        scryptParams(byArray, bigInteger, (BigInteger)object, bigInteger2, bigInteger3);
    }

    public ScryptParams(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.salt = Arrays.clone(byArray);
        this.costParameter = bigInteger;
        this.blockSize = bigInteger2;
        this.parallelizationParameter = bigInteger3;
        this.keyLength = bigInteger4;
    }

    public static ScryptParams getInstance(Object object) {
        if (object instanceof ScryptParams) {
            return (ScryptParams)object;
        }
        if (object != null) {
            return new ScryptParams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private ScryptParams(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 4 && aSN1Sequence.size() != 5) {
            throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("invalid sequence: size = ")));
        }
        this.salt = a.a(aSN1Sequence, 0);
        this.costParameter = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        this.blockSize = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2)).getValue();
        this.parallelizationParameter = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(3)).getValue();
        this.keyLength = aSN1Sequence.size() == 5 ? ASN1Integer.getInstance(aSN1Sequence.getObjectAt(4)).getValue() : null;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }

    public BigInteger getCostParameter() {
        return this.costParameter;
    }

    public BigInteger getBlockSize() {
        return this.blockSize;
    }

    public BigInteger getParallelizationParameter() {
        return this.parallelizationParameter;
    }

    public BigInteger getKeyLength() {
        return this.keyLength;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(5).add(new DEROctetString(((ScryptParams)((Object)bigInteger)).salt));
        aSN1EncodableVector2.add(new ASN1Integer(((ScryptParams)((Object)bigInteger)).costParameter));
        aSN1EncodableVector2.add(new ASN1Integer(((ScryptParams)((Object)bigInteger)).blockSize));
        aSN1EncodableVector2.add(new ASN1Integer(((ScryptParams)((Object)bigInteger)).parallelizationParameter));
        BigInteger bigInteger = ((ScryptParams)((Object)bigInteger)).keyLength;
        if (bigInteger != null) {
            ASN1Integer aSN1Integer;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer(bigInteger);
            aSN1EncodableVector2.add(aSN1Integer2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

