/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1UTCTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLReason;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class V2TBSCertListGenerator {
    private static final ASN1Sequence[] reasons;
    private ASN1Integer version;
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private Time thisUpdate;
    private Time nextUpdate;
    private Extensions extensions;
    private ASN1EncodableVector crlentries;

    public V2TBSCertListGenerator() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1Integer aSN1Integer;
        Object object = aSN1Integer;
        aSN1Integer = new ASN1Integer(1L);
        v1.version = object;
        v1.nextUpdate = null;
        v1.extensions = null;
        object = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        v1.crlentries = object;
    }

    private void internalAddCRLEntry(ASN1Integer aSN1Integer, Time time, ASN1Sequence aSN1Sequence) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(3).add(aSN1Integer);
        aSN1EncodableVector2.add(time);
        if (aSN1Sequence != null) {
            aSN1EncodableVector2.add(aSN1Sequence);
        }
        V2TBSCertListGenerator v2TBSCertListGenerator = dERSequence2;
        DERSequence dERSequence2 = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        v2TBSCertListGenerator.addCRLEntry(dERSequence2);
    }

    private static ASN1Sequence createReasonExtension(int n) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        CRLReason cRLReason = CRLReason.lookup(n);
        try {
            aSN1EncodableVector.add(Extension.reasonCode);
            aSN1EncodableVector.add(new DEROctetString(cRLReason.getEncoded()));
            return new DERSequence(aSN1EncodableVector2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("error encoding reason: ", iOException));
        }
    }

    private static ASN1Sequence createInvalidityDateExtension(ASN1GeneralizedTime aSN1GeneralizedTime) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        try {
            new ASN1EncodableVector(2).add(Extension.invalidityDate);
            aSN1EncodableVector2.add(new DEROctetString(aSN1GeneralizedTime.getEncoded()));
            return new DERSequence(aSN1EncodableVector2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("error encoding reason: ", iOException));
        }
    }

    static {
        ASN1Sequence[] aSN1SequenceArray = new ASN1Sequence[11];
        reasons = aSN1SequenceArray;
        aSN1SequenceArray[0] = V2TBSCertListGenerator.createReasonExtension(0);
        aSN1SequenceArray[1] = V2TBSCertListGenerator.createReasonExtension(1);
        aSN1SequenceArray[2] = V2TBSCertListGenerator.createReasonExtension(2);
        aSN1SequenceArray[3] = V2TBSCertListGenerator.createReasonExtension(3);
        aSN1SequenceArray[4] = V2TBSCertListGenerator.createReasonExtension(4);
        aSN1SequenceArray[5] = V2TBSCertListGenerator.createReasonExtension(5);
        aSN1SequenceArray[6] = V2TBSCertListGenerator.createReasonExtension(6);
        aSN1SequenceArray[7] = V2TBSCertListGenerator.createReasonExtension(7);
        aSN1SequenceArray[8] = V2TBSCertListGenerator.createReasonExtension(8);
        aSN1SequenceArray[9] = V2TBSCertListGenerator.createReasonExtension(9);
        aSN1SequenceArray[10] = V2TBSCertListGenerator.createReasonExtension(10);
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = X500Name.getInstance(x509Name.toASN1Primitive());
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setThisUpdate(ASN1UTCTime aSN1UTCTime) {
        Time time;
        V2TBSCertListGenerator v2TBSCertListGenerator = time2;
        Time time2 = time;
        time = new Time(aSN1UTCTime);
        v2TBSCertListGenerator.thisUpdate = time2;
    }

    public void setNextUpdate(ASN1UTCTime aSN1UTCTime) {
        Time time;
        V2TBSCertListGenerator v2TBSCertListGenerator = time2;
        Time time2 = time;
        time = new Time(aSN1UTCTime);
        v2TBSCertListGenerator.nextUpdate = time2;
    }

    public void setThisUpdate(Time time) {
        this.thisUpdate = time;
    }

    public void setNextUpdate(Time time) {
        this.nextUpdate = time;
    }

    public void addCRLEntry(ASN1Sequence aSN1Sequence) {
        this.crlentries.add(aSN1Sequence);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, ASN1UTCTime aSN1UTCTime, int n) {
        Time time;
        V2TBSCertListGenerator v2TBSCertListGenerator = time2;
        Time time2 = time;
        time = new Time(aSN1UTCTime);
        v2TBSCertListGenerator.addCRLEntry(aSN1Integer, time2, n);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n) {
        this.addCRLEntry(aSN1Integer, time, n, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n, ASN1GeneralizedTime aSN1GeneralizedTime) {
        Object object;
        if (n != 0) {
            DERSequence dERSequence;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            aSN1EncodableVector = new ASN1EncodableVector(2);
            ASN1Sequence[] aSN1SequenceArray = reasons;
            if (n < reasons.length) {
                if (n < 0) throw new IllegalArgumentException(a.a("invalid reason value: ", n));
                aSN1EncodableVector2.add(aSN1SequenceArray[n]);
            } else {
                aSN1EncodableVector2.add(V2TBSCertListGenerator.createReasonExtension(n));
            }
            if (aSN1GeneralizedTime != null) {
                aSN1EncodableVector2.add(V2TBSCertListGenerator.createInvalidityDateExtension(aSN1GeneralizedTime));
            }
            Object object2 = object;
            object = dERSequence;
            dERSequence = new DERSequence(aSN1EncodableVector2);
            super.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)object);
            return;
        } else if (aSN1GeneralizedTime != null) {
            DERSequence dERSequence;
            V2TBSCertListGenerator v2TBSCertListGenerator = object;
            object = dERSequence;
            dERSequence = new DERSequence(V2TBSCertListGenerator.createInvalidityDateExtension(aSN1GeneralizedTime));
            v2TBSCertListGenerator.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)object);
            return;
        } else {
            ((V2TBSCertListGenerator)object).addCRLEntry(aSN1Integer, time, null);
        }
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, Extensions extensions) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(3).add(aSN1Integer);
        aSN1EncodableVector2.add(time);
        if (extensions != null) {
            aSN1EncodableVector2.add(extensions);
        }
        V2TBSCertListGenerator v2TBSCertListGenerator = dERSequence2;
        DERSequence dERSequence2 = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        v2TBSCertListGenerator.addCRLEntry(dERSequence2);
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.setExtensions(Extensions.getInstance(x509Extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (((V2TBSCertListGenerator)object).signature != null && ((V2TBSCertListGenerator)object).issuer != null && ((V2TBSCertListGenerator)object).thisUpdate != null) {
            DERSequence dERSequence;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            aSN1EncodableVector2(7);
            aSN1EncodableVector2.add(((V2TBSCertListGenerator)object).version);
            aSN1EncodableVector2.add(((V2TBSCertListGenerator)object).signature);
            aSN1EncodableVector2.add(((V2TBSCertListGenerator)object).issuer);
            aSN1EncodableVector.add(((V2TBSCertListGenerator)object).thisUpdate);
            ASN1Object aSN1Object = ((V2TBSCertListGenerator)object).nextUpdate;
            if (aSN1Object != null) {
                aSN1EncodableVector2.add(aSN1Object);
            }
            if (((V2TBSCertListGenerator)object).crlentries.size() != 0) {
                aSN1EncodableVector2.add(new DERSequence(((V2TBSCertListGenerator)object).crlentries));
            }
            if ((object = ((V2TBSCertListGenerator)object).extensions) != null) {
                DERTaggedObject dERTaggedObject;
                aSN1Object = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(0, (ASN1Encodable)object);
                aSN1EncodableVector2.add(aSN1Object);
            }
            Object object = dERSequence;
            dERSequence = new DERSequence(aSN1EncodableVector2);
            return new TBSCertList((ASN1Sequence)object);
        }
        throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
    }
}

