/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;

public class KeccakDigest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    public long[] state;
    public byte[] dataQueue;
    public int rate;
    public int bitsInQueue;
    public int fixedOutputLength;
    public boolean squeezing;

    public KeccakDigest() {
        this(288);
    }

    public KeccakDigest(int n) {
        this.state = new long[25];
        this.dataQueue = new byte[192];
        this.init(n);
    }

    public KeccakDigest(KeccakDigest object) {
        KeccakDigest keccakDigest = object2;
        KeccakDigest keccakDigest2 = object;
        KeccakDigest keccakDigest3 = object2;
        KeccakDigest keccakDigest4 = object;
        KeccakDigest keccakDigest5 = object2;
        KeccakDigest keccakDigest6 = object;
        KeccakDigest keccakDigest7 = object2;
        KeccakDigest keccakDigest8 = object;
        long[] lArray = new long[25];
        object = lArray;
        ((KeccakDigest)object2).state = lArray;
        ((KeccakDigest)object2).dataQueue = new byte[192];
        int n = keccakDigest8.state.length;
        System.arraycopy(keccakDigest8.state, 0, object, 0, n);
        Object object2 = ((KeccakDigest)object2).dataQueue;
        int n2 = keccakDigest8.dataQueue.length;
        System.arraycopy(keccakDigest8.dataQueue, 0, object2, 0, n2);
        keccakDigest7.rate = keccakDigest8.rate;
        keccakDigest5.bitsInQueue = keccakDigest6.bitsInQueue;
        keccakDigest3.fixedOutputLength = keccakDigest4.fixedOutputLength;
        keccakDigest.squeezing = keccakDigest2.squeezing;
    }

    private void init(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("bitLength must be one of 128, 224, 256, 288, 384, or 512.");
            }
            case 128: 
            case 224: 
            case 256: 
            case 288: 
            case 384: 
            case 512: 
        }
        this.initSponge(1600 - (n << 1));
    }

    private void initSponge(int n) {
        if (n > 0 && n < 1600 && n % 64 == 0) {
            this.rate = n;
            int n2 = 0;
            while (true) {
                long[] lArray = this.state;
                if (n2 >= this.state.length) break;
                lArray[n2] = 0L;
                ++n2;
            }
            Arrays.fill(this.dataQueue, (byte)0);
            this.bitsInQueue = 0;
            this.squeezing = false;
            this.fixedOutputLength = (1600 - n) / 2;
            return;
        }
        throw new IllegalStateException("invalid rate value");
    }

    private void padAndSwitchToSqueezingPhase() {
        long l;
        byte[] byArray = this.dataQueue;
        int n = this.bitsInQueue;
        int n2 = n >>> 3;
        this.dataQueue[n2] = (byte)(byArray[n2] | (byte)(1 << (n & 7)));
        this.bitsInQueue = ++n;
        if (n == this.rate) {
            this.KeccakAbsorb(byArray, 0);
        } else {
            int n3 = n;
            int n4 = n3 >>> 6;
            n = n3 & 0x3F;
            n2 = 0;
            for (int k = 0; k < n4; ++k) {
                this.state[k] = this.state[k] ^ Pack.littleEndianToLong(this.dataQueue, n2);
                n2 += 8;
            }
            this.dumpState();
            if (n > 0) {
                long l2 = (1L << n) - 1L;
                this.state[n4] = this.state[n4] ^ Pack.littleEndianToLong(this.dataQueue, n2) & l2;
            }
        }
        KeccakDigest keccakDigest = this;
        int n5 = this.rate - 1 >>> 6;
        keccakDigest.state[n5] = l = keccakDigest.state[n5] ^ Long.MIN_VALUE;
        keccakDigest.bitsInQueue = 0;
        keccakDigest.squeezing = true;
    }

    private void KeccakAbsorb(byte[] byArray, int n) {
        int n2 = this.rate >>> 6;
        for (int k = 0; k < n2; ++k) {
            this.state[k] = this.state[k] ^ Pack.littleEndianToLong(byArray, n);
            n += 8;
        }
        KeccakDigest keccakDigest = this;
        Hex.toHexString(keccakDigest.dumpState()).toLowerCase();
        keccakDigest.KeccakPermutation();
    }

    private void KeccakExtract() {
        KeccakDigest keccakDigest = this;
        keccakDigest.KeccakPermutation();
        keccakDigest.dumpState();
        KeccakDigest keccakDigest2 = this;
        int n = keccakDigest2.rate >>> 6;
        byte[] byArray = keccakDigest2.dataQueue;
        Pack.longToLittleEndian(keccakDigest.state, 0, n, byArray, 0);
        keccakDigest.bitsInQueue = keccakDigest.rate;
    }

    private void KeccakPermutation() {
        Object object = ((KeccakDigest)object).state;
        long l = ((KeccakDigest)object).state[0];
        long l2 = ((KeccakDigest)object).state[1];
        long l3 = ((KeccakDigest)object).state[2];
        long l4 = ((KeccakDigest)object).state[3];
        long l5 = ((KeccakDigest)object).state[4];
        long l6 = ((KeccakDigest)object).state[5];
        long l7 = ((KeccakDigest)object).state[6];
        long l8 = ((KeccakDigest)object).state[7];
        long l9 = ((KeccakDigest)object).state[8];
        long l10 = ((KeccakDigest)object).state[9];
        long l11 = ((KeccakDigest)object).state[10];
        long l12 = ((KeccakDigest)object).state[11];
        long l13 = ((KeccakDigest)object).state[12];
        long l14 = ((KeccakDigest)object).state[13];
        long l15 = ((KeccakDigest)object).state[14];
        long l16 = ((KeccakDigest)object).state[15];
        long l17 = ((KeccakDigest)object).state[16];
        long l18 = ((KeccakDigest)object).state[17];
        long l19 = ((KeccakDigest)object).state[18];
        long l20 = ((KeccakDigest)object).state[19];
        long l21 = ((KeccakDigest)object).state[20];
        long l22 = ((KeccakDigest)object).state[21];
        long l23 = ((KeccakDigest)object).state[22];
        long l24 = ((KeccakDigest)object).state[23];
        long l25 = ((KeccakDigest)object).state[24];
        for (int k = 0; k < 24; ++k) {
            long l26 = l;
            l = l26 ^ l6 ^ l11 ^ l16 ^ l21;
            long l27 = l2 ^ l7 ^ l12 ^ l17 ^ l22;
            long l28 = l3 ^ l8 ^ l13 ^ l18 ^ l23;
            long l29 = l4 ^ l9 ^ l14 ^ l19 ^ l24;
            long l30 = l5 ^ l10 ^ l15 ^ l20 ^ l25;
            long l31 = (l27 << 1 | l27 >>> -1) ^ l30;
            long l32 = (l28 << 1 | l28 >>> -1) ^ l;
            l27 = (l29 << 1 | l29 >>> -1) ^ l27;
            l28 = (l30 << 1 | l30 >>> -1) ^ l28;
            l = (l << 1 | l >>> -1) ^ l29;
            l29 = l26 ^ l31;
            long l33 = l7;
            long l34 = l2;
            l2 = l6 ^ l31;
            l6 = l11 ^ l31;
            l7 = l16 ^ l31;
            l11 = l21 ^ l31;
            l16 = l34 ^ l32;
            l21 = l33 ^ l32;
            long l35 = l;
            long l36 = l20;
            long l37 = l;
            long l38 = l15;
            long l39 = l;
            long l40 = l10;
            long l41 = l;
            long l42 = l5;
            long l43 = l;
            long l44 = l14;
            long l45 = l9;
            long l46 = l4;
            long l47 = l3;
            l = l12 ^ l32;
            l3 = l17 ^ l32;
            l4 = l22 ^ l32;
            l5 = l47 ^ l27;
            l8 ^= l27;
            l9 = l13 ^ l27;
            l10 = l18 ^ l27;
            l12 = l23 ^ l27;
            l13 = l46 ^ l28;
            l14 = l45 ^ l28;
            l15 = l44 ^ l28;
            l17 = l19 ^ l28;
            l18 = l24 ^ l28;
            l19 = l42 ^ l43;
            l20 = l40 ^ l41;
            l22 = l38 ^ l39;
            l23 = l36 ^ l37;
            l24 = l25 ^ l35;
            l16 = l16 << 1 | l16 >>> 63;
            l21 = l21 << 44 | l21 >>> 20;
            l20 = l20 << 20 | l20 >>> 44;
            l12 = l12 << 61 | l12 >>> 3;
            l22 = l22 << 39 | l22 >>> 25;
            l11 = l11 << 18 | l11 >>> 46;
            l5 = l5 << 62 | l5 >>> 2;
            l9 = l9 << 43 | l9 >>> 21;
            l15 = l15 << 25 | l15 >>> 39;
            l23 = l23 << 8 | l23 >>> 56;
            l18 = l18 << 56 | l18 >>> 8;
            l7 = l7 << 41 | l7 >>> 23;
            l19 = l19 << 27 | l19 >>> 37;
            l24 = l24 << 14 | l24 >>> 50;
            l4 = l4 << 2 | l4 >>> 62;
            l14 = l14 << 55 | l14 >>> 9;
            l3 = l3 << 45 | l3 >>> 19;
            l2 = l2 << 36 | l2 >>> 28;
            l13 = l13 << 28 | l13 >>> 36;
            l17 = l17 << 21 | l17 >>> 43;
            l10 = l10 << 15 | l10 >>> 49;
            l = l << 10 | l >>> 54;
            l8 = l8 << 6 | l8 >>> 58;
            l6 = l6 << 3 | l6 >>> 61;
            long l48 = l29 ^ (l21 ^ 0xFFFFFFFFFFFFFFFFL) & l9;
            long l49 = l4;
            long l50 = l5;
            long l51 = l7;
            long l52 = l4;
            long l53 = l22;
            long l54 = l7;
            long l55 = l22;
            long l56 = l18;
            long l57 = l19;
            long l58 = l10;
            long l59 = l18;
            long l60 = l;
            long l61 = l10;
            long l62 = l;
            long l63 = l11;
            long l64 = l16;
            long l65 = l23;
            long l66 = l11;
            long l67 = l15;
            long l68 = l23;
            long l69 = l15;
            long l70 = l12;
            long l71 = l13;
            long l72 = l3;
            long l73 = l12;
            long l74 = l6;
            long l75 = l3;
            long l76 = l6;
            long l77 = l24;
            long l78 = l17;
            long l79 = l9;
            l9 = l21 ^ (l9 ^ 0xFFFFFFFFFFFFFFFFL) & l17;
            l17 = l79 ^ (l17 ^ 0xFFFFFFFFFFFFFFFFL) & l24;
            l24 = l78 ^ (l24 ^ 0xFFFFFFFFFFFFFFFFL) & l29;
            l21 = l77 ^ (l29 ^ 0xFFFFFFFFFFFFFFFFL) & l21;
            l6 = l13 ^ (l20 ^ 0xFFFFFFFFFFFFFFFFL) & l6;
            l3 = l20 ^ (l76 ^ 0xFFFFFFFFFFFFFFFFL) & l3;
            l12 = l74 ^ (l75 ^ 0xFFFFFFFFFFFFFFFFL) & l12;
            l13 = l72 ^ (l73 ^ 0xFFFFFFFFFFFFFFFFL) & l13;
            l20 = l70 ^ (l71 ^ 0xFFFFFFFFFFFFFFFFL) & l20;
            l15 = l16 ^ (l8 ^ 0xFFFFFFFFFFFFFFFFL) & l15;
            l23 = l8 ^ (l69 ^ 0xFFFFFFFFFFFFFFFFL) & l23;
            l11 = l67 ^ (l68 ^ 0xFFFFFFFFFFFFFFFFL) & l11;
            l16 = l65 ^ (l66 ^ 0xFFFFFFFFFFFFFFFFL) & l16;
            l8 = l63 ^ (l64 ^ 0xFFFFFFFFFFFFFFFFL) & l8;
            l = l19 ^ (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l;
            l10 = l2 ^ (l62 ^ 0xFFFFFFFFFFFFFFFFL) & l10;
            l18 = l60 ^ (l61 ^ 0xFFFFFFFFFFFFFFFFL) & l18;
            l19 = l58 ^ (l59 ^ 0xFFFFFFFFFFFFFFFFL) & l19;
            l2 = l56 ^ (l57 ^ 0xFFFFFFFFFFFFFFFFL) & l2;
            l22 = l5 ^ (l14 ^ 0xFFFFFFFFFFFFFFFFL) & l22;
            l7 = l14 ^ (l55 ^ 0xFFFFFFFFFFFFFFFFL) & l7;
            l4 = l53 ^ (l54 ^ 0xFFFFFFFFFFFFFFFFL) & l4;
            l5 = l51 ^ (l52 ^ 0xFFFFFFFFFFFFFFFFL) & l5;
            l25 = l49 ^ (l50 ^ 0xFFFFFFFFFFFFFFFFL) & l14;
            l14 = l48 ^ KeccakRoundConstants[k];
            long l80 = l14;
            long l81 = l9;
            long l82 = l17;
            long l83 = l24;
            long l84 = l21;
            long l85 = l12;
            long l86 = l13;
            long l87 = l20;
            long l88 = l15;
            long l89 = l23;
            long l90 = l16;
            long l91 = l22;
            l24 = l5;
            l23 = l4;
            l22 = l7;
            l21 = l91;
            l20 = l2;
            l17 = l10;
            l16 = l;
            l15 = l8;
            l14 = l90;
            l13 = l11;
            l12 = l89;
            l11 = l88;
            l10 = l87;
            l9 = l86;
            l8 = l85;
            l7 = l3;
            l5 = l84;
            l4 = l83;
            l3 = l82;
            l2 = l81;
            l = l80;
        }
        Object object2 = object;
        object2[0] = l;
        object2[1] = l2;
        object2[2] = l3;
        object2[3] = l4;
        object2[4] = l5;
        object2[5] = l6;
        object2[6] = l7;
        object2[7] = l8;
        object2[8] = l9;
        object2[9] = l10;
        object2[10] = l11;
        object2[11] = l12;
        object2[12] = l13;
        object2[13] = l14;
        object2[14] = l15;
        object2[15] = l16;
        object2[16] = l17;
        object2[17] = l18;
        object2[18] = l19;
        object2[19] = l20;
        object2[20] = l21;
        object2[21] = l22;
        object2[22] = l23;
        object2[23] = l24;
        object2[24] = l25;
    }

    @Override
    public String getAlgorithmName() {
        return b.a("Keccak-").append(this.fixedOutputLength).toString();
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    @Override
    public void update(byte by) {
        this.absorb(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.absorb(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        KeccakDigest keccakDigest = this;
        long l = this.fixedOutputLength;
        keccakDigest.squeeze(byArray, n, l);
        keccakDigest.reset();
        return keccakDigest.getDigestSize();
    }

    public int doFinal(byte[] byArray, int n, byte by, int n2) {
        if (n2 > 0) {
            this.absorbBits(by, n2);
        }
        KeccakDigest keccakDigest = this;
        long l = this.fixedOutputLength;
        keccakDigest.squeeze(byArray, n, l);
        keccakDigest.reset();
        return keccakDigest.getDigestSize();
    }

    @Override
    public void reset() {
        KeccakDigest keccakDigest = this;
        keccakDigest.init(keccakDigest.fixedOutputLength);
    }

    @Override
    public int getByteLength() {
        return this.rate / 8;
    }

    public void absorb(byte by) {
        int n = this.bitsInQueue;
        if (n % 8 == 0) {
            if (!this.squeezing) {
                byte[] byArray = this.dataQueue;
                this.dataQueue[n >>> 3] = by;
                int n2 = n + 8;
                by = (byte)n2;
                this.bitsInQueue = by;
                if (n2 == this.rate) {
                    this.KeccakAbsorb(byArray, 0);
                    this.bitsInQueue = 0;
                }
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        throw new IllegalStateException("attempt to absorb with odd length queue");
    }

    public void absorb(byte[] byArray, int n, int n2) {
        int n3 = this.bitsInQueue;
        if (n3 % 8 == 0) {
            if (!this.squeezing) {
                int n4 = this.rate >>> 3;
                int n5 = n4 - (n3 >>>= 3);
                if (n2 < n5) {
                    System.arraycopy(byArray, n, this.dataQueue, n3, n2);
                    this.bitsInQueue += n2 << 3;
                    return;
                }
                int n6 = 0;
                if (n3 > 0) {
                    KeccakDigest keccakDigest = this;
                    System.arraycopy(byArray, n, this.dataQueue, n3, n5);
                    n6 = n5 + n6;
                    keccakDigest.KeccakAbsorb(keccakDigest.dataQueue, 0);
                }
                while ((n3 = n2 - n6) >= n4) {
                    this.KeccakAbsorb(byArray, n + n6);
                    n6 += n4;
                }
                int n7 = n + n6;
                System.arraycopy(byArray, n7, this.dataQueue, 0, n3);
                this.bitsInQueue = n3 << 3;
                return;
            }
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        throw new IllegalStateException("attempt to absorb with odd length queue");
    }

    public void absorbBits(int n, int n2) {
        if (n2 >= 1 && n2 <= 7) {
            int n3 = this.bitsInQueue;
            if (n3 % 8 == 0) {
                if (!this.squeezing) {
                    int n4;
                    int n5 = n4 = (1 << n2) - 1;
                    n4 = n3 >>> 3;
                    this.dataQueue[n4] = (byte)(n & n5);
                    this.bitsInQueue = n3 + n2;
                    return;
                }
                throw new IllegalStateException("attempt to absorb while squeezing");
            }
            throw new IllegalStateException("attempt to absorb with odd length queue");
        }
        throw new IllegalArgumentException("'bits' must be in the range 1 to 7");
    }

    public byte[] dumpState() {
        byte[] byArray = new byte[this.state.length * 8];
        int n = 0;
        int n2 = 0;
        while (true) {
            long[] lArray = this.state;
            if (n2 == this.state.length) break;
            Pack.longToLittleEndian(lArray[n2], byArray, n);
            n += 8;
            ++n2;
        }
        return byArray;
    }

    public void squeeze(byte[] byArray, int n, long l) {
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        this.dumpState();
        if (l % 8L == 0L) {
            int n2;
            for (long k = 0L; k < l; k += (long)n2) {
                if (this.bitsInQueue == 0) {
                    this.KeccakExtract();
                }
                KeccakDigest keccakDigest = this;
                n2 = (int)Math.min((long)keccakDigest.bitsInQueue, l - k);
                int n3 = (this.rate - this.bitsInQueue) / 8;
                int n4 = n + (int)(k / 8L);
                int n5 = n2 / 8;
                System.arraycopy(keccakDigest.dataQueue, n3, byArray, n4, n5);
                keccakDigest.bitsInQueue -= n2;
            }
            this.dumpState();
            return;
        }
        throw new IllegalStateException("outputLength not a multiple of 8");
    }
}

