/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;

public class CTSBlockCipher
extends BufferedBlockCipher {
    private int blockSize;

    public CTSBlockCipher(BlockCipher blockCipher) {
        if (!(blockCipher instanceof StreamBlockCipher)) {
            CTSBlockCipher cTSBlockCipher = this;
            this.cipher = blockCipher;
            this.blockSize = blockCipher.getBlockSize();
            cTSBlockCipher.buf = new byte[this.blockSize * 2];
            cTSBlockCipher.bufOff = 0;
            return;
        }
        throw new IllegalArgumentException("CTSBlockCipher can only accept ECB, or CBC ciphers");
    }

    @Override
    public int getUpdateOutputSize(int n) {
        Object object = ((BufferedBlockCipher)object).buf;
        int n2 = (n += ((BufferedBlockCipher)object).bufOff) % ((BufferedBlockCipher)object).buf.length;
        if (n2 == 0) {
            return n - ((Object)object).length;
        }
        return n - n2;
    }

    @Override
    public int getOutputSize(int n) {
        return n + this.bufOff;
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = this.buf;
        if (this.bufOff == this.buf.length) {
            CTSBlockCipher cTSBlockCipher = this;
            n2 = cTSBlockCipher.cipher.processBlock(byArray2, 0, byArray, n);
            byArray = cTSBlockCipher.buf;
            n = this.blockSize;
            System.arraycopy(cTSBlockCipher.buf, n, byArray, 0, n);
            cTSBlockCipher.bufOff = cTSBlockCipher.blockSize;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        this.buf[n3] = by;
        return n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 >= 0) {
            CTSBlockCipher cTSBlockCipher = object;
            int n4 = cTSBlockCipher.getBlockSize();
            int n5 = cTSBlockCipher.getUpdateOutputSize(n2);
            if (n5 > 0 && n3 + n5 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            n5 = 0;
            byte[] byArray3 = ((BufferedBlockCipher)object).buf;
            int n6 = ((BufferedBlockCipher)object).bufOff;
            int n7 = ((BufferedBlockCipher)object).buf.length - n6;
            if (n2 > n7) {
                int n8 = n;
                CTSBlockCipher cTSBlockCipher2 = object;
                System.arraycopy(byArray, n, byArray3, n6, n7);
                n = cTSBlockCipher2.cipher.processBlock(((BufferedBlockCipher)object).buf, 0, byArray2, n3) + n5;
                System.arraycopy(cTSBlockCipher2.buf, n4, cTSBlockCipher2.buf, 0, n4);
                ((BufferedBlockCipher)object).bufOff = n4;
                n2 -= n7;
                int n9 = n5 = n8 + n7;
                n5 = n;
                n = n9;
                while (n2 > n4) {
                    int n10 = n;
                    int n11 = n2;
                    Object object = object;
                    Object object2 = object;
                    byte[] byArray4 = ((BufferedBlockCipher)object2).buf;
                    System.arraycopy(byArray, n, byArray4, ((BufferedBlockCipher)object2).bufOff, n4);
                    byArray4 = ((BufferedBlockCipher)object).buf;
                    n2 = n3 + n5;
                    n = ((BufferedBlockCipher)object).cipher.processBlock(byArray4, 0, byArray2, n2) + n5;
                    System.arraycopy(((BufferedBlockCipher)object).buf, n4, ((BufferedBlockCipher)object).buf, 0, n4);
                    n2 = n11 - n4;
                    int n12 = n5 = n10 + n4;
                    n5 = n;
                    n = n12;
                }
            }
            CTSBlockCipher cTSBlockCipher3 = object;
            CTSBlockCipher cTSBlockCipher4 = object;
            Object object = cTSBlockCipher4.buf;
            System.arraycopy(byArray, n, object, cTSBlockCipher4.bufOff, n2);
            cTSBlockCipher3.bufOff += n2;
            return n5;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        block14: {
            block18: {
                block17: {
                    byte[] byArray2;
                    int n2;
                    int n3;
                    int n4;
                    block15: {
                        block16: {
                            if (this.bufOff + n > byArray.length) break block14;
                            CTSBlockCipher cTSBlockCipher = this;
                            n4 = cTSBlockCipher.cipher.getBlockSize();
                            n3 = this.bufOff;
                            n2 = n3 - n4;
                            byArray2 = new byte[n4];
                            if (!cTSBlockCipher.forEncryption) break block15;
                            if (n3 < n4) break block16;
                            CTSBlockCipher cTSBlockCipher2 = this;
                            cTSBlockCipher2.cipher.processBlock(this.buf, 0, byArray2, 0);
                            n3 = cTSBlockCipher2.bufOff;
                            if (n3 > n4) {
                                while (true) {
                                    byte[] byArray3 = this.buf;
                                    if (n3 == this.buf.length) break;
                                    byArray3[n3] = byArray2[n3 - n4];
                                    ++n3;
                                }
                                for (n3 = n4; n3 != this.bufOff; ++n3) {
                                    this.buf[n3] = (byte)(this.buf[n3] ^ byArray2[n3 - n4]);
                                }
                                BlockCipher blockCipher = this.cipher;
                                if (blockCipher instanceof CBCBlockCipher) {
                                    ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, n4, byArray, n);
                                } else {
                                    blockCipher.processBlock(this.buf, n4, byArray, n);
                                }
                                System.arraycopy(byArray2, 0, byArray, n += n4, n2);
                            } else {
                                System.arraycopy(byArray2, 0, byArray, n, n4);
                            }
                            break block17;
                        }
                        throw new DataLengthException("need at least one block of input for CTS");
                    }
                    if (n3 < n4) break block18;
                    byte[] byArray4 = new byte[n4];
                    if (n3 > n4) {
                        BlockCipher blockCipher = this.cipher;
                        if (blockCipher instanceof CBCBlockCipher) {
                            ((CBCBlockCipher)blockCipher).getUnderlyingCipher().processBlock(this.buf, 0, byArray2, 0);
                        } else {
                            blockCipher.processBlock(this.buf, 0, byArray2, 0);
                        }
                        for (int k = n4; k != this.bufOff; ++k) {
                            int n5 = k - n4;
                            byArray4[n5] = (byte)(byArray2[n5] ^ this.buf[k]);
                        }
                        CTSBlockCipher cTSBlockCipher = this;
                        System.arraycopy(cTSBlockCipher.buf, n4, byArray2, 0, n2);
                        cTSBlockCipher.cipher.processBlock(byArray2, 0, byArray, n);
                        System.arraycopy(byArray4, 0, byArray, n += n4, n2);
                    } else {
                        this.cipher.processBlock(this.buf, 0, byArray2, 0);
                        System.arraycopy(byArray2, 0, byArray, n, n4);
                    }
                }
                this.reset();
                return this.bufOff;
            }
            throw new DataLengthException("need at least one block of input for CTS");
        }
        throw new OutputLengthException("output buffer to small in doFinal");
    }
}

