/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class HMacSP800DRBG
implements SP80090DRBG {
    private static final long RESEED_MAX = 0x800000000000L;
    private static final int MAX_BITS_REQUEST = 262144;
    private byte[] _K;
    private byte[] _V;
    private long _reseedCounter;
    private EntropySource _entropySource;
    private Mac _hMac;
    private int _securityStrength;

    public HMacSP800DRBG(Mac object, int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n <= Utils.getMaxSecurityStrength((Mac)object)) {
            if (entropySource.entropySize() >= n) {
                Mac mac = object;
                this._securityStrength = n;
                this._entropySource = entropySource;
                this._hMac = object;
                object = Arrays.concatenate(this.getEntropy(), byArray2, byArray);
                byte[] byArray3 = new byte[mac.getMacSize()];
                this._K = byArray3;
                this._V = new byte[byArray3.length];
                Arrays.fill(this._V, (byte)1);
                this.hmac_DRBG_Update((byte[])object);
                this._reseedCounter = 1L;
                return;
            }
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
    }

    private void hmac_DRBG_Update(byte[] byArray) {
        this.hmac_DRBG_Update_Func(byArray, (byte)0);
        if (byArray != null) {
            this.hmac_DRBG_Update_Func(byArray, (byte)1);
        }
    }

    private void hmac_DRBG_Update_Func(byte[] byArray, byte by) {
        HMacSP800DRBG hMacSP800DRBG = this;
        hMacSP800DRBG._hMac.init(new KeyParameter(this._K));
        hMacSP800DRBG._hMac.update(this._V, 0, this._V.length);
        hMacSP800DRBG._hMac.update(by);
        if (byArray != null) {
            this._hMac.update(byArray, 0, byArray.length);
        }
        HMacSP800DRBG hMacSP800DRBG2 = this;
        hMacSP800DRBG2._hMac.doFinal(this._K, 0);
        hMacSP800DRBG2._hMac.init(new KeyParameter(this._K));
        hMacSP800DRBG2._hMac.update(this._V, 0, this._V.length);
        hMacSP800DRBG2._hMac.doFinal(this._V, 0);
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray.length >= (this._securityStrength + 7) / 8) {
            return byArray;
        }
        throw new IllegalStateException("Insufficient entropy provided by entropy source");
    }

    @Override
    public int getBlockSize() {
        return this._V.length * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean n) {
        int n2 = byArray.length * 8;
        if (n2 <= 262144) {
            if (this._reseedCounter > 0x800000000000L) {
                return -1;
            }
            if (n != 0) {
                this.reseed(byArray2);
                byArray2 = null;
            }
            if (byArray2 != null) {
                this.hmac_DRBG_Update(byArray2);
            }
            n = byArray.length;
            byte[] byArray3 = new byte[n];
            int n3 = byArray.length / this._V.length;
            this._hMac.init(new KeyParameter(this._K));
            for (int k = 0; k < n3; ++k) {
                HMacSP800DRBG hMacSP800DRBG = this;
                hMacSP800DRBG._hMac.update(this._V, 0, this._V.length);
                hMacSP800DRBG._hMac.doFinal(this._V, 0);
                int n4 = k * hMacSP800DRBG._V.length;
                int n5 = hMacSP800DRBG._V.length;
                System.arraycopy(hMacSP800DRBG._V, 0, byArray3, n4, n5);
            }
            byte[] byArray4 = this._V;
            if (n3 * this._V.length < n) {
                HMacSP800DRBG hMacSP800DRBG = this;
                hMacSP800DRBG._hMac.update(byArray4, 0, byArray4.length);
                hMacSP800DRBG._hMac.doFinal(this._V, 0);
                byArray4 = hMacSP800DRBG._V;
                int n6 = n;
                n = n3 * byArray4.length;
                n3 = n6 - n3 * byArray4.length;
                System.arraycopy(hMacSP800DRBG._V, 0, byArray3, n, n3);
            }
            HMacSP800DRBG hMacSP800DRBG = this;
            hMacSP800DRBG.hmac_DRBG_Update(byArray2);
            ++hMacSP800DRBG._reseedCounter;
            int n7 = byArray.length;
            System.arraycopy(byArray3, 0, byArray, 0, n7);
            return n2;
        }
        throw new IllegalArgumentException("Number of bits per request limited to 262144");
    }

    @Override
    public void reseed(byte[] byArray) {
        HMacSP800DRBG hMacSP800DRBG = this;
        hMacSP800DRBG.hmac_DRBG_Update(Arrays.concatenate(hMacSP800DRBG.getEntropy(), byArray));
        hMacSP800DRBG._reseedCounter = 1L;
    }
}

