/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DigestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSABlindedEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class RSADigestSigner
implements Signer {
    private static final Hashtable oidMap = new Hashtable<String, ASN1ObjectIdentifier>();
    private final AsymmetricBlockCipher rsaEngine;
    private final AlgorithmIdentifier algId;
    private final Digest digest;
    private boolean forSigning;

    public RSADigestSigner(Digest digest) {
        this(digest, (ASN1ObjectIdentifier)oidMap.get(digest.getAlgorithmName()));
    }

    public RSADigestSigner(Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        RSABlindedEngine rSABlindedEngine;
        PKCS1Encoding pKCS1Encoding;
        PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
        RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
        rSABlindedEngine = new RSABlindedEngine();
        pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
        ((RSADigestSigner)((Object)algorithmIdentifier2)).rsaEngine = pKCS1Encoding2;
        ((RSADigestSigner)((Object)algorithmIdentifier2)).digest = digest;
        if (aSN1ObjectIdentifier != null) {
            AlgorithmIdentifier algorithmIdentifier;
            RSADigestSigner rSADigestSigner = algorithmIdentifier2;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
            rSADigestSigner.algId = algorithmIdentifier2;
        } else {
            ((RSADigestSigner)((Object)algorithmIdentifier2)).algId = null;
        }
    }

    private byte[] derEncode(byte[] byArray) {
        AlgorithmIdentifier algorithmIdentifier = ((RSADigestSigner)((Object)algorithmIdentifier)).algId;
        if (algorithmIdentifier == null) {
            byte[] byArray2;
            try {
                byArray2 = byArray;
                DigestInfo.getInstance(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(b.b.a("malformed DigestInfo for NONEwithRSA hash: ").append(illegalArgumentException.getMessage()).toString());
            }
            return byArray2;
        }
        return new DigestInfo(algorithmIdentifier, byArray).getEncoded("DER");
    }

    static {
        oidMap.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        oidMap.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        oidMap.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        oidMap.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        oidMap.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        oidMap.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        oidMap.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        oidMap.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        oidMap.put("SHA-512/224", NISTObjectIdentifiers.id_sha512_224);
        oidMap.put("SHA-512/256", NISTObjectIdentifiers.id_sha512_256);
        oidMap.put("SHA3-224", NISTObjectIdentifiers.id_sha3_224);
        oidMap.put("SHA3-256", NISTObjectIdentifiers.id_sha3_256);
        oidMap.put("SHA3-384", NISTObjectIdentifiers.id_sha3_384);
        oidMap.put("SHA3-512", NISTObjectIdentifiers.id_sha3_512);
        oidMap.put("MD2", PKCSObjectIdentifiers.md2);
        oidMap.put("MD4", PKCSObjectIdentifiers.md4);
        oidMap.put("MD5", PKCSObjectIdentifiers.md5);
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "withRSA";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        RSADigestSigner rSADigestSigner = this;
        rSADigestSigner.reset();
        rSADigestSigner.rsaEngine.init(bl, cipherParameters);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        if (((RSADigestSigner)object).forSigning) {
            RSADigestSigner rSADigestSigner = object;
            byte[] byArray = new byte[rSADigestSigner.digest.getDigestSize()];
            ((RSADigestSigner)object).digest.doFinal(byArray, 0);
            try {
                Object object = rSADigestSigner.derEncode(byArray);
            }
            catch (IOException iOException) {
                throw new CryptoException(b.a(iOException, b.b.a("unable to encode signature: ")), iOException);
            }
            AsymmetricBlockCipher asymmetricBlockCipher = rSADigestSigner.rsaEngine;
            Object object = object;
            int n = 0;
            return asymmetricBlockCipher.processBlock((byte[])object, n, ((Object)object).length);
        }
        throw new IllegalStateException("RSADigestSigner not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (!this.forSigning) {
            RSADigestSigner rSADigestSigner = this;
            int n = rSADigestSigner.digest.getDigestSize();
            byte[] byArray2 = new byte[n];
            RSADigestSigner rSADigestSigner2 = this;
            rSADigestSigner2.digest.doFinal(byArray2, 0);
            AsymmetricBlockCipher asymmetricBlockCipher = rSADigestSigner2.rsaEngine;
            int n2 = 0;
            byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n2, byArray.length);
            try {
                byArray = rSADigestSigner.derEncode(byArray2);
            }
            catch (Exception exception) {
                return false;
            }
            if (byArray3.length == byArray.length) {
                return Arrays.constantTimeAreEqual(byArray3, byArray);
            }
            if (byArray3.length == byArray.length - 2) {
                byte[] byArray4 = byArray;
                int n3 = byArray3.length - n - 2;
                int n4 = byArray4.length - n - 2;
                byArray4[1] = (byte)(byArray4[1] - 2);
                byArray[3] = (byte)(byArray4[3] - 2);
                int n5 = 0;
                for (int k = 0; k < n; ++k) {
                    n5 |= byArray3[n3 + k] ^ byArray[n4 + k];
                }
                for (n = 0; n < n3; ++n) {
                    n5 |= byArray3[n] ^ byArray[n];
                }
                return n5 == 0;
            }
            Arrays.constantTimeAreEqual(byArray, byArray);
            return false;
        }
        throw new IllegalStateException("RSADigestSigner not initialised for verification");
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

