/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.util.ASN1Dump;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLDistPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.CompositePublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.io.OutputStreamFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.SignatureCreator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLEntryObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509SignatureUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class X509CRLImpl
extends X509CRL {
    public JcaJceHelper bcHelper;
    public CertificateList c;
    public String sigAlgName;
    public byte[] sigAlgParams;
    public boolean isIndirect;

    public X509CRLImpl(JcaJceHelper jcaJceHelper, CertificateList certificateList, String string, byte[] byArray, boolean bl) {
        this.bcHelper = jcaJceHelper;
        this.c = certificateList;
        this.sigAlgName = string;
        this.sigAlgParams = byArray;
        this.isIndirect = bl;
    }

    private Set getExtensionOIDs(boolean bl) {
        if (((X509CRLImpl)this).getVersion() == 2 && (this = ((X509CRLImpl)this).c.getTBSCertList().getExtensions()) != null) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            Enumeration enumeration = ((Extensions)this).oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (bl != ((Extensions)this).getExtension(aSN1ObjectIdentifier).isCritical()) continue;
                hashSet2.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doVerify(PublicKey list, SignatureCreator object) {
        X509CRLImpl x509CRLImpl;
        X509CRLImpl x509CRLImpl2;
        Object object2;
        if (!((X509CRLImpl)object2).c.getSignatureAlgorithm().equals(((X509CRLImpl)object2).c.getTBSCertList().getSignature())) throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        if (list instanceof CompositePublicKey && X509SignatureUtil.isCompositeAlgorithm(((X509CRLImpl)object2).c.getSignatureAlgorithm())) {
            X509CRLImpl x509CRLImpl3 = object2;
            list = ((CompositePublicKey)((Object)list)).getPublicKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(x509CRLImpl3.c.getSignatureAlgorithm().getParameters());
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(DERBitString.getInstance(x509CRLImpl3.c.getSignature()).getBytes());
            boolean bl = false;
            for (int k = 0; k != list.size(); ++k) {
                if (list.get(k) == null) continue;
                AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(k));
                Object object3 = algorithmIdentifier;
                object3 = object.createSignature(X509SignatureUtil.getSignatureName((AlgorithmIdentifier)object3));
                SignatureException signatureException = null;
                PublicKey publicKey = list.get(k);
                ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
                byte[] byArray = DERBitString.getInstance(aSN1Sequence2.getObjectAt(k)).getBytes();
                try {
                    super.checkSignature(publicKey, (Signature)object3, aSN1Encodable, byArray);
                    bl = true;
                }
                catch (SignatureException signatureException2) {
                    signatureException = signatureException2;
                }
                if (signatureException != null) throw signatureException;
            }
            if (bl) return;
            throw new InvalidKeyException("no matching key found");
        }
        if (X509SignatureUtil.isCompositeAlgorithm(((X509CRLImpl)object2).c.getSignatureAlgorithm())) {
            X509CRLImpl x509CRLImpl4 = object2;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(x509CRLImpl4.c.getSignatureAlgorithm().getParameters());
            ASN1Sequence aSN1Sequence3 = ASN1Sequence.getInstance(DERBitString.getInstance(x509CRLImpl4.c.getSignature()).getBytes());
            boolean bl = false;
            for (int k = 0; k != aSN1Sequence3.size(); ++k) {
                AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(k));
                Object var7_15 = null;
                Signature signature = object.createSignature(X509SignatureUtil.getSignatureName(algorithmIdentifier));
                ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
                byte[] byArray = DERBitString.getInstance(aSN1Sequence3.getObjectAt(k)).getBytes();
                try {
                    super.checkSignature((PublicKey)((Object)list), signature, aSN1Encodable, byArray);
                    bl = true;
                }
                catch (SignatureException signatureException) {
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (InvalidKeyException invalidKeyException) {}
                if (var7_15 != null) throw var7_15;
            }
            if (bl) return;
            throw new InvalidKeyException("no matching key found");
        }
        object = object.createSignature(((X509CRLImpl)object2).getSigAlgName());
        byte[] byArray = ((X509CRLImpl)object2).sigAlgParams;
        if (((X509CRLImpl)object2).sigAlgParams == null) {
            X509CRLImpl x509CRLImpl5 = object2;
            object2 = x509CRLImpl5.getSignature();
            x509CRLImpl5.checkSignature((PublicKey)((Object)list), (Signature)object, null, (byte[])object2);
            return;
        }
        try {
            X509CRLImpl x509CRLImpl6 = object2;
            x509CRLImpl2 = x509CRLImpl6;
            x509CRLImpl = x509CRLImpl6;
            object2 = ASN1Primitive.fromByteArray(byArray);
        }
        catch (IOException iOException) {
            throw new SignatureException(b.a(iOException, b.b.a("cannot decode signature parameters: ")));
        }
        byArray = x509CRLImpl2.getSignature();
        x509CRLImpl.checkSignature((PublicKey)((Object)list), (Signature)object, (ASN1Encodable)object2, byArray);
    }

    private void checkSignature(PublicKey object, Signature signature, ASN1Encodable aSN1Encodable, byte[] byArray) {
        BufferedOutputStream bufferedOutputStream;
        if (aSN1Encodable != null) {
            X509SignatureUtil.setSignatureParameters(signature, aSN1Encodable);
        }
        signature.initVerify((PublicKey)object);
        object = bufferedOutputStream;
        try {
            ((BufferedOutputStream)object)(OutputStreamFactory.createStream(signature), 512);
            this.c.getTBSCertList().encodeTo((OutputStream)object, "DER");
            ((OutputStream)bufferedOutputStream).close();
            if (signature.verify(byArray)) {
                return;
            }
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    private Set loadCRLEntries() {
        HashSet<X509CRLEntryObject> hashSet;
        HashSet<X509CRLEntryObject> hashSet2 = hashSet;
        hashSet = new HashSet<X509CRLEntryObject>();
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (TBSCertList.CRLEntry)enumeration.nextElement();
            hashSet2.add(new X509CRLEntryObject((TBSCertList.CRLEntry)aSN1Object, this.isIndirect, x500Name));
            if (!this.isIndirect || !((TBSCertList.CRLEntry)aSN1Object).hasExtensions() || (aSN1Object = ((TBSCertList.CRLEntry)aSN1Object).getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(((Extension)aSN1Object).getParsedValue()).getNames()[0].getName());
        }
        return hashSet2;
    }

    public static byte[] getExtensionOctets(CertificateList aSN1Object, String string) {
        if ((aSN1Object = X509CRLImpl.getExtensionValue((CertificateList)aSN1Object, string)) != null) {
            return ((ASN1OctetString)aSN1Object).getOctets();
        }
        return null;
    }

    public static ASN1OctetString getExtensionValue(CertificateList aSN1Object, String string) {
        if ((aSN1Object = ((CertificateList)aSN1Object).getTBSCertList().getExtensions()) != null) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1Object aSN1Object2 = aSN1Object;
            aSN1Object = aSN1ObjectIdentifier;
            aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
            if ((aSN1Object = ((Extensions)aSN1Object2).getExtension((ASN1ObjectIdentifier)aSN1Object)) != null) {
                return ((Extension)aSN1Object).getExtnValue();
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if ((this = ((X509CRLImpl)this).getCriticalExtensionOIDs()) == null) {
            return false;
        }
        Object object = this;
        object.remove(Extension.issuingDistributionPoint.getId());
        object.remove(Extension.deltaCRLIndicator.getId());
        return object.isEmpty() ^ true;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        ASN1OctetString aSN1OctetString = X509CRLImpl.getExtensionValue(((X509CRLImpl)((Object)aSN1OctetString)).c, string);
        if (aSN1OctetString != null) {
            try {
                return aSN1OctetString.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException(d.a(exception, b.b.a("error parsing ")));
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    @Override
    public void verify(PublicKey publicKey) {
        SignatureCreator signatureCreator;
        SignatureCreator signatureCreator2 = signatureCreator;
        signatureCreator = new SignatureCreator(){

            @Override
            public Signature createSignature(String string) {
                try {
                    return X509CRLImpl.this.bcHelper.createSignature(string);
                }
                catch (Exception exception) {
                    return Signature.getInstance(string);
                }
            }
        };
        this.doVerify(publicKey, signatureCreator2);
    }

    @Override
    public void verify(PublicKey publicKey, final String string) {
        SignatureCreator signatureCreator;
        SignatureCreator signatureCreator2 = signatureCreator;
        signatureCreator = new SignatureCreator(){

            @Override
            public Signature createSignature(String string3) {
                String string2 = string2.string;
                if (string2 != null) {
                    return Signature.getInstance(string3, string2);
                }
                return Signature.getInstance(string3);
            }
        };
        this.doVerify(publicKey, signatureCreator2);
    }

    @Override
    public void verify(PublicKey publicKey, final Provider provider) {
        SignatureCreator signatureCreator;
        X509CRLImpl x509CRLImpl;
        try {
            x509CRLImpl = this;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(b.b.a("provider issue: ").append(noSuchProviderException.getMessage()).toString());
        }
        SignatureCreator signatureCreator2 = signatureCreator;
        signatureCreator = new SignatureCreator(){

            @Override
            public Signature createSignature(String string) {
                if (provider != null) {
                    return Signature.getInstance(X509CRLImpl.this.getSigAlgName(), provider);
                }
                return Signature.getInstance(X509CRLImpl.this.getSigAlgName());
            }
        };
        x509CRLImpl.doVerify(publicKey, signatureCreator2);
    }

    @Override
    public int getVersion() {
        return this.c.getVersionNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(X500Name.getInstance(this.c.getIssuer().toASN1Primitive()));
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.c.getIssuer().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (TBSCertList.CRLEntry)enumeration.nextElement();
            if (((TBSCertList.CRLEntry)aSN1Object).getUserCertificate().hasValue(bigInteger)) {
                return new X509CRLEntryObject((TBSCertList.CRLEntry)aSN1Object, this.isIndirect, x500Name);
            }
            if (!this.isIndirect || !((TBSCertList.CRLEntry)aSN1Object).hasExtensions() || (aSN1Object = ((TBSCertList.CRLEntry)aSN1Object).getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(((Extension)aSN1Object).getParsedValue()).getNames()[0].getName());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        if (!(this = ((X509CRLImpl)this).loadCRLEntries()).isEmpty()) {
            return Collections.unmodifiableSet(this);
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getOctets();
    }

    @Override
    public String getSigAlgName() {
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return Arrays.clone(this.sigAlgParams);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer;
        X509CRLImpl x509CRLImpl = iterator;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = Strings.lineSeparator();
        new StringBuffer().append("              Version: ").append(((X509CRLImpl)((Object)iterator)).getVersion()).append(string);
        stringBuffer2.append("             IssuerDN: ").append(((X509CRLImpl)((Object)iterator)).getIssuerDN()).append(string);
        stringBuffer2.append("          This update: ").append(((X509CRLImpl)((Object)iterator)).getThisUpdate()).append(string);
        stringBuffer2.append("          Next update: ").append(((X509CRLImpl)((Object)iterator)).getNextUpdate()).append(string);
        stringBuffer2.append("  Signature Algorithm: ").append(((X509CRLImpl)((Object)iterator)).getSigAlgName()).append(string);
        X509SignatureUtil.prettyPrintSignature(x509CRLImpl.getSignature(), stringBuffer2, string);
        Extensions extensions = x509CRLImpl.c.getTBSCertList().getExtensions();
        if (extensions != null) {
            Enumeration enumeration = extensions.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer2.append("           Extensions: ").append(string);
            }
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (extension.getExtnValue() != null) {
                    ASN1InputStream aSN1InputStream;
                    byte[] byArray = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream2 = aSN1InputStream;
                    aSN1InputStream = new ASN1InputStream(byArray);
                    stringBuffer2.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        StringBuffer stringBuffer3;
                        if (aSN1ObjectIdentifier.equals(Extension.cRLNumber)) {
                            stringBuffer3 = stringBuffer2.append(new CRLNumber(ASN1Integer.getInstance(aSN1InputStream2.readObject()).getPositiveValue()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.deltaCRLIndicator)) {
                            stringBuffer3 = stringBuffer2.append("Base CRL: " + new CRLNumber(ASN1Integer.getInstance(aSN1InputStream2.readObject()).getPositiveValue()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.issuingDistributionPoint)) {
                            stringBuffer3 = stringBuffer2.append(IssuingDistributionPoint.getInstance(aSN1InputStream2.readObject()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.cRLDistributionPoints)) {
                            stringBuffer3 = stringBuffer2.append(CRLDistPoint.getInstance(aSN1InputStream2.readObject()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.freshestCRL)) {
                            stringBuffer3 = stringBuffer2.append(CRLDistPoint.getInstance(aSN1InputStream2.readObject()));
                        } else {
                            StringBuffer stringBuffer4 = stringBuffer2;
                            stringBuffer4.append(aSN1ObjectIdentifier.getId());
                            stringBuffer3 = stringBuffer4.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream2.readObject()));
                        }
                        stringBuffer3.append(string);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer5 = stringBuffer2;
                        stringBuffer5.append(aSN1ObjectIdentifier.getId());
                        stringBuffer5.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer2.append(string);
            }
        }
        if ((iterator = ((X509CRLImpl)((Object)iterator)).getRevokedCertificates()) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                stringBuffer2.append(iterator.next());
                stringBuffer2.append(string);
            }
        }
        return stringBuffer2.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRevoked(Certificate certificate) {
        Object object;
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = ((X509CRLImpl)object).c.getRevokedCertificateEnumeration();
        X500Name x500Name = ((X509CRLImpl)object).c.getIssuer();
        if (!enumeration.hasMoreElements()) return false;
        X509Certificate x509Certificate = (X509Certificate)certificate;
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        while (enumeration.hasMoreElements()) {
            Extension extension;
            TBSCertList.CRLEntry cRLEntry = TBSCertList.CRLEntry.getInstance(enumeration.nextElement());
            if (((X509CRLImpl)object).isIndirect && cRLEntry.hasExtensions() && (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) != null) {
                x500Name = X500Name.getInstance(GeneralNames.getInstance(extension.getParsedValue()).getNames()[0].getName());
            }
            if (!cRLEntry.getUserCertificate().hasValue(bigInteger)) continue;
            if (certificate instanceof X509Certificate) {
                object = X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded());
                return x500Name.equals(object);
            }
            try {
                object = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(certificate.getEncoded()).getIssuer();
                return x500Name.equals(object);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException(b.b.a("Cannot process certificate: ").append(certificateEncodingException.getMessage()).toString());
            }
        }
        return false;
    }
}

