/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP384R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP384R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF"));
    public int[] x;

    public SecP384R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP384R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP384R1FieldElement");
    }

    public SecP384R1FieldElement() {
        this.x = Nat.create(12);
    }

    public SecP384R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat.isZero(12, this.x);
    }

    @Override
    public boolean isOne() {
        return Nat.isOne(12, this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat.toBigInteger(12, this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP384R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.add(secP384R1FieldElement.x, ((SecP384R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.addOne(secP384R1FieldElement.x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.subtract(secP384R1FieldElement.x, ((SecP384R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.multiply(secP384R1FieldElement.x, ((SecP384R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.inv(((SecP384R1FieldElement)eCFieldElement).x, nArray);
        SecP384R1Field.multiply(nArray, this.x, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.negate(secP384R1FieldElement.x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.square(secP384R1FieldElement.x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP384R1FieldElement secP384R1FieldElement = object;
        Object object = Nat.create(12);
        SecP384R1Field.inv(secP384R1FieldElement.x, (int[])object);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        Object object = ((SecP384R1FieldElement)object2).x;
        if (!Nat.isZero(12, object) && !Nat.isOne(12, object)) {
            int[] nArray;
            int[] nArray2 = Nat.create(12);
            Object object2 = nArray2;
            int[] nArray3 = nArray = Nat.create(12);
            int[] nArray4 = nArray;
            int[] nArray5 = Nat.create(12);
            int[] nArray6 = nArray;
            int[] nArray7 = Nat.create(12);
            int[] nArray8 = nArray;
            int[] nArray9 = nArray;
            Object object3 = object2;
            SecP384R1Field.square(object, (int[])object2);
            SecP384R1Field.multiply((int[])object3, object, (int[])object2);
            SecP384R1Field.squareN((int[])object3, 2, nArray);
            SecP384R1Field.multiply(nArray9, (int[])object3, nArray);
            SecP384R1Field.square(nArray, nArray9);
            SecP384R1Field.multiply(nArray8, object, nArray);
            SecP384R1Field.squareN(nArray8, 5, nArray5);
            SecP384R1Field.multiply(nArray5, nArray, nArray5);
            SecP384R1Field.squareN(nArray5, 5, nArray7);
            SecP384R1Field.multiply(nArray7, nArray, nArray7);
            SecP384R1Field.squareN(nArray7, 15, nArray);
            SecP384R1Field.multiply(nArray, nArray7, nArray);
            SecP384R1Field.squareN(nArray, 2, nArray5);
            SecP384R1Field.multiply((int[])object2, nArray5, (int[])object2);
            SecP384R1Field.squareN(nArray5, 28, nArray5);
            SecP384R1Field.multiply(nArray6, nArray5, nArray);
            SecP384R1Field.squareN(nArray6, 60, nArray5);
            SecP384R1Field.multiply(nArray5, nArray, nArray5);
            SecP384R1Field.squareN(nArray5, 120, nArray);
            SecP384R1Field.multiply(nArray3, nArray5, nArray);
            SecP384R1Field.squareN(nArray4, 15, nArray);
            SecP384R1Field.multiply(nArray3, nArray7, nArray);
            SecP384R1Field.squareN(nArray4, 33, nArray);
            SecP384R1Field.multiply(nArray, (int[])object2, nArray);
            SecP384R1Field.squareN(nArray, 64, nArray);
            SecP384R1Field.multiply(nArray, object, nArray);
            SecP384R1Field.squareN(nArray, 30, (int[])object2);
            SecP384R1Field.square(nArray2, nArray);
            if (Nat.eq(12, object, nArray)) {
                SecP384R1FieldElement secP384R1FieldElement;
                object = secP384R1FieldElement;
                secP384R1FieldElement = new SecP384R1FieldElement((int[])object2);
            } else {
                object = null;
            }
            return object;
        }
        return object2;
    }

    public boolean equals(Object object) {
        if (object == object2) {
            return true;
        }
        if (!(object instanceof SecP384R1FieldElement)) {
            return false;
        }
        Object object2 = ((SecP384R1FieldElement)object2).x;
        object = ((SecP384R1FieldElement)object).x;
        return Nat.eq(12, (int[])object2, (int[])object);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 12);
    }
}

