/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[k] & 0xFFFFFFFFL) + ((long)nArray2[k] & 0xFFFFFFFFL) + l;
            nArray3[k] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int add33At(int n, int n2, int[] nArray, int n3) {
        int n4 = n3 + 0;
        long l = ((long)nArray[n4] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        long l2 = l >>> 32;
        n2 = n3 + 1;
        l2 = ((long)nArray[n2] & 0xFFFFFFFFL) + 1L + l2;
        nArray[n2] = (int)l2;
        return l2 >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n3 + 2);
    }

    public static int add33At(int n, int n2, int[] nArray, int n3, int n4) {
        int n5;
        int n6 = n3 + n4;
        long l = ((long)nArray[n6] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        nArray[n6] = (int)l;
        n2 = n6 + 1;
        long l2 = ((long)nArray[n2] & 0xFFFFFFFFL) + 1L + (l >>>= 32);
        nArray[n2] = (int)l2;
        if (l2 >>> 32 == 0L) {
            n5 = 0;
        } else {
            int n7 = n;
            n = n4 + 2;
            n5 = Nat.incAt(n7, nArray, n3, n);
        }
        return n5;
    }

    public static int add33To(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        l >>>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + 1L + l;
        nArray[1] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, 2);
    }

    public static int add33To(int n, int n2, int[] nArray, int n3) {
        int n4 = n3 + 0;
        long l = ((long)nArray[n4] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        long l2 = l >>> 32;
        n2 = n3 + 1;
        l2 = ((long)nArray[n2] & 0xFFFFFFFFL) + 1L + l2;
        nArray[n2] = (int)l2;
        return l2 >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n3, 2);
    }

    public static int addBothTo(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[k] & 0xFFFFFFFFL) + ((long)nArray2[k] & 0xFFFFFFFFL) + ((long)nArray3[k] & 0xFFFFFFFFL) + l;
            nArray3[k] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addBothTo(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n5 = n4 + k;
            l = ((long)nArray[n2 + k] & 0xFFFFFFFFL) + ((long)nArray2[n3 + k] & 0xFFFFFFFFL) + ((long)nArray3[n5] & 0xFFFFFFFFL) + l;
            nArray3[n5] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addDWordAt(int n, long l, int[] nArray, int n2) {
        int n3 = n2 + 0;
        long l2 = ((long)nArray[n3] & 0xFFFFFFFFL) + (l & 0xFFFFFFFFL);
        nArray[n3] = (int)l2;
        long l3 = l2 >>> 32;
        int n4 = n2 + 1;
        l = ((long)nArray[n4] & 0xFFFFFFFFL) + (l >>> 32) + l3;
        nArray[n4] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n2 + 2);
    }

    public static int addDWordAt(int n, long l, int[] nArray, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        long l2 = ((long)nArray[n5] & 0xFFFFFFFFL) + (l & 0xFFFFFFFFL);
        nArray[n5] = (int)l2;
        l = ((long)nArray[++n5] & 0xFFFFFFFFL) + (l >>> 32) + (l2 >>>= 32);
        nArray[n5] = (int)l;
        if (l >>> 32 == 0L) {
            n4 = 0;
        } else {
            int n6 = n;
            n = n3 + 2;
            n4 = Nat.incAt(n6, nArray, n2, n);
        }
        return n4;
    }

    public static int addDWordTo(int n, long l, int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + (l & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        l = ((long)nArray[1] & 0xFFFFFFFFL) + (l >>> 32) + (l2 >>>= 32);
        nArray[1] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, 2);
    }

    public static int addDWordTo(int n, long l, int[] nArray, int n2) {
        int n3 = n2 + 0;
        long l2 = ((long)nArray[n3] & 0xFFFFFFFFL) + (l & 0xFFFFFFFFL);
        nArray[n3] = (int)l2;
        long l3 = l2 >>> 32;
        int n4 = n2 + 1;
        l = ((long)nArray[n4] & 0xFFFFFFFFL) + (l >>> 32) + l3;
        nArray[n4] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n2, 2);
    }

    public static int addTo(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[k] & 0xFFFFFFFFL) + ((long)nArray2[k] & 0xFFFFFFFFL) + l;
            nArray2[k] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addTo(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n4 = n3 + k;
            l = ((long)nArray[n2 + k] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + l;
            nArray2[n4] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addTo(int n, int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        long l = (long)n4 & 0xFFFFFFFFL;
        for (n4 = 0; n4 < n; ++n4) {
            int n5 = n3 + n4;
            l = ((long)nArray[n2 + n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addToEachOther(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n4;
            int n5 = n2 + k;
            int n6 = n3 + k;
            l = ((long)nArray[n5] & 0xFFFFFFFFL) + ((long)nArray2[n6] & 0xFFFFFFFFL) + l;
            nArray[n5] = n4 = (int)l;
            nArray2[n6] = n4;
            l >>>= 32;
        }
        return (int)l;
    }

    public static int addWordAt(int n, int n2, int[] nArray, int n3) {
        long l = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL);
        nArray[n3] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n3 + 1);
    }

    public static int addWordAt(int n, int n2, int[] nArray, int n3, int n4) {
        int n5;
        long l = (long)n2 & 0xFFFFFFFFL;
        n2 = n3 + n4;
        long l2 = l + ((long)nArray[n2] & 0xFFFFFFFFL);
        nArray[n2] = (int)l2;
        if (l2 >>> 32 == 0L) {
            n5 = 0;
        } else {
            int n6 = n;
            n = n4 + 1;
            n5 = Nat.incAt(n6, nArray, n3, n);
        }
        return n5;
    }

    public static int addWordTo(int n, int n2, int[] nArray) {
        long l = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, 1);
    }

    public static int addWordTo(int n, int n2, int[] nArray, int n3) {
        long l = ((long)n2 & 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL);
        nArray[n3] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n3, 1);
    }

    public static int cadd(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)(-(n2 & 1)) & 0xFFFFFFFFL;
        long l2 = 0L;
        for (n2 = 0; n2 < n; ++n2) {
            l2 = ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n2] & l) + l2;
            nArray3[n2] = (int)l2;
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static void cmov(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        n2 = -(n2 & 1);
        for (int k = 0; k < n; ++k) {
            int n5 = n4 + k;
            int n6 = nArray2[n5];
            nArray2[n5] = n6 ^ (n6 ^ nArray[n3 + k]) & n2;
        }
    }

    public static int compare(int n, int[] nArray, int[] nArray2) {
        --n;
        while (n >= 0) {
            int n2 = nArray[n] ^ Integer.MIN_VALUE;
            int n3 = nArray2[n] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            --n;
        }
        return 0;
    }

    public static int compare(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        --n;
        while (n >= 0) {
            int n4 = nArray[n2 + n] ^ Integer.MIN_VALUE;
            int n5 = nArray2[n3 + n] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return -1;
            }
            if (n4 > n5) {
                return 1;
            }
            --n;
        }
        return 0;
    }

    public static int[] copy(int n, int[] nArray) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static void copy(int n, int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, n);
    }

    public static void copy(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        System.arraycopy(nArray, n2, nArray2, n3, n);
    }

    public static long[] copy64(int n, long[] lArray) {
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, n);
        return lArray2;
    }

    public static void copy64(int n, long[] lArray, long[] lArray2) {
        System.arraycopy(lArray, 0, lArray2, 0, n);
    }

    public static void copy64(int n, long[] lArray, int n2, long[] lArray2, int n3) {
        System.arraycopy(lArray, n2, lArray2, n3, n);
    }

    public static int[] create(int n) {
        return new int[n];
    }

    public static long[] create64(int n) {
        return new long[n];
    }

    public static int csub(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)(-(n2 & 1)) & 0xFFFFFFFFL;
        long l2 = 0L;
        for (n2 = 0; n2 < n; ++n2) {
            l2 = ((long)nArray[n2] & 0xFFFFFFFFL) - ((long)nArray2[n2] & l) + l2;
            nArray3[n2] = (int)l2;
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int csub(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        long l = (long)(-(n2 & 1)) & 0xFFFFFFFFL;
        long l2 = 0L;
        for (n2 = 0; n2 < n; ++n2) {
            l2 = ((long)nArray[n3 + n2] & 0xFFFFFFFFL) - ((long)nArray2[n4 + n2] & l) + l2;
            int n6 = n5 + n2;
            nArray3[n6] = (int)l2;
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int dec(int n, int[] nArray) {
        for (int k = 0; k < n; ++k) {
            int n2;
            nArray[k] = n2 = nArray[k] - 1;
            if (n2 == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int dec(int n, int[] nArray, int[] nArray2) {
        for (int k = 0; k < n; ++k) {
            int n2;
            nArray2[k] = n2 = nArray[k] - 1;
            if (n2 == -1) continue;
            while (k < n) {
                nArray2[k] = nArray[k];
                ++k;
            }
            return 0;
        }
        return -1;
    }

    public static int decAt(int n, int[] nArray, int n2) {
        while (n2 < n) {
            int n3;
            nArray[n2] = n3 = nArray[n2] - 1;
            if (n3 != -1) {
                return 0;
            }
            ++n2;
        }
        return -1;
    }

    public static int decAt(int n, int[] nArray, int n2, int n3) {
        while (n3 < n) {
            int n4;
            int n5 = n2 + n3;
            nArray[n5] = n4 = nArray[n5] - 1;
            if (n4 != -1) {
                return 0;
            }
            ++n3;
        }
        return -1;
    }

    public static boolean diff(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        boolean bl = Nat.gte(n, nArray, n2, nArray2, n3);
        if (bl) {
            Nat.sub(n, nArray, n2, nArray2, n3, nArray3, n4);
        } else {
            Nat.sub(n, nArray2, n3, nArray, n2, nArray3, n4);
        }
        return bl;
    }

    public static boolean eq(int n, int[] nArray, int[] nArray2) {
        --n;
        while (n >= 0) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static int equalTo(int n, int[] nArray, int n2) {
        n2 = nArray[0] ^ n2;
        for (int k = 1; k < n; ++k) {
            n2 |= nArray[k];
        }
        return (n2 >>> 1 | n2 & 1) - 1 >> 31;
    }

    public static int equalTo(int n, int[] nArray, int n2, int n3) {
        n3 = nArray[n2] ^ n3;
        for (int k = 1; k < n; ++k) {
            n3 |= nArray[n2 + k];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static int equalTo(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        for (int k = 0; k < n; ++k) {
            n2 |= nArray[k] ^ nArray2[k];
        }
        return (n2 >>> 1 | n2 & 1) - 1 >> 31;
    }

    public static int equalTo(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = 0;
        for (int k = 0; k < n; ++k) {
            n4 |= nArray[n2 + k] ^ nArray2[n3 + k];
        }
        return (n4 >>> 1 | n4 & 1) - 1 >> 31;
    }

    public static int equalToZero(int n, int[] nArray) {
        int n2 = 0;
        for (int k = 0; k < n; ++k) {
            n2 |= nArray[k];
        }
        return (n2 >>> 1 | n2 & 1) - 1 >> 31;
    }

    public static int equalToZero(int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int k = 0; k < n; ++k) {
            n3 |= nArray[n2 + k];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static int[] fromBigInteger(int n, BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= n) {
            n = n + 31 >> 5;
            int[] nArray = Nat.create(n);
            for (int k = 0; k < n; ++k) {
                nArray[k] = bigInteger.intValue();
                bigInteger = bigInteger.shiftRight(32);
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    public static long[] fromBigInteger64(int n, BigInteger bigInteger) {
        if (bigInteger.signum() >= 0 && bigInteger.bitLength() <= n) {
            n = n + 63 >> 6;
            long[] lArray = Nat.create64(n);
            for (int k = 0; k < n; ++k) {
                long l;
                lArray[k] = l = bigInteger.longValue();
                bigInteger = bigInteger.shiftRight(64);
            }
            return lArray;
        }
        throw new IllegalArgumentException();
    }

    public static int getBit(int[] nArray, int n) {
        if (n == 0) {
            return nArray[0] & 1;
        }
        int n2 = n >> 5;
        if (n2 >= 0 && n2 < nArray.length) {
            int n3 = n & 0x1F;
            return nArray[n2] >>> n3 & 1;
        }
        return 0;
    }

    public static boolean gte(int n, int[] nArray, int[] nArray2) {
        --n;
        while (n >= 0) {
            int n2 = nArray[n] ^ Integer.MIN_VALUE;
            int n3 = nArray2[n] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 > n3) {
                return true;
            }
            --n;
        }
        return true;
    }

    public static boolean gte(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        --n;
        while (n >= 0) {
            int n4 = nArray[n2 + n] ^ Integer.MIN_VALUE;
            int n5 = nArray2[n3 + n] ^ Integer.MIN_VALUE;
            if (n4 < n5) {
                return false;
            }
            if (n4 > n5) {
                return true;
            }
            --n;
        }
        return true;
    }

    public static int inc(int n, int[] nArray) {
        for (int k = 0; k < n; ++k) {
            int n2;
            nArray[k] = n2 = nArray[k] + 1;
            if (n2 == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int n, int[] nArray, int[] nArray2) {
        for (int k = 0; k < n; ++k) {
            int n2;
            nArray2[k] = n2 = nArray[k] + 1;
            if (n2 == 0) continue;
            while (k < n) {
                nArray2[k] = nArray[k];
                ++k;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int n, int[] nArray, int n2) {
        while (n2 < n) {
            int n3;
            nArray[n2] = n3 = nArray[n2] + 1;
            if (n3 != 0) {
                return 0;
            }
            ++n2;
        }
        return 1;
    }

    public static int incAt(int n, int[] nArray, int n2, int n3) {
        while (n3 < n) {
            int n4;
            int n5 = n2 + n3;
            nArray[n5] = n4 = nArray[n5] + 1;
            if (n4 != 0) {
                return 0;
            }
            ++n3;
        }
        return 1;
    }

    public static boolean isOne(int n, int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int k = 1; k < n; ++k) {
            if (nArray[k] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int n, int[] nArray) {
        for (int k = 0; k < n; ++k) {
            if (nArray[k] == 0) continue;
            return false;
        }
        return true;
    }

    public static int lessThan(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[k] & 0xFFFFFFFFL) - ((long)nArray2[k] & 0xFFFFFFFFL) + l >> 32;
        }
        return (int)l;
    }

    public static int lessThan(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[n2 + k] & 0xFFFFFFFFL) - ((long)nArray2[n3 + k] & 0xFFFFFFFFL) + l >> 32;
        }
        return (int)l;
    }

    public static void mul(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = n;
        nArray3[n2] = Nat.mulWord(n2, nArray[0], nArray2, nArray3);
        for (int k = 1; k < n; ++k) {
            int n3 = k;
            int n4 = n3 + n;
            nArray3[n4] = Nat.mulWordAddTo(n, nArray[n3], nArray2, 0, nArray3, k);
        }
    }

    public static void mul(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        int n5 = n4 + n;
        nArray3[n5] = Nat.mulWord(n, nArray[n2], nArray2, n3, nArray3, n4);
        for (n5 = 1; n5 < n; ++n5) {
            int n6 = n4 + n5;
            int n7 = n6 + n;
            nArray3[n7] = Nat.mulWordAddTo(n, nArray[n2 + n5], nArray2, n3, nArray3, n6);
        }
    }

    public static void mul(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int[] nArray3, int n5) {
        int n6 = n5 + n4;
        nArray3[n6] = Nat.mulWord(n4, nArray[n], nArray2, n3, nArray3, n5);
        for (n6 = 1; n6 < n2; ++n6) {
            int n7 = n5 + n6;
            int n8 = n7 + n4;
            nArray3[n8] = Nat.mulWordAddTo(n4, nArray[n + n6], nArray2, n3, nArray3, n7);
        }
    }

    public static int mulAddTo(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n2 = k + n;
            long l2 = l + ((long)Nat.mulWordAddTo(n, nArray[k], nArray2, 0, nArray3, k) & 0xFFFFFFFFL) + ((long)nArray3[n2] & 0xFFFFFFFFL);
            nArray3[n2] = (int)l2;
            l = l2 >>> 32;
        }
        return (int)l;
    }

    public static int mulAddTo(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n5 = n4 + n;
            long l2 = l + ((long)Nat.mulWordAddTo(n, nArray[n2 + k], nArray2, n3, nArray3, n4) & 0xFFFFFFFFL) + ((long)nArray3[n5] & 0xFFFFFFFFL);
            nArray3[n5] = (int)l2;
            l = l2 >>> 32;
            ++n4;
        }
        return (int)l;
    }

    public static int mul31BothAdd(int n, int n2, int[] nArray, int n3, int[] nArray2, int[] nArray3, int n4) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = (long)n3 & 0xFFFFFFFFL;
        n2 = 0;
        do {
            long l4 = l2 * ((long)nArray[n2] & 0xFFFFFFFFL);
            n3 = n4 + n2;
            l = l3 * ((long)nArray2[n2] & 0xFFFFFFFFL) + l4 + ((long)nArray3[n3] & 0xFFFFFFFFL) + l;
            nArray3[n3] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int mulWord(int n, int n2, int[] nArray, int[] nArray2) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        n2 = 0;
        do {
            l = l2 * ((long)nArray[n2] & 0xFFFFFFFFL) + l;
            nArray2[n2] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int mulWord(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        n2 = 0;
        do {
            l = l2 * ((long)nArray[n3 + n2] & 0xFFFFFFFFL) + l;
            int n5 = n4 + n2;
            nArray2[n5] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int mulWordAddTo(int n, int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        n2 = 0;
        do {
            int n5 = n4 + n2;
            l = l2 * ((long)nArray[n3 + n2] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int mulWordDwordAddAt(int n, int n2, long l, int[] nArray, int n3) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = l;
        n2 = n3 + 0;
        l = l2 * (l & 0xFFFFFFFFL) + ((long)nArray[n2] & 0xFFFFFFFFL) + 0L;
        nArray[n2] = (int)l;
        long l4 = l >>> 32;
        int n4 = n3 + 1;
        l4 = l2 * (l3 >>> 32) + ((long)nArray[n4] & 0xFFFFFFFFL) + l4;
        nArray[n4] = (int)l4;
        int n5 = n3 + 2;
        l = (l4 >>> 32) + ((long)nArray[n5] & 0xFFFFFFFFL);
        nArray[n5] = (int)l;
        return l >>> 32 == 0L ? 0 : Nat.incAt(n, nArray, n3 + 3);
    }

    public static int shiftDownBit(int n, int[] nArray, int n2) {
        while ((n += -1) >= 0) {
            int n3 = nArray[n];
            nArray[n] = n3 >>> 1 | n2 << 31;
            n2 = n3;
        }
        return n2 << 31;
    }

    public static int shiftDownBit(int n, int[] nArray, int n2, int n3) {
        while ((n += -1) >= 0) {
            int n4 = n2 + n;
            int n5 = nArray[n4];
            nArray[n4] = n5 >>> 1 | n3 << 31;
            n3 = n5;
        }
        return n3 << 31;
    }

    public static int shiftDownBit(int n, int[] nArray, int n2, int[] nArray2) {
        while ((n += -1) >= 0) {
            int n3 = nArray[n];
            nArray2[n] = n3 >>> 1 | n2 << 31;
            n2 = n3;
        }
        return n2 << 31;
    }

    public static int shiftDownBit(int n, int[] nArray, int n2, int n3, int[] nArray2, int n4) {
        while ((n += -1) >= 0) {
            int n5 = nArray[n2 + n];
            int n6 = n4 + n;
            nArray2[n6] = n5 >>> 1 | n3 << 31;
            n3 = n5;
        }
        return n3 << 31;
    }

    public static int shiftDownBits(int n, int[] nArray, int n2, int n3) {
        while ((n += -1) >= 0) {
            int n4 = nArray[n];
            nArray[n] = n4 >>> n2 | n3 << -n2;
            n3 = n4;
        }
        return n3 << -n2;
    }

    public static int shiftDownBits(int n, int[] nArray, int n2, int n3, int n4) {
        while ((n += -1) >= 0) {
            int n5 = n2 + n;
            int n6 = nArray[n5];
            nArray[n5] = n6 >>> n3 | n4 << -n3;
            n4 = n6;
        }
        return n4 << -n3;
    }

    public static int shiftDownBits(int n, int[] nArray, int n2, int n3, int[] nArray2) {
        while ((n += -1) >= 0) {
            int n4 = nArray[n];
            nArray2[n] = n4 >>> n2 | n3 << -n2;
            n3 = n4;
        }
        return n3 << -n2;
    }

    public static int shiftDownBits(int n, int[] nArray, int n2, int n3, int n4, int[] nArray2, int n5) {
        while ((n += -1) >= 0) {
            int n6 = nArray[n2 + n];
            int n7 = n5 + n;
            nArray2[n7] = n6 >>> n3 | n4 << -n3;
            n4 = n6;
        }
        return n4 << -n3;
    }

    public static int shiftDownWord(int n, int[] nArray, int n2) {
        while ((n += -1) >= 0) {
            int n3 = nArray[n];
            nArray[n] = n2;
            n2 = n3;
        }
        return n2;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2) {
        for (int k = 0; k < n; ++k) {
            int n3 = nArray[k];
            nArray[k] = n3 << 1 | n2 >>> 31;
            n2 = n3;
        }
        return n2 >>> 31;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2, int n3) {
        for (int k = 0; k < n; ++k) {
            int n4 = n2 + k;
            int n5 = nArray[n4];
            nArray[n4] = n5 << 1 | n3 >>> 31;
            n3 = n5;
        }
        return n3 >>> 31;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2, int[] nArray2) {
        for (int k = 0; k < n; ++k) {
            int n3 = nArray[k];
            nArray2[k] = n3 << 1 | n2 >>> 31;
            n2 = n3;
        }
        return n2 >>> 31;
    }

    public static int shiftUpBit(int n, int[] nArray, int n2, int n3, int[] nArray2, int n4) {
        for (int k = 0; k < n; ++k) {
            int n5 = nArray[n2 + k];
            int n6 = n4 + k;
            nArray2[n6] = n5 << 1 | n3 >>> 31;
            n3 = n5;
        }
        return n3 >>> 31;
    }

    public static long shiftUpBit64(int n, long[] lArray, int n2, long l, long[] lArray2, int n3) {
        for (int k = 0; k < n; ++k) {
            long l2 = lArray[n2 + k];
            int n4 = n3 + k;
            lArray2[n4] = l = l2 << 1 | l >>> 63;
            l = l2;
        }
        return l >>> 63;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3) {
        for (int k = 0; k < n; ++k) {
            int n4 = nArray[k];
            nArray[k] = n4 << n2 | n3 >>> -n2;
            n3 = n4;
        }
        return n3 >>> -n2;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3, int n4) {
        for (int k = 0; k < n; ++k) {
            int n5 = n2 + k;
            int n6 = nArray[n5];
            nArray[n5] = n6 << n3 | n4 >>> -n3;
            n4 = n6;
        }
        return n4 >>> -n3;
    }

    public static long shiftUpBits64(int n, long[] lArray, int n2, int n3, long l) {
        for (int k = 0; k < n; ++k) {
            int n4 = n2 + k;
            long l2 = lArray[n4];
            lArray[n4] = l2 << n3 | l >>> -n3;
            l = l2;
        }
        return l >>> -n3;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3, int[] nArray2) {
        for (int k = 0; k < n; ++k) {
            int n4 = nArray[k];
            nArray2[k] = n4 << n2 | n3 >>> -n2;
            n3 = n4;
        }
        return n3 >>> -n2;
    }

    public static int shiftUpBits(int n, int[] nArray, int n2, int n3, int n4, int[] nArray2, int n5) {
        for (int k = 0; k < n; ++k) {
            int n6 = nArray[n2 + k];
            int n7 = n5 + k;
            nArray2[n7] = n6 << n3 | n4 >>> -n3;
            n4 = n6;
        }
        return n4 >>> -n3;
    }

    public static long shiftUpBits64(int n, long[] lArray, int n2, int n3, long l, long[] lArray2, int n4) {
        for (int k = 0; k < n; ++k) {
            long l2 = lArray[n2 + k];
            int n5 = n4 + k;
            lArray2[n5] = l = l2 << n3 | l >>> -n3;
            l = l2;
        }
        return l >>> -n3;
    }

    public static void square(int n, int[] nArray, int[] nArray2) {
        int n2 = n << 1;
        int n3 = 0;
        int n4 = n2;
        int n5 = n;
        while (true) {
            long l = (long)nArray[n5 += -1] & 0xFFFFFFFFL;
            long l2 = l * l;
            int n6 = n3;
            n3 = n4 + -1;
            nArray2[n3] = n6 << 31 | (int)(l2 >>> 33);
            nArray2[--n3] = (int)(l2 >>> 1);
            n4 = (int)l2;
            if (n5 <= 0) {
                long l3 = 0L;
                n4 = 2;
                for (int k = 1; k < n; ++k) {
                    l3 = l3 + ((long)Nat.squareWordAddTo(nArray, k, nArray2) & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL);
                    int n7 = n4 + 1;
                    nArray2[n4] = (int)l3;
                    long l4 = (l3 >>> 32) + ((long)nArray2[n7] & 0xFFFFFFFFL);
                    n4 = n7 + 1;
                    nArray2[n7] = (int)l4;
                    l3 = l4 >>> 32;
                }
                Nat.shiftUpBit(n2, nArray2, nArray[0] << 31);
                return;
            }
            int n8 = n3;
            n3 = n4;
            n4 = n8;
        }
    }

    public static void square(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = n << 1;
        int n5 = 0;
        int n6 = n4;
        int n7 = n;
        while (true) {
            long l = (long)nArray[n2 + (n7 += -1)] & 0xFFFFFFFFL;
            long l2 = l * l;
            int n8 = n5;
            n5 = n6 + -1;
            n6 = n3 + n5;
            nArray2[n6] = n8 << 31 | (int)(l2 >>> 33);
            n6 = n3 + (n5 += -1);
            nArray2[n6] = (int)(l2 >>> 1);
            n6 = (int)l2;
            if (n7 <= 0) {
                long l3 = 0L;
                n6 = n3 + 2;
                for (int k = 1; k < n; ++k) {
                    l3 = l3 + ((long)Nat.squareWordAddTo(nArray, n2, k, nArray2, n3) & 0xFFFFFFFFL) + ((long)nArray2[n6] & 0xFFFFFFFFL);
                    int n9 = n6 + 1;
                    nArray2[n6] = (int)l3;
                    long l4 = (l3 >>> 32) + ((long)nArray2[n9] & 0xFFFFFFFFL);
                    n6 = n9 + 1;
                    nArray2[n9] = (int)l4;
                    l3 = l4 >>> 32;
                }
                Nat.shiftUpBit(n4, nArray2, n3, nArray[n2] << 31);
                return;
            }
            int n10 = n5;
            n5 = n6;
            n6 = n10;
        }
    }

    public static int squareWordAdd(int[] nArray, int n, int[] nArray2) {
        long l = 0L;
        long l2 = (long)nArray[n] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            int n3 = n + n2;
            l = l2 * ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
            nArray2[n3] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int squareWordAdd(int[] nArray, int n, int n2, int[] nArray2, int n3) {
        long l = 0L;
        long l2 = (long)nArray[n + n2] & 0xFFFFFFFFL;
        int n4 = 0;
        do {
            int n5 = n2 + n3;
            l = l2 * ((long)nArray[n + n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l;
            l >>>= 32;
            ++n3;
        } while (++n4 < n2);
        return (int)l;
    }

    public static int squareWordAddTo(int[] nArray, int n, int[] nArray2) {
        long l = 0L;
        long l2 = (long)nArray[n] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            int n3 = n + n2;
            l = l2 * ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n3] & 0xFFFFFFFFL) + l;
            nArray2[n3] = (int)l;
            l >>>= 32;
        } while (++n2 < n);
        return (int)l;
    }

    public static int squareWordAddTo(int[] nArray, int n, int n2, int[] nArray2, int n3) {
        long l = 0L;
        long l2 = (long)nArray[n + n2] & 0xFFFFFFFFL;
        int n4 = 0;
        do {
            int n5 = n2 + n3;
            l = l2 * ((long)nArray[n + n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l;
            l >>>= 32;
            ++n3;
        } while (++n4 < n2);
        return (int)l;
    }

    public static int sub(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[k] & 0xFFFFFFFFL) - ((long)nArray2[k] & 0xFFFFFFFFL) + l;
            nArray3[k] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int sub(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray[n2 + k] & 0xFFFFFFFFL) - ((long)nArray2[n3 + k] & 0xFFFFFFFFL) + l;
            int n5 = n4 + k;
            nArray3[n5] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int sub33At(int n, int n2, int[] nArray, int n3) {
        int n4 = n3 + 0;
        long l = ((long)nArray[n4] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        long l2 = l >> 32;
        n2 = n3 + 1;
        l2 = ((long)nArray[n2] & 0xFFFFFFFFL) - 1L + l2;
        nArray[n2] = (int)l2;
        return l2 >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n3 + 2);
    }

    public static int sub33At(int n, int n2, int[] nArray, int n3, int n4) {
        int n5;
        int n6 = n3 + n4;
        long l = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n6] = (int)l;
        n2 = n6 + 1;
        long l2 = ((long)nArray[n2] & 0xFFFFFFFFL) - 1L + (l >>= 32);
        nArray[n2] = (int)l2;
        if (l2 >> 32 == 0L) {
            n5 = 0;
        } else {
            int n7 = n;
            n = n4 + 2;
            n5 = Nat.decAt(n7, nArray, n3, n);
        }
        return n5;
    }

    public static int sub33From(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        l >>= 32;
        l = ((long)nArray[1] & 0xFFFFFFFFL) - 1L + l;
        nArray[1] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, 2);
    }

    public static int sub33From(int n, int n2, int[] nArray, int n3) {
        int n4 = n3 + 0;
        long l = ((long)nArray[n4] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        long l2 = l >> 32;
        n2 = n3 + 1;
        l2 = ((long)nArray[n2] & 0xFFFFFFFFL) - 1L + l2;
        nArray[n2] = (int)l2;
        return l2 >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n3, 2);
    }

    public static int subBothFrom(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray3[k] & 0xFFFFFFFFL) - ((long)nArray[k] & 0xFFFFFFFFL) - ((long)nArray2[k] & 0xFFFFFFFFL) + l;
            nArray3[k] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int subBothFrom(int n, int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n5 = n4 + k;
            l = ((long)nArray3[n5] & 0xFFFFFFFFL) - ((long)nArray[n2 + k] & 0xFFFFFFFFL) - ((long)nArray2[n3 + k] & 0xFFFFFFFFL) + l;
            nArray3[n5] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int subDWordAt(int n, long l, int[] nArray, int n2) {
        int n3 = n2 + 0;
        long l2 = ((long)nArray[n3] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL);
        nArray[n3] = (int)l2;
        long l3 = l2 >> 32;
        int n4 = n2 + 1;
        l = ((long)nArray[n4] & 0xFFFFFFFFL) - (l >>> 32) + l3;
        nArray[n4] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n2 + 2);
    }

    public static int subDWordAt(int n, long l, int[] nArray, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        long l2 = ((long)nArray[n5] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL);
        nArray[n5] = (int)l2;
        l = ((long)nArray[++n5] & 0xFFFFFFFFL) - (l >>> 32) + (l2 >>= 32);
        nArray[n5] = (int)l;
        if (l >> 32 == 0L) {
            n4 = 0;
        } else {
            int n6 = n;
            n = n3 + 2;
            n4 = Nat.decAt(n6, nArray, n2, n);
        }
        return n4;
    }

    public static int subDWordFrom(int n, long l, int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        l = ((long)nArray[1] & 0xFFFFFFFFL) - (l >>> 32) + (l2 >>= 32);
        nArray[1] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, 2);
    }

    public static int subDWordFrom(int n, long l, int[] nArray, int n2) {
        int n3 = n2 + 0;
        long l2 = ((long)nArray[n3] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL);
        nArray[n3] = (int)l2;
        long l3 = l2 >> 32;
        int n4 = n2 + 1;
        l = ((long)nArray[n4] & 0xFFFFFFFFL) - (l >>> 32) + l3;
        nArray[n4] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n2, 2);
    }

    public static int subFrom(int n, int[] nArray, int[] nArray2) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            l = ((long)nArray2[k] & 0xFFFFFFFFL) - ((long)nArray[k] & 0xFFFFFFFFL) + l;
            nArray2[k] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int subFrom(int n, int[] nArray, int n2, int[] nArray2, int n3) {
        long l = 0L;
        for (int k = 0; k < n; ++k) {
            int n4 = n3 + k;
            l = ((long)nArray2[n4] & 0xFFFFFFFFL) - ((long)nArray[n2 + k] & 0xFFFFFFFFL) + l;
            nArray2[n4] = (int)l;
            l >>= 32;
        }
        return (int)l;
    }

    public static int subWordAt(int n, int n2, int[] nArray, int n3) {
        long l = ((long)nArray[n3] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n3] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n3 + 1);
    }

    public static int subWordAt(int n, int n2, int[] nArray, int n3, int n4) {
        int n5;
        int n6 = n3 + n4;
        long l = ((long)nArray[n6] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n6] = (int)l;
        if (l >> 32 == 0L) {
            n5 = 0;
        } else {
            int n7 = n;
            n = n4 + 1;
            n5 = Nat.decAt(n7, nArray, n3, n);
        }
        return n5;
    }

    public static int subWordFrom(int n, int n2, int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[0] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, 1);
    }

    public static int subWordFrom(int n, int n2, int[] nArray, int n3) {
        int n4 = n3 + 0;
        long l = ((long)nArray[n4] & 0xFFFFFFFFL) - ((long)n2 & 0xFFFFFFFFL);
        nArray[n4] = (int)l;
        return l >> 32 == 0L ? 0 : Nat.decAt(n, nArray, n3, 1);
    }

    public static BigInteger toBigInteger(int n, int[] nArray) {
        byte[] byArray = new byte[n << 2];
        for (int k = 0; k < n; ++k) {
            int n2 = nArray[k];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, n - 1 - k << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int n, int[] nArray) {
        for (int k = 0; k < n; ++k) {
            nArray[k] = 0;
        }
    }

    public static void zero(int n, int[] nArray, int n2) {
        for (int k = 0; k < n; ++k) {
            nArray[n2 + k] = 0;
        }
    }

    public static void zero64(int n, long[] lArray) {
        for (int k = 0; k < n; ++k) {
            lArray[k] = 0L;
        }
    }
}

