/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class NTRUEncryptionParameters
implements Cloneable {
    public int N;
    public int q;
    public int df;
    public int df1;
    public int df2;
    public int df3;
    public int dr;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dg;
    public int llen;
    public int maxMsgLenBytes;
    public int db;
    public int bufferLenBits;
    public int bufferLenTrits;
    public int dm0;
    public int pkLen;
    public int c;
    public int minCallsR;
    public int minCallsMask;
    public boolean hashSeed;
    public byte[] oid;
    public boolean sparse;
    public boolean fastFp;
    public int polyType;
    public Digest hashAlg;

    public NTRUEncryptionParameters(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        nTRUEncryptionParameters.N = n;
        nTRUEncryptionParameters.q = n2;
        nTRUEncryptionParameters.df = n3;
        nTRUEncryptionParameters.db = n5;
        nTRUEncryptionParameters.dm0 = n4;
        nTRUEncryptionParameters.c = n6;
        nTRUEncryptionParameters.minCallsR = n7;
        nTRUEncryptionParameters.minCallsMask = n8;
        nTRUEncryptionParameters.hashSeed = bl;
        nTRUEncryptionParameters.oid = byArray;
        nTRUEncryptionParameters.sparse = bl2;
        nTRUEncryptionParameters.fastFp = bl3;
        nTRUEncryptionParameters.polyType = 0;
        nTRUEncryptionParameters.hashAlg = digest;
        nTRUEncryptionParameters.init();
    }

    public NTRUEncryptionParameters(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        nTRUEncryptionParameters.N = n;
        nTRUEncryptionParameters.q = n2;
        nTRUEncryptionParameters.df1 = n3;
        nTRUEncryptionParameters.df2 = n4;
        nTRUEncryptionParameters.df3 = n5;
        nTRUEncryptionParameters.db = n7;
        nTRUEncryptionParameters.dm0 = n6;
        nTRUEncryptionParameters.c = n8;
        nTRUEncryptionParameters.minCallsR = n9;
        nTRUEncryptionParameters.minCallsMask = n10;
        nTRUEncryptionParameters.hashSeed = bl;
        nTRUEncryptionParameters.oid = byArray;
        nTRUEncryptionParameters.sparse = bl2;
        nTRUEncryptionParameters.fastFp = bl3;
        nTRUEncryptionParameters.polyType = 1;
        nTRUEncryptionParameters.hashAlg = digest;
        nTRUEncryptionParameters.init();
    }

    private void init() {
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        nTRUEncryptionParameters.dr = nTRUEncryptionParameters.df;
        nTRUEncryptionParameters.dr1 = nTRUEncryptionParameters.df1;
        nTRUEncryptionParameters.dr2 = nTRUEncryptionParameters.df2;
        nTRUEncryptionParameters.dr3 = nTRUEncryptionParameters.df3;
        int n = nTRUEncryptionParameters.N;
        NTRUEncryptionParameters nTRUEncryptionParameters2 = this;
        nTRUEncryptionParameters2.dg = n / 3;
        nTRUEncryptionParameters2.llen = 1;
        int n2 = this.db;
        this.maxMsgLenBytes = n * 3 / 2 / 8 - 1 - n2 / 8 - 1;
        this.bufferLenBits = (n * 3 / 2 + 7) / 8 * 8 + 1;
        nTRUEncryptionParameters.bufferLenTrits = n - 1;
        nTRUEncryptionParameters.pkLen = n2;
    }

    public NTRUEncryptionParameters(InputStream object) {
        DataInputStream dataInputStream;
        DataInputStream dataInputStream2;
        DataInputStream dataInputStream3 = dataInputStream2 = dataInputStream;
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        DataInputStream dataInputStream4 = dataInputStream2;
        dataInputStream4((InputStream)object);
        this.N = dataInputStream4.readInt();
        this.q = dataInputStream2.readInt();
        this.df = dataInputStream2.readInt();
        this.df1 = dataInputStream2.readInt();
        this.df2 = dataInputStream2.readInt();
        this.df3 = dataInputStream2.readInt();
        this.db = dataInputStream2.readInt();
        this.dm0 = dataInputStream2.readInt();
        this.c = dataInputStream2.readInt();
        this.minCallsR = dataInputStream2.readInt();
        this.minCallsMask = dataInputStream2.readInt();
        nTRUEncryptionParameters.hashSeed = dataInputStream2.readBoolean();
        byte[] byArray = new byte[3];
        object = byArray;
        nTRUEncryptionParameters.oid = byArray;
        dataInputStream3.read((byte[])object);
        this.sparse = dataInputStream3.readBoolean();
        this.fastFp = dataInputStream2.readBoolean();
        this.polyType = ((InputStream)dataInputStream2).read();
        object = dataInputStream.readUTF();
        if ("SHA-512".equals(object)) {
            SHA512Digest sHA512Digest;
            object = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            this.hashAlg = object;
        } else if ("SHA-256".equals(object)) {
            SHA256Digest sHA256Digest;
            object = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            this.hashAlg = object;
        }
        this.init();
    }

    public NTRUEncryptionParameters clone() {
        if (this.polyType == 0) {
            NTRUEncryptionParameters nTRUEncryptionParameters = this;
            int n = nTRUEncryptionParameters.N;
            int n2 = nTRUEncryptionParameters.q;
            int n3 = nTRUEncryptionParameters.df;
            int n4 = nTRUEncryptionParameters.dm0;
            int n5 = nTRUEncryptionParameters.db;
            int n6 = nTRUEncryptionParameters.c;
            int n7 = nTRUEncryptionParameters.minCallsR;
            int n8 = nTRUEncryptionParameters.minCallsMask;
            boolean bl = nTRUEncryptionParameters.hashSeed;
            byte[] byArray = nTRUEncryptionParameters.oid;
            boolean bl2 = nTRUEncryptionParameters.sparse;
            boolean bl3 = nTRUEncryptionParameters.fastFp;
            Digest digest = nTRUEncryptionParameters.hashAlg;
            return new NTRUEncryptionParameters(n, n2, n3, n4, n5, n6, n7, n8, bl, byArray, bl2, bl3, digest);
        }
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        int n = nTRUEncryptionParameters.N;
        int n9 = nTRUEncryptionParameters.q;
        int n10 = nTRUEncryptionParameters.df1;
        int n11 = nTRUEncryptionParameters.df2;
        int n12 = nTRUEncryptionParameters.df3;
        int n13 = nTRUEncryptionParameters.dm0;
        int n14 = nTRUEncryptionParameters.db;
        int n15 = nTRUEncryptionParameters.c;
        int n16 = nTRUEncryptionParameters.minCallsR;
        int n17 = nTRUEncryptionParameters.minCallsMask;
        boolean bl = nTRUEncryptionParameters.hashSeed;
        byte[] byArray = nTRUEncryptionParameters.oid;
        boolean bl4 = nTRUEncryptionParameters.sparse;
        boolean bl5 = nTRUEncryptionParameters.fastFp;
        Digest digest = nTRUEncryptionParameters.hashAlg;
        return new NTRUEncryptionParameters(n, n9, n10, n11, n12, n13, n14, n15, n16, n17, bl, byArray, bl4, bl5, digest);
    }

    public int getMaxMessageLength() {
        return this.maxMsgLenBytes;
    }

    public void writeTo(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt(this.N);
        dataOutputStream2.writeInt(this.q);
        dataOutputStream2.writeInt(this.df);
        dataOutputStream2.writeInt(this.df1);
        dataOutputStream2.writeInt(this.df2);
        dataOutputStream2.writeInt(this.df3);
        dataOutputStream2.writeInt(this.db);
        dataOutputStream2.writeInt(this.dm0);
        dataOutputStream2.writeInt(this.c);
        dataOutputStream2.writeInt(this.minCallsR);
        dataOutputStream2.writeInt(this.minCallsMask);
        dataOutputStream2.writeBoolean(this.hashSeed);
        ((OutputStream)dataOutputStream2).write(this.oid);
        dataOutputStream2.writeBoolean(this.sparse);
        dataOutputStream2.writeBoolean(this.fastFp);
        dataOutputStream2.write(this.polyType);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public int hashCode() {
        NTRUEncryptionParameters nTRUEncryptionParameters = this;
        int n = (((((((((((((((31 + nTRUEncryptionParameters.N) * 31 + this.bufferLenBits) * 31 + this.bufferLenTrits) * 31 + this.c) * 31 + this.db) * 31 + this.df) * 31 + this.df1) * 31 + this.df2) * 31 + this.df3) * 31 + this.dg) * 31 + this.dm0) * 31 + this.dr) * 31 + this.dr1) * 31 + this.dr2) * 31 + this.dr3) * 31;
        int n2 = nTRUEncryptionParameters.fastFp ? 1231 : 1237;
        n = (n + n2) * 31;
        Digest digest = this.hashAlg;
        int n3 = digest == null ? 0 : digest.getAlgorithmName().hashCode();
        n = (n + n3) * 31;
        n3 = this.hashSeed ? 1231 : 1237;
        NTRUEncryptionParameters nTRUEncryptionParameters2 = this;
        n = (((((n + n3) * 31 + this.llen) * 31 + this.maxMsgLenBytes) * 31 + this.minCallsMask) * 31 + this.minCallsR) * 31;
        int n4 = ((((Arrays.hashCode(nTRUEncryptionParameters2.oid) + n) * 31 + this.pkLen) * 31 + this.polyType) * 31 + this.q) * 31;
        n = nTRUEncryptionParameters2.sparse ? 1231 : 1237;
        return n4 + n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (NTRUEncryptionParameters)object;
        if (this.N != ((NTRUEncryptionParameters)object).N) {
            return false;
        }
        if (this.bufferLenBits != ((NTRUEncryptionParameters)object).bufferLenBits) {
            return false;
        }
        if (this.bufferLenTrits != ((NTRUEncryptionParameters)object).bufferLenTrits) {
            return false;
        }
        if (this.c != ((NTRUEncryptionParameters)object).c) {
            return false;
        }
        if (this.db != ((NTRUEncryptionParameters)object).db) {
            return false;
        }
        if (this.df != ((NTRUEncryptionParameters)object).df) {
            return false;
        }
        if (this.df1 != ((NTRUEncryptionParameters)object).df1) {
            return false;
        }
        if (this.df2 != ((NTRUEncryptionParameters)object).df2) {
            return false;
        }
        if (this.df3 != ((NTRUEncryptionParameters)object).df3) {
            return false;
        }
        if (this.dg != ((NTRUEncryptionParameters)object).dg) {
            return false;
        }
        if (this.dm0 != ((NTRUEncryptionParameters)object).dm0) {
            return false;
        }
        if (this.dr != ((NTRUEncryptionParameters)object).dr) {
            return false;
        }
        if (this.dr1 != ((NTRUEncryptionParameters)object).dr1) {
            return false;
        }
        if (this.dr2 != ((NTRUEncryptionParameters)object).dr2) {
            return false;
        }
        if (this.dr3 != ((NTRUEncryptionParameters)object).dr3) {
            return false;
        }
        if (this.fastFp != ((NTRUEncryptionParameters)object).fastFp) {
            return false;
        }
        Digest digest = this.hashAlg;
        if (digest == null ? ((NTRUEncryptionParameters)object).hashAlg != null : !digest.getAlgorithmName().equals(((NTRUEncryptionParameters)object).hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.hashSeed != ((NTRUEncryptionParameters)object).hashSeed) {
            return false;
        }
        if (this.llen != ((NTRUEncryptionParameters)object).llen) {
            return false;
        }
        if (this.maxMsgLenBytes != ((NTRUEncryptionParameters)object).maxMsgLenBytes) {
            return false;
        }
        if (this.minCallsMask != ((NTRUEncryptionParameters)object).minCallsMask) {
            return false;
        }
        if (this.minCallsR != ((NTRUEncryptionParameters)object).minCallsR) {
            return false;
        }
        if (!Arrays.equals(this.oid, ((NTRUEncryptionParameters)object).oid)) {
            return false;
        }
        if (this.pkLen != ((NTRUEncryptionParameters)object).pkLen) {
            return false;
        }
        if (this.polyType != ((NTRUEncryptionParameters)object).polyType) {
            return false;
        }
        if (this.q != ((NTRUEncryptionParameters)object).q) {
            return false;
        }
        return this.sparse == ((NTRUEncryptionParameters)object).sparse;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(b.a("EncryptionParameters(N=").append(this.N).append(" q=").append(this.q).toString());
        if (this.polyType == 0) {
            stringBuilder2.append(b.a(" polyType=SIMPLE df=").append(this.df).toString());
        } else {
            stringBuilder2.append(b.a(" polyType=PRODUCT df1=").append(this.df1).append(" df2=").append(this.df2).append(" df3=").append(this.df3).toString());
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(b.a(" dm0=").append(this.dm0).append(" db=").append(this.db).append(" c=").append(this.c).append(" minCallsR=").append(this.minCallsR).append(" minCallsMask=").append(this.minCallsMask).append(" hashSeed=").append(this.hashSeed).append(" hashAlg=").append(this.hashAlg).append(" oid=").append(Arrays.toString(this.oid)).append(" sparse=").append(this.sparse).append(")").toString());
        return stringBuilder3.toString();
    }
}

