/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class BDSStateMap
implements Serializable {
    private static final long serialVersionUID = -3464451825208522308L;
    private final Map<Integer, BDS> bdsState;
    private transient long maxIndex;

    public BDSStateMap(long l) {
        TreeMap treeMap;
        Serializable serializable = treeMap;
        treeMap = new TreeMap();
        v1.bdsState = serializable;
        v1.maxIndex = l;
    }

    public BDSStateMap(BDSStateMap bDSStateMap, long l) {
        this.bdsState = new TreeMap<Integer, BDS>();
        for (Integer n : bDSStateMap.bdsState.keySet()) {
            BDS bDS;
            BDS bDS2 = bDS;
            bDS = new BDS(bDSStateMap.bdsState.get(n));
            this.bdsState.put(n, bDS2);
        }
        this.maxIndex = l;
    }

    public BDSStateMap(XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        this.bdsState = new TreeMap<Integer, BDS>();
        int n = xMSSMTParameters.getHeight();
        this.maxIndex = (1L << n) - 1L;
        for (long k = 0L; k < l; ++k) {
            this.updateState(xMSSMTParameters, k, byArray, byArray2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.maxIndex = objectInputStream2.available() != 0 ? objectInputStream.readLong() : 0L;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.maxIndex);
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    public void updateState(XMSSMTParameters xMSSMTParameters, long l, byte[] byArray, byte[] byArray2) {
        OTSHashAddress.Builder builder;
        long l2 = l;
        XMSSParameters xMSSParameters = xMSSMTParameters.getXMSSParameters();
        int n = xMSSParameters.getHeight();
        long l3 = XMSSUtil.getTreeIndex(l2, n);
        int n2 = XMSSUtil.getLeafIndex(l2, n);
        Object object = builder;
        ((OTSHashAddress.Builder)object)();
        object = (OTSHashAddress)((OTSHashAddress.Builder)builder.withTreeAddress(l3)).withOTSAddress(n2).build();
        int n3 = (1 << n) - 1;
        if (n2 < n3) {
            if (this.get(0) == null || n2 == 0) {
                BDS bDS;
                BDS bDS2 = bDS;
                bDS = new BDS(xMSSParameters, byArray, byArray2, (OTSHashAddress)object);
                this.put(0, bDS2);
            }
            this.update(0, byArray, byArray2, (OTSHashAddress)object);
        }
        for (n2 = 1; n2 < xMSSMTParameters.getLayers(); ++n2) {
            int n4 = XMSSUtil.getLeafIndex(l3, n);
            long l4 = XMSSUtil.getTreeIndex(l3, n);
            OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n2)).withTreeAddress(l4)).withOTSAddress(n4).build();
            if (this.bdsState.get(n2) == null || XMSSUtil.isNewBDSInitNeeded(l, n, n2)) {
                this.bdsState.put(n2, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            if (n4 < n3 && XMSSUtil.isNewAuthenticationPathNeeded(l, n, n2)) {
                this.update(n2, byArray, byArray2, oTSHashAddress);
            }
            l3 = l4;
        }
    }

    public boolean isEmpty() {
        return this.bdsState.isEmpty();
    }

    public BDS get(int n) {
        return this.bdsState.get(Integers.valueOf(n));
    }

    public BDS update(int n, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return this.bdsState.put(Integers.valueOf(n), this.bdsState.get(Integers.valueOf(n)).getNextState(byArray, byArray2, oTSHashAddress));
    }

    public void put(int n, BDS bDS) {
        this.bdsState.put(Integers.valueOf(n), bDS);
    }

    public BDSStateMap withWOTSDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        BDSStateMap bDSStateMap;
        BDSStateMap bDSStateMap2 = bDSStateMap;
        bDSStateMap = new BDSStateMap(this.maxIndex);
        for (Integer n : this.bdsState.keySet()) {
            bDSStateMap2.bdsState.put(n, this.bdsState.get(n).withWOTSDigest(aSN1ObjectIdentifier));
        }
        return bDSStateMap2;
    }
}

