/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int m;
    private int t;
    private int n;
    private int fieldPoly;

    public McElieceKeyGenParameterSpec() {
        this(11, 50);
    }

    public McElieceKeyGenParameterSpec(int n) {
        if (n >= 1) {
            int n2;
            McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
            mcElieceKeyGenParameterSpec.m = 0;
            mcElieceKeyGenParameterSpec.n = 1;
            while ((n2 = this.n) < n) {
                this.n = n2 << 1;
                ++this.m;
            }
            McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec2 = this;
            this.t = n = n2 >>> 1;
            int n3 = this.m;
            mcElieceKeyGenParameterSpec2.t = n / n3;
            mcElieceKeyGenParameterSpec2.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n3);
            return;
        }
        throw new IllegalArgumentException("key size must be positive");
    }

    public McElieceKeyGenParameterSpec(int n, int n2) {
        if (n >= 1) {
            if (n <= 32) {
                int n3;
                McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
                mcElieceKeyGenParameterSpec.m = n;
                mcElieceKeyGenParameterSpec.n = n3 = 1 << n;
                if (n2 >= 0) {
                    if (n2 <= n3) {
                        this.t = n2;
                        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n);
                        return;
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException("m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public McElieceKeyGenParameterSpec(int n, int n2, int n3) {
        this.m = n;
        if (n >= 1) {
            if (n <= 32) {
                int n4;
                McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = this;
                mcElieceKeyGenParameterSpec.n = n4 = 1 << n;
                mcElieceKeyGenParameterSpec.t = n2;
                if (n2 >= 0) {
                    if (n2 <= n4) {
                        if (PolynomialRingGF2.degree(n3) == n && PolynomialRingGF2.isIrreducible(n3)) {
                            this.fieldPoly = n3;
                            return;
                        }
                        throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
                    }
                    throw new IllegalArgumentException("t must be less than n = 2^m");
                }
                throw new IllegalArgumentException("t must be positive");
            }
            throw new IllegalArgumentException(" m is too large");
        }
        throw new IllegalArgumentException("m must be positive");
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }
}

