/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.ExtendedPKIXParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509CertStoreSelector;
import java.security.InvalidParameterException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExtendedPKIXBuilderParameters
extends ExtendedPKIXParameters {
    private int maxPathLength = 5;
    private Set excludedCerts = Collections.EMPTY_SET;

    public ExtendedPKIXBuilderParameters(Set set, Selector selector) {
        super(set);
        this.setTargetConstraints(selector);
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pKIXParameters) {
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters;
        try {
            extendedPKIXBuilderParameters = new ExtendedPKIXBuilderParameters(pKIXParameters.getTrustAnchors(), X509CertStoreSelector.getInstance((X509CertSelector)pKIXParameters.getTargetCertConstraints()));
            extendedPKIXBuilderParameters.setParams(pKIXParameters);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return extendedPKIXBuilderParameters;
    }

    public Set getExcludedCerts() {
        return Collections.unmodifiableSet(this.excludedCerts);
    }

    public void setExcludedCerts(Set set) {
        if (set == null) {
        } else {
            HashSet hashSet;
            ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters = cloneable;
            Cloneable cloneable = hashSet;
            hashSet = new HashSet(set);
            extendedPKIXBuilderParameters.excludedCerts = cloneable;
        }
    }

    public void setMaxPathLength(int n) {
        if (n >= -1) {
            this.maxPathLength = n;
            return;
        }
        throw new InvalidParameterException("The maximum path length parameter can not be less than -1.");
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    @Override
    public void setParams(PKIXParameters pKIXParameters) {
        super.setParams(pKIXParameters);
        if (pKIXParameters instanceof ExtendedPKIXBuilderParameters) {
            ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters = this;
            ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters2 = (ExtendedPKIXBuilderParameters)pKIXParameters;
            extendedPKIXBuilderParameters.maxPathLength = extendedPKIXBuilderParameters2.maxPathLength;
            extendedPKIXBuilderParameters.excludedCerts = new HashSet(extendedPKIXBuilderParameters2.excludedCerts);
        }
        if (pKIXParameters instanceof PKIXBuilderParameters) {
            this.maxPathLength = ((PKIXBuilderParameters)pKIXParameters).getMaxPathLength();
        }
    }

    @Override
    public Object clone() {
        Set<TrustAnchor> set;
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters;
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters2;
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters3;
        ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters4;
        try {
            ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters5;
            extendedPKIXBuilderParameters4 = extendedPKIXBuilderParameters5;
            extendedPKIXBuilderParameters3 = extendedPKIXBuilderParameters5;
            extendedPKIXBuilderParameters2 = extendedPKIXBuilderParameters5;
            ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters6 = this;
            extendedPKIXBuilderParameters = extendedPKIXBuilderParameters6;
            set = extendedPKIXBuilderParameters6.getTrustAnchors();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXBuilderParameters3(set, extendedPKIXBuilderParameters.getTargetConstraints());
        extendedPKIXBuilderParameters2.setParams(this);
        return extendedPKIXBuilderParameters4;
    }
}

