/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import b.b;
import com.fis.ekyc.nfc.build_in.cvc.AbstractDataField;
import com.fis.ekyc.nfc.build_in.cvc.AccessRightAuthTerm;
import com.fis.ekyc.nfc.build_in.cvc.AccessRightEnum;
import com.fis.ekyc.nfc.build_in.cvc.AccessRightSignTermEnum;
import com.fis.ekyc.nfc.build_in.cvc.AccessRights;
import com.fis.ekyc.nfc.build_in.cvc.AccessRightsRawValue;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRole;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleAuthTermEnum;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleEnum;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleRawValue;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleSignTermEnum;
import com.fis.ekyc.nfc.build_in.cvc.CVCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import com.fis.ekyc.nfc.build_in.cvc.OIDField;
import com.fis.ekyc.nfc.build_in.cvc.util.StringConverter;

public class AuthorizationField
extends AbstractDataField {
    private static final long serialVersionUID = -5478250843535697147L;
    private AuthorizationRole role;
    private AccessRights rights;

    public AuthorizationField() {
        super(CVCTagEnum.ROLE_AND_ACCESS_RIGHTS);
    }

    public AuthorizationField(AuthorizationRole authorizationRole, AccessRights accessRights) {
        this();
        this.role = authorizationRole;
        this.rights = accessRights;
    }

    public AuthorizationField(AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum) {
        this((AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum);
    }

    public AuthorizationField(byte[] byArray) {
        this();
        if (byArray.length >= 1) {
            AuthorizationField authorizationField = this;
            authorizationField.role = new AuthorizationRoleRawValue(byArray[0]);
            authorizationField.rights = new AccessRightsRawValue(byArray);
            return;
        }
        throw new IllegalArgumentException("byte array length must be at least 1");
    }

    private static AuthorizationRole getRoleFromByte(OIDField enumArray, byte by) {
        block6: {
            byte by2;
            block4: {
                block5: {
                    block3: {
                        by2 = (byte)(by & 0xC0);
                        if (!CVCObjectIdentifiers.id_EAC_ePassport.equals(enumArray)) break block3;
                        enumArray = AuthorizationRoleEnum.values();
                        break block4;
                    }
                    if (!CVCObjectIdentifiers.id_EAC_roles_ST.equals(enumArray)) break block5;
                    enumArray = AuthorizationRoleSignTermEnum.values();
                    break block4;
                }
                if (!CVCObjectIdentifiers.id_EAC_roles_AT.equals(enumArray)) break block6;
                enumArray = AuthorizationRoleAuthTermEnum.values();
            }
            Enum enum_ = null;
            for (Enum enum_2 : enumArray) {
                if (by2 != enum_2.getValue()) continue;
                enum_ = enum_2;
                break;
            }
            return enum_;
        }
        return new AuthorizationRoleRawValue(by);
    }

    private static AccessRights getRightsFromBytes(OIDField oIDField, byte[] object) {
        if (CVCObjectIdentifiers.id_EAC_ePassport.equals(oIDField)) {
            if (((byte[])object).length == 1) {
                byte by = (byte)(object[0] & 3);
                object = null;
                for (AccessRightEnum accessRightEnum : AccessRightEnum.values()) {
                    if (by != accessRightEnum.getValue()) continue;
                    object = accessRightEnum;
                    break;
                }
                return object;
            }
            throw new IllegalArgumentException(b.a("byte array length must be 1, was ").append(((byte[])object).length).toString());
        }
        if (CVCObjectIdentifiers.id_EAC_roles_ST.equals(oIDField)) {
            if (((byte[])object).length == 1) {
                byte by = (byte)(object[0] & 3);
                object = null;
                for (AccessRightSignTermEnum accessRightSignTermEnum : AccessRightSignTermEnum.values()) {
                    if (by != accessRightSignTermEnum.getValue()) continue;
                    object = accessRightSignTermEnum;
                    break;
                }
                return object;
            }
            throw new IllegalArgumentException(b.a("byte array length must be 1, was ").append(((byte[])object).length).toString());
        }
        if (CVCObjectIdentifiers.id_EAC_roles_AT.equals(oIDField)) {
            if (((byte[])object).length == 5) {
                return new AccessRightAuthTerm((byte[])object);
            }
            throw new IllegalArgumentException(b.a("byte array length must be 5, was ").append(((byte[])object).length).toString());
        }
        return new AccessRightsRawValue((byte[])object);
    }

    @Deprecated
    public AuthorizationRoleEnum getRole() {
        AuthorizationRole authorizationRole = ((AuthorizationField)((Object)authorizationRole)).role;
        if (authorizationRole instanceof AuthorizationRoleEnum) {
            return (AuthorizationRoleEnum)authorizationRole;
        }
        throw new UnsupportedOperationException("Attempted to use deprecated getRole method with in an AT or ST certificate chain. It handles IS only.");
    }

    public AuthorizationRole getAuthRole() {
        return this.role;
    }

    @Deprecated
    public AccessRightEnum getAccessRight() {
        AccessRights accessRights = ((AuthorizationField)((Object)accessRights)).rights;
        if (accessRights instanceof AccessRightEnum) {
            return (AccessRightEnum)accessRights;
        }
        throw new UnsupportedOperationException("Attempted to use deprecated getAccessRight method with an AT or ST certificate chain. It handles IS only.");
    }

    public AccessRights getAccessRights() {
        return this.rights;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.rights.getEncoded();
        byArray[0] = (byte)(byArray[0] | this.role.getValue());
        return byArray;
    }

    @Override
    public String valueAsText() {
        return StringConverter.byteToHex(this.getEncoded()) + ": " + this.role + "/" + this.rights;
    }

    public void fixEnumTypes(OIDField oIDField) {
        this.role = AuthorizationField.getRoleFromByte(oIDField, this.role.getValue());
        this.rights = AuthorizationField.getRightsFromBytes(oIDField, this.rights.getEncoded());
    }
}

