/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.protocol;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.AESSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.DESedeSecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CommandAPDU;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.ResponseAPDU;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class SecureMessagingWrapper
implements Serializable,
APDUWrapper {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd.protocol");
    private static final long serialVersionUID = 4709645514566992414L;
    private int maxTranceiveLength;
    private boolean shouldCheckMAC;
    private long ssc;
    private transient Cipher cipher;
    private transient Mac mac;
    private SecretKey ksEnc;
    private SecretKey ksMac;

    public SecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, String string2, String string3, int n, boolean bl, long l) {
        this.maxTranceiveLength = n;
        this.shouldCheckMAC = bl;
        this.ksEnc = secretKey;
        this.ksMac = secretKey2;
        this.ssc = l;
        this.cipher = Util.getCipher(string2);
        this.mac = Util.getMac(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SecureMessagingWrapper getInstance(SecureMessagingWrapper secureMessagingWrapper) {
        try {
            if (secureMessagingWrapper instanceof DESedeSecureMessagingWrapper) {
                DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper = (DESedeSecureMessagingWrapper)secureMessagingWrapper;
                return new DESedeSecureMessagingWrapper(dESedeSecureMessagingWrapper);
            }
            if (secureMessagingWrapper instanceof AESSecureMessagingWrapper) {
                AESSecureMessagingWrapper aESSecureMessagingWrapper = (AESSecureMessagingWrapper)secureMessagingWrapper;
                return new AESSecureMessagingWrapper(aESSecureMessagingWrapper);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "Could not copy wrapper", generalSecurityException);
        }
        LOGGER.warning("Not copying wrapper");
        return secureMessagingWrapper;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandAPDU wrapCommandAPDU(CommandAPDU var1_5) {
        block14: {
            v0 = var1_5;
            var2_8 = v0.getCLA();
            var3_11 = v0.getINS();
            var4_12 = v0.getP1();
            var5_18 = v0.getP2();
            var6_21 = v0.getNc();
            var7_24 = v0.getNe();
            var8_25 = new byte[]{(byte)(var2_8 | 12), (byte)var3_11, (byte)var4_12, (byte)var5_18};
            var2_9 = Util.pad(var8_25, this.getPadLength());
            var3_11 = (byte)v0.getINS() == -79 ? 1 : 0;
            var4_13 = new byte[]{};
            var5_19 = new byte[]{};
            var9_26 = v1;
            v1 = new ByteArrayOutputStream();
            if (var7_24 > 0) {
                try {
                    var5_19 = TLVUtil.wrapDO(151, this.encodeLe(var7_24));
                }
                catch (Throwable var0_1) {
                    break block14;
                }
            }
            if (var6_21 <= 0) ** GOTO lbl43
            v2 = this;
            var1_5 = Util.pad(var1_5.getData(), this.getPadLength());
            v3 = this;
            var4_14 = 1;
            var6_22 = v3.ksEnc;
            var10_27 = v3.getIV();
            v2.cipher.init(var4_14, (Key)var6_22, var10_27);
            var1_5 = v2.cipher.doFinal((byte[])var1_5);
            var9_26.reset();
            var4_14 = var3_11 != 0 ? -123 : -121;
            var9_26.write(var4_14);
            var4_14 = ((Object)var1_5).length;
            var6_23 = var3_11 != 0 ? 0 : 1;
            var9_26.write(TLVUtil.getLengthAsBytes(var4_14 + var6_23));
            if (var3_11 == 0) {
                var9_26.write(1);
            }
            v4 = var9_26;
            var3_11 = 0;
            {
                var4_14 = ((Object)var1_5).length;
                v4.write((byte[])var1_5, var3_11, var4_14);
                var4_13 = v4.toByteArray();
lbl43:
                // 2 sources

                v5 = this;
                v6 = var9_26;
                var9_26.reset();
                var9_26.write(this.getEncodedSendSequenceCounter());
                var9_26.write(var2_9);
                var9_26.write(var4_13);
                v6.write(var5_19);
                var1_5 = Util.pad(v6.toByteArray(), this.getPadLength());
                v5.mac.init(this.ksMac);
                v7 = v5.mac.doFinal((byte[])var1_5);
            }
            var1_5 = v7;
            {
                var2_10 = v7.length;
                if (var2_10 == 8) ** GOTO lbl-1000
                var2_10 = 8;
            }
lbl-1000:
            // 2 sources

            {
                v8 = var9_26;
                v9 = v8;
                v8.reset();
                v8.write(-114);
                v8.write(var2_10);
                v8.write((byte[])var1_5, 0, var2_10);
                var1_5 = v8.toByteArray();
                v8.reset();
                v8.write(var4_13);
                v8.write(var5_19);
                v8.write((byte[])var1_5);
            }
            try {
                v9.close();
            }
            catch (IOException var1_6) {
                SecureMessagingWrapper.LOGGER.log(Level.FINE, "Error closing stream", var1_6);
            }
            var1_5 = var9_26.toByteArray();
            if (var7_24 <= 256 && ((Object)var1_5).length <= 255) {
                var0_2 = var8_25[0];
                var2_10 = var8_25[1];
                var3_11 = var8_25[2];
                var4_15 = var8_25[3];
                return new CommandAPDU(var0_2, var2_10, var3_11, var4_15, (byte[])var1_5, 256);
            }
            if (var7_24 <= 256 && ((Object)var1_5).length <= 255) {
                var0_3 = var8_25[0];
                var2_10 = var8_25[1];
                var3_11 = var8_25[2];
                var4_16 = var8_25[3];
                var5_20 = this.getMaxTranceiveLength();
                return new CommandAPDU(var0_3, var2_10, var3_11, var4_16, (byte[])var1_5, var5_20);
            }
            var0_4 = var8_25[0];
            var2_10 = var8_25[1];
            var3_11 = var8_25[2];
            var4_17 = var8_25[3];
            return new CommandAPDU(var0_4, var2_10, var3_11, var4_17, (byte[])var1_5, 65536);
        }
        try {
            var9_26.close();
            throw var0_1;
        }
        catch (IOException var1_7) {
            SecureMessagingWrapper.LOGGER.log(Level.FINE, "Error closing stream", var1_7);
        }
        throw var0_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseAPDU unwrapResponseAPDU(ResponseAPDU object) {
        ByteArrayOutputStream byteArrayOutputStream;
        boolean bl;
        DataInputStream dataInputStream;
        short s;
        Object object2;
        Object object3;
        byte[] byArray = ((ResponseAPDU)object).getBytes();
        object = byArray;
        if (byArray != null && ((Object)object).length >= 2) {
            DataInputStream dataInputStream2;
            SecureMessagingWrapper secureMessagingWrapper = byteArrayOutputStream2;
            object3 = secureMessagingWrapper.ksEnc;
            object2 = secureMessagingWrapper.getIV();
            ((SecureMessagingWrapper)((Object)byteArrayOutputStream2)).cipher.init(2, (Key)object3, (AlgorithmParameterSpec)object2);
            object3 = new byte[0];
            object2 = null;
            s = 0;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(new ByteArrayInputStream((byte[])object));
            bl = false;
        } else {
            throw new IllegalArgumentException("Invalid response APDU");
        }
        while (!bl) {
            try {
                byte[] byArray2;
                byte by = dataInputStream.readByte();
                if (by != -123) {
                    if (by != -121) {
                        if (by != -114) {
                            if (by != -103) {
                                LOGGER.warning("Unexpected tag " + Integer.toHexString(by));
                                continue;
                            }
                            s = super.readDO99(dataInputStream);
                            continue;
                        }
                        object2 = super.readDO8E(dataInputStream);
                        bl = true;
                        continue;
                    }
                    byArray2 = super.readDO87(dataInputStream, false);
                } else {
                    byArray2 = ((SecureMessagingWrapper)((Object)byteArrayOutputStream2)).readDO87(dataInputStream, true);
                }
                object3 = byArray2;
            }
            catch (Throwable throwable) {
                ((InputStream)dataInputStream).close();
                throw throwable;
            }
        }
        ((InputStream)dataInputStream).close();
        if (((SecureMessagingWrapper)((Object)byteArrayOutputStream2)).shouldCheckMAC() && !((SecureMessagingWrapper)((Object)byteArrayOutputStream2)).checkMac((byte[])object, (byte[])object2)) {
            throw new IllegalStateException("Invalid MAC");
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        Object object4 = object3;
        byteArrayOutputStream2();
        byteArrayOutputStream2.write((byte[])object4, 0, ((Object)object4).length);
        byteArrayOutputStream2.write((s & 0xFF00) >> 8);
        byteArrayOutputStream.write(s & 0xFF);
        return new ResponseAPDU(byteArrayOutputStream2.toByteArray());
    }

    private byte[] encodeLe(int n) {
        if (n >= 0 && n <= 256) {
            return new byte[]{(byte)n};
        }
        return new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
    }

    private byte[] readDO87(DataInputStream dataInputStream, boolean bl) {
        Object object;
        int n = 0;
        int n2 = dataInputStream.readUnsignedByte();
        if ((n2 & 0x80) != 128) {
            if (!bl && (n = dataInputStream.readUnsignedByte()) != 1) {
                object = b.a("DO'87 expected 0x01 marker, found ");
                throw new IllegalStateException(h.a(n & 0xFF, (StringBuilder)object));
            }
        } else {
            n2 &= 0x7F;
            for (int k = 0; k < n2; ++k) {
                n = n << 8 | dataInputStream.readUnsignedByte();
            }
            if (!bl && dataInputStream.readUnsignedByte() != 1) {
                throw new IllegalStateException("DO'87 expected 0x01 marker");
            }
            n2 = n;
        }
        if (!bl) {
            --n2;
        }
        SecureMessagingWrapper secureMessagingWrapper = object;
        byte[] byArray = new byte[n2];
        object = byArray;
        dataInputStream.readFully(byArray);
        return Util.unpad(secureMessagingWrapper.cipher.doFinal((byte[])object));
    }

    private short readDO99(DataInputStream dataInputStream) {
        if (dataInputStream.readUnsignedByte() == 2) {
            byte by = dataInputStream.readByte();
            return (short)((dataInputStream.readByte() & 0xFF) << 8 | by & 0xFF);
        }
        throw new IllegalStateException("DO'99 wrong length");
    }

    private byte[] readDO8E(DataInputStream dataInputStream) {
        int n = dataInputStream.readUnsignedByte();
        if (n != 8 && n != 16) {
            throw new IllegalStateException(a.a("DO'8E wrong length for MAC: ", n));
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public long getSendSequenceCounter() {
        return this.ssc;
    }

    public SecretKey getEncryptionKey() {
        return this.ksEnc;
    }

    public SecretKey getMACKey() {
        return this.ksMac;
    }

    public boolean shouldCheckMAC() {
        return this.shouldCheckMAC;
    }

    public int getMaxTranceiveLength() {
        return this.maxTranceiveLength;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU commandAPDU) {
        ++this.ssc;
        try {
            return this.wrapCommandAPDU(commandAPDU);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception", generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseAPDU unwrap(ResponseAPDU responseAPDU) {
        ++this.ssc;
        try {
            byte[] byArray = responseAPDU.getData();
            if (byArray != null && byArray.length > 0) {
                return this.unwrapResponseAPDU(responseAPDU);
            }
            throw new IllegalStateException("Card indicates SM error, SW = " + Integer.toHexString(responseAPDU.getSW() & 0xFFFF));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception", generalSecurityException);
        }
    }

    public boolean checkMac(byte[] byArray, byte[] byArray2) {
        block13: {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            SecureMessagingWrapper secureMessagingWrapper;
            SecureMessagingWrapper secureMessagingWrapper2;
            try {
                SecureMessagingWrapper secureMessagingWrapper3 = object;
                secureMessagingWrapper2 = secureMessagingWrapper3;
                secureMessagingWrapper = secureMessagingWrapper3;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception checking MAC", iOException);
                return false;
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = dataOutputStream;
            byte[] byArray3 = byArray;
            SecureMessagingWrapper secureMessagingWrapper4 = object;
            byte[] byArray4 = byArray;
            dataOutputStream2(byteArrayOutputStream2);
            ((OutputStream)dataOutputStream2).write(((SecureMessagingWrapper)object).getEncodedSendSequenceCounter());
            int n = 0;
            int n2 = byArray4.length - 2 - 8 - 2;
            int n3 = secureMessagingWrapper4.getPadLength();
            byte[] byArray5 = Util.pad(byArray3, n, n2, n3);
            n = 0;
            dataOutputStream.write(byArray5, n, byArray5.length);
            dataOutputStream.flush();
            ((OutputStream)dataOutputStream).close();
            secureMessagingWrapper2.mac.init(((SecureMessagingWrapper)object).ksMac);
            byte[] byArray6 = secureMessagingWrapper.mac.doFinal(byteArrayOutputStream2.toByteArray());
            Object object = byArray6;
            if (byArray6.length <= 8) break block13;
            if (byArray2.length != 8) break block13;
            int n4 = 8;
            byte[] byArray7 = new byte[8];
            int n5 = 0;
            n2 = 0;
            System.arraycopy(object, n5, byArray7, n2, n4);
            object = byArray7;
        }
        return Arrays.equals(byArray2, (byte[])object);
    }

    public abstract int getPadLength();

    public abstract IvParameterSpec getIV();

    public abstract byte[] getEncodedSendSequenceCounter();

    public String toString() {
        return b.a("SecureMessagingWrapper [ssc: ").append(this.ssc).append(", ksEnc: ").append(this.ksEnc).append(", ksMac: ").append(this.ksMac).append(", maxTranceiveLength: ").append(this.maxTranceiveLength).append(", shouldCheckMAC: ").append(this.shouldCheckMAC).append("]").toString();
    }

    public int hashCode() {
        int n = 31;
        SecretKey secretKey = this.ksEnc;
        int n2 = secretKey == null ? 0 : secretKey.hashCode();
        n = (n + n2) * 31;
        SecretKey secretKey2 = this.ksMac;
        int n3 = secretKey2 == null ? 0 : secretKey2.hashCode();
        n = ((n + n3) * 31 + this.maxTranceiveLength) * 31;
        n3 = this.shouldCheckMAC ? 1231 : 1237;
        long l = this.ssc;
        return (n + n3) * 31 + (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SecureMessagingWrapper)object;
        SecretKey secretKey = this.ksEnc;
        if (secretKey == null ? ((SecureMessagingWrapper)object).ksEnc != null : !secretKey.equals(((SecureMessagingWrapper)object).ksEnc)) {
            return false;
        }
        secretKey = this.ksMac;
        if (secretKey == null ? ((SecureMessagingWrapper)object).ksMac != null : !secretKey.equals(((SecureMessagingWrapper)object).ksMac)) {
            return false;
        }
        if (this.maxTranceiveLength != ((SecureMessagingWrapper)object).maxTranceiveLength) {
            return false;
        }
        if (this.shouldCheckMAC != ((SecureMessagingWrapper)object).shouldCheckMAC) {
            return false;
        }
        return this.ssc == ((SecureMessagingWrapper)object).ssc;
    }
}

