/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.managers;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.R;
import vn.kalapa.ekyc.KalapaSDKConfig;
import vn.kalapa.ekyc.handlers.GetDynamicLanguageHandler;
import vn.kalapa.ekyc.managers.KLPCDNManager;
import vn.kalapa.ekyc.models.KalapaAllLanguageModel;
import vn.kalapa.ekyc.models.KalapaCDNObj;
import vn.kalapa.ekyc.models.KalapaLanguageModel;
import vn.kalapa.ekyc.models.LanguageModelContent;
import vn.kalapa.ekyc.models.LanguageModelData;
import vn.kalapa.ekyc.models.MyError;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.utils.Helpers;

@SourceDebugExtension(value={"SMAP\nKLPLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,143:1\n8676#2,2:144\n9358#2,4:146\n13579#2,2:152\n13579#2,2:154\n215#3,2:150\n*S KotlinDebug\n*F\n+ 1 KLPLanguageManager.kt\nvn/kalapa/ekyc/managers/KLPLanguageManager\n*L\n33#1:144,2\n33#1:146,4\n61#1:152,2\n98#1:154,2\n38#1:150,2\n*E\n"})
public final class KLPLanguageManager {
    @NotNull
    public static final KLPLanguageManager INSTANCE = new KLPLanguageManager();
    @NotNull
    private static final HashMap<String, HashMap<String, String>> languageMap = new HashMap();
    private static KLPLanguage language;

    private KLPLanguageManager() {
    }

    private final void loadResourcesMap(Context object) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Resources resources = object.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        String string2 = object.getPackageName();
        resources.getIdentifier("string", "values", string2);
        Field[] fieldArray = R.string.class.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields");
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)fieldArray.length), (int)16);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, Object>(n);
        for (Field field : fieldArray) {
            int n2 = field.getInt(null);
            Pair pair = TuplesKt.to((Object)field.getName(), (Object)resources.getString(n2));
            Object object2 = pair.getFirst();
            linkedHashMap2.put(object2, pair.getSecond());
        }
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            Helpers.Companion.printLog("Resources: " + string3 + ": " + string4);
        }
    }

    private final void setDictionary(KLPLanguage kLPLanguage, Map<String, String> ... mapArray) {
        HashMap<String, String> hashMap = languageMap.get(kLPLanguage.name());
        if (hashMap == null) {
            HashMap hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap();
        }
        for (Map<String, String> map : mapArray) {
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (string3 == null) {
                    string3 = string2;
                }
                hashMap.put(string2, string3);
            }
        }
        languageMap.put(kLPLanguage.name(), hashMap);
    }

    @NotNull
    public final String get(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"key");
        Object object2 = language;
        if (object2 != null) {
            HashMap<String, HashMap<String, String>> hashMap = languageMap;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
            if ((object2 = hashMap.get(((Enum)object2).name())) != null && (object2 = (String)((HashMap)object2).get(object)) != null) {
                object = object2;
            }
        }
        return object;
    }

    @Nullable
    public final KalapaCDNObj pullVersion(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
        return null;
    }

    @Nullable
    public final KalapaSDKConfig.KLPLanguageConfig pullOrGetLanguage(@NotNull Activity activity, @NotNull String object, @NotNull String string2, @Nullable String object22, @Nullable String object3) {
        Map<String, String> map;
        LanguageModelContent languageModelContent;
        Integer n;
        MyError myError;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)object, (String)"baseURL");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        LanguageModelData[] languageModelDataArray = KLPCDNManager.INSTANCE;
        KalapaAllLanguageModel kalapaAllLanguageModel = languageModelDataArray.loadLanguageFromCache((Context)activity, (String)object22);
        if (kalapaAllLanguageModel != null) {
            Object object4 = null;
            Integer n2 = null;
            Object object5 = kalapaAllLanguageModel.getError();
            if (object5 != null && (object5 = ((MyError)object5).getCode()) != null && (Integer)object5 == 0 && kalapaAllLanguageModel.getData() != null) {
                for (LanguageModelData languageModelData : kalapaAllLanguageModel.getData()) {
                    Integer n3;
                    object2 = languageModelData.getData();
                    if (object2 != null && (object2 = ((LanguageModelContent)object2).getSDK()) != null && object2.isEmpty() ^ true) {
                        INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(string2), languageModelData.getData().getSDK(), languageModelData.getData().getAPP_DEMO());
                    }
                    if (object4 == null || !((Boolean)object4).booleanValue()) {
                        object4 = object2 = Boolean.valueOf(languageModelData.getM77232917());
                    }
                    if (n2 != null && Common.Companion.isP(n2)) continue;
                    n2 = n3 = Integer.valueOf(languageModelData.getP93337());
                }
                Helpers.Companion.printLog("Loaded language from cache successfully");
                return new KalapaSDKConfig.KLPLanguageConfig((Boolean)object4, n2);
            }
        }
        if ((object = (KalapaLanguageModel)new GetDynamicLanguageHandler(new WeakReference<Activity>(activity)).execute(new String[]{object, string2, object2}).get()) != null && (myError = ((KalapaLanguageModel)object).getError()) != null && (n = myError.getCode()) != null && n == 0 && ((KalapaLanguageModel)object).getData() != null && (languageModelContent = ((KalapaLanguageModel)object).getData().getData()) != null && (map = languageModelContent.getSDK()) != null && map.isEmpty() ^ true && ((KalapaLanguageModel)object).getData().getData().getAPP_DEMO().isEmpty() ^ true) {
            INSTANCE.setDictionary(KLPLanguage.Companion.fromCountryCode(string2), ((KalapaLanguageModel)object).getData().getData().getSDK(), ((KalapaLanguageModel)object).getData().getData().getAPP_DEMO());
            languageModelDataArray.saveJsonStringIntoFile((Context)activity, (KalapaLanguageModel)object);
            return new KalapaSDKConfig.KLPLanguageConfig(((KalapaLanguageModel)object).getData().getM77232917(), ((KalapaLanguageModel)object).getData().getP93337());
        }
        return null;
    }

    public final void pullModel(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"baseURL");
    }

    public final void setLocale(@NotNull Context context, @NotNull String string2) {
        Locale locale;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"languageCode");
        Locale locale2 = locale;
        Locale.setDefault(new Locale(string2));
        context = context2.getResources().getConfiguration();
        context.setLocale(locale2);
        context2.getApplicationContext().createConfigurationContext((Configuration)context);
    }

    @NotNull
    public final KLPLanguageManager setLanguage(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"language");
        Helpers.Companion companion = Helpers.Companion;
        Object object = new Object[1];
        int n = 0;
        Object object2 = language;
        if (object2 != null) {
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"language");
                object2 = null;
            }
        } else {
            object2 = "null";
        }
        KLPLanguage.Companion companion2 = KLPLanguage.Companion;
        object[n] = "setLanguage from " + (Object)object2 + " to " + companion2.fromCountryCode(string2);
        companion.printLog(object);
        language = companion2.fromCountryCode(string2);
        companion.printLog("setLocale from " + Locale.getDefault() + " - " + string2);
        object = Intrinsics.areEqual((Object)string2, (Object)"vi") ? "vi" : (Intrinsics.areEqual((Object)string2, (Object)"ko") ? "ko" : "en");
        this.setLocale(context, (String)object);
        companion.printLog("setLocale to " + Locale.getDefault() + " - " + string2);
        return this;
    }

    public static enum KLPLanguage {
        ENGLISH,
        VIETNAMESE,
        KOREAN;

        @NotNull
        public static final Companion Companion = new Companion(null);

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @NotNull
            public final KLPLanguage fromCountryCode(@NotNull String string2) {
                KLPLanguage kLPLanguage;
                block3: {
                    block2: {
                        block0: {
                            block1: {
                                String string3 = string2;
                                Intrinsics.checkNotNullParameter((Object)string3, (String)"code");
                                int n = string3.hashCode();
                                if (n == 3241) break block0;
                                if (n == 3428) break block1;
                                if (n != 3763 || !string2.equals("vi")) break block2;
                                kLPLanguage = VIETNAMESE;
                                break block3;
                            }
                            if (!string2.equals("ko")) break block2;
                            kLPLanguage = KOREAN;
                            break block3;
                        }
                        string2.equals("en");
                    }
                    kLPLanguage = ENGLISH;
                }
                return kLPLanguage;
            }
        }
    }
}

