package vn.kalapa.ekyc.extension

import android.app.Activity
import android.content.Context
import android.widget.Toast
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.GoogleApiAvailability

internal object ContextUtil {

    fun toaster(context: Context, message: String) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show()
    }

    fun isGooglePlayServicesAvailable(context: Context): Boolean {
        val googleApiAvailability = GoogleApiAvailability.getInstance()
        val resultCode = googleApiAvailability.isGooglePlayServicesAvailable(context)
        return resultCode == ConnectionResult.SUCCESS
    }

    fun promptEnableGooglePlayServices(
        activity: Activity,
        onGooglePlayEnabled: () -> Unit,
        onGooglePlayNotSupported: () -> Unit = {},
    ) {
        val googleApiAvailability = GoogleApiAvailability.getInstance()
        val resultCode = googleApiAvailability.isGooglePlayServicesAvailable(activity)
        if (resultCode != ConnectionResult.SUCCESS) {
            if (googleApiAvailability.isUserResolvableError(resultCode)) {
                googleApiAvailability.getErrorDialog(activity, resultCode, 2404)?.apply {
                    setOnDismissListener {
                        if (isGooglePlayServicesAvailable(activity)) {
                            onGooglePlayEnabled()
                        }
                    }
                    show()
                }
            } else {
                onGooglePlayNotSupported()
            }
        } else {
            onGooglePlayEnabled()
        }
    }
}

