package vn.kalapa.ekyc.managers

import android.app.Activity
import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import android.os.Build
import android.widget.Toast
import androidx.appcompat.app.AppCompatDelegate
import androidx.camera.core.impl.utils.ContextUtil.getBaseContext
import androidx.core.os.LocaleListCompat
import vn.kalapa.R
import vn.kalapa.ekyc.handlers.GetDynamicLanguageHandler
import vn.kalapa.ekyc.models.KalapaCDNObj
import vn.kalapa.ekyc.utils.Helpers
import java.util.Locale


// Singleton way
object KLPLanguageManager {
    private val languageMap = HashMap<String, HashMap<String, String>>()
    private lateinit var language: KLPLanguage
    fun get(key: String): String {
        return if (this::language.isInitialized) {
            //            Helpers.printLog("get $language $key ${(languageMap[language.name])?.get(key) ?: key}")
            (languageMap[language.name])?.get(key) ?: key
        } else key
    }

    private fun loadResourcesMap(context: Context) {
        val resources: Resources = context.resources
        val packageName = context.packageName
        val stringResIds = resources.getIdentifier("string", "values", packageName)
        val fields = R.string::class.java.fields

        val allStrings = fields.associate { field ->
            val id = field.getInt(null)
            field.name to resources.getString(id)
        }

        allStrings.forEach { (name, value) ->
            Helpers.printLog("Resources: $name: $value")
        }
    }

    fun pullVersion(baseURL: String): KalapaCDNObj? {
        return null
    }

    fun pullOrGetLanguage(activity: Activity, baseURL: String, version: String?) {
        // Check if there are saved version. If version params is not equal to current version, pull no matter what
        // Check if there are cached file, if not, pull no matter what
        KLPCDNManager.loadLanguageFromCache(activity, version)?.let {
            if ((it.error != null) && (it.error.code == 200) && it.data != null) {
                it.data.forEach { it1 ->
                    if (it1.content?.SDK?.isNotEmpty() == true) {
                        setDictionary(KLPLanguage.fromCountryCode(it1.code), it1.content.SDK, it1.content.APP_DEMO)
                    }
                }
            }
            Helpers.printLog("Loaded language from cached successfully")
            return
        }
        // After pull new language. Save it to cached
        GetDynamicLanguageHandler().execute(baseURL).get()?.let {
            if ((it.error != null) && (it.error.code == 200) && it.data != null) {
                it.data.forEach { it1 ->
                    if (it1.content?.SDK?.isNotEmpty() == true) {
                        setDictionary(KLPLanguage.fromCountryCode(it1.code), it1.content.SDK, it1.content.APP_DEMO)
                    }
                    KLPCDNManager.saveJsonStringIntoFile(activity, it)
                }
            }
        }
    }

    fun pullModel(baseURL: String) {

    }

    private fun setDictionary(language: KLPLanguage, vararg dictionaries: Map<String, String>) {
        var keyMap = languageMap[language.name] ?: HashMap()
        dictionaries.forEach {
            for (key in it.keys) {
//                Helpers.printLog("$key ${it[key]}")
                keyMap[key] = it[key] ?: key
            }
        }
        languageMap[language.name] = keyMap
//        Helpers.printLog(languageMap)
    }


    fun setLocale(context: Context, languageCode: String) {
        val locale = Locale(languageCode)
        Locale.setDefault(locale)
        val config = context.resources.configuration
        config.setLocale(locale)
        context.applicationContext.createConfigurationContext(config)
    }

    fun setLanguage(context: Context, language: String): KLPLanguageManager {
        Helpers.printLog("setLanguage from ${if (this::language.isInitialized) this.language else "null"} to ${KLPLanguage.fromCountryCode(language)}")
//        Toast.makeText(activity,activity.getString(R.string.TEST_LANGUAGE),Toast.LENGTH_LONG).show()
        this.language = KLPLanguage.fromCountryCode(language)
        Helpers.printLog("setLocale from ${Locale.getDefault()} - $language")
        setLocale(context, if (language == "vi") "vi" else if (language == "ko") "ko" else "en")
        Helpers.printLog("setLocale to ${Locale.getDefault()} - $language")
        return this
    }

    enum class KLPLanguage {
        ENGLISH, VIETNAMESE, KOREAN;

        companion object {
            fun fromCountryCode(code: String): KLPLanguage {

                return when (code) {
                    "en" -> ENGLISH
                    "vi" -> VIETNAMESE
                    "ko" -> KOREAN
                    else -> ENGLISH
                }
            }
        }
    }

}