/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.MessageImprint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;

public class TimeStampReq
extends ASN1Object {
    public ASN1Integer version;
    public MessageImprint messageImprint;
    public ASN1ObjectIdentifier tsaPolicy;
    public ASN1Integer nonce;
    public ASN1Boolean certReq;
    public Extensions extensions;

    public static TimeStampReq getInstance(Object object) {
        if (object instanceof TimeStampReq) {
            return (TimeStampReq)object;
        }
        if (object != null) {
            return new TimeStampReq(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TimeStampReq(ASN1Sequence aSN1Sequence) {
        ASN1Sequence aSN1Sequence2 = aSN1Sequence;
        int n = aSN1Sequence2.size();
        this.version = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(0));
        this.messageImprint = MessageImprint.getInstance(aSN1Sequence.getObjectAt(1));
        for (int k = 2; k < n; ++k) {
            ASN1TaggedObject aSN1TaggedObject;
            if (aSN1Sequence.getObjectAt(k) instanceof ASN1ObjectIdentifier) {
                this.tsaPolicy = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(k));
                continue;
            }
            if (aSN1Sequence.getObjectAt(k) instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(k));
                continue;
            }
            if (aSN1Sequence.getObjectAt(k) instanceof ASN1Boolean) {
                this.certReq = ASN1Boolean.getInstance(aSN1Sequence.getObjectAt(k));
                continue;
            }
            if (!(aSN1Sequence.getObjectAt(k) instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(k)).getTagNo() != 0) continue;
            this.extensions = Extensions.getInstance(aSN1TaggedObject, false);
        }
    }

    public TimeStampReq(MessageImprint messageImprint, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Integer aSN1Integer, ASN1Boolean aSN1Boolean, Extensions extensions) {
        ASN1Integer aSN1Integer2;
        ASN1Object aSN1Object = aSN1Integer2;
        aSN1Integer2 = new ASN1Integer(1L);
        v1.version = aSN1Object;
        v1.messageImprint = messageImprint;
        v1.tsaPolicy = aSN1ObjectIdentifier;
        v1.nonce = aSN1Integer;
        v1.certReq = aSN1Boolean;
        v1.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.tsaPolicy;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public ASN1Boolean getCertReq() {
        return this.certReq;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(6);
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector.add(this.messageImprint);
        ASN1Primitive aSN1Primitive = this.tsaPolicy;
        if (aSN1Primitive != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((aSN1Primitive = this.nonce) != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((aSN1Primitive = this.certReq) != null && ((ASN1Boolean)aSN1Primitive).isTrue()) {
            aSN1EncodableVector2.add(this.certReq);
        }
        if ((extensions = this.extensions) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 0, extensions);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

