/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.SecureRandom;

public class JPAKEUtil {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);

    public static BigInteger generateX1(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomInRange(ZERO, bigInteger.subtract(ONE), secureRandom);
    }

    public static BigInteger generateX2(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = ONE;
        return BigIntegers.createRandomInRange(bigInteger2, bigInteger.subtract(bigInteger2), secureRandom);
    }

    public static BigInteger calculateS(char[] cArray) {
        return new BigInteger(Strings.toUTF8ByteArray(cArray));
    }

    public static BigInteger calculateGx(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }

    public static BigInteger calculateGA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger2.multiply(bigInteger3).multiply(bigInteger4).mod(bigInteger);
    }

    public static BigInteger calculateX2s(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.multiply(bigInteger3).mod(bigInteger);
    }

    public static BigInteger calculateA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger3.modPow(bigInteger4, bigInteger);
    }

    public static BigInteger[] calculateZeroKnowledgeProof(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, String string, Digest digest, SecureRandom serializable) {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        serializable = BigIntegers.createRandomInRange(ZERO, bigInteger2.subtract(ONE), serializable);
        BigInteger bigInteger6 = bigInteger3;
        bigInteger = bigInteger6.modPow((BigInteger)serializable, bigInteger);
        bigInteger3 = JPAKEUtil.calculateHashForZeroKnowledgeProof(bigInteger6, bigInteger, bigInteger4, string, digest);
        bigIntegerArray2[0] = bigInteger;
        bigIntegerArray[1] = ((BigInteger)serializable).subtract(bigInteger5.multiply(bigInteger3)).mod(bigInteger2);
        return bigIntegerArray;
    }

    private static BigInteger calculateHashForZeroKnowledgeProof(BigInteger object, BigInteger bigInteger, BigInteger bigInteger2, String string, Digest digest) {
        Digest digest2 = digest;
        digest.reset();
        JPAKEUtil.updateDigestIncludingSize(digest, (BigInteger)object);
        JPAKEUtil.updateDigestIncludingSize(digest, bigInteger);
        JPAKEUtil.updateDigestIncludingSize(digest, bigInteger2);
        JPAKEUtil.updateDigestIncludingSize(digest2, string);
        byte[] byArray = new byte[digest2.getDigestSize()];
        object = byArray;
        digest2.doFinal(byArray, 0);
        return new BigInteger((byte[])object);
    }

    public static void validateGx4(BigInteger bigInteger) {
        if (!bigInteger.equals(ONE)) {
            return;
        }
        throw new CryptoException("g^x validation failed.  g^x should not be 1.");
    }

    public static void validateGa(BigInteger bigInteger) {
        if (!bigInteger.equals(ONE)) {
            return;
        }
        throw new CryptoException("ga is equal to 1.  It should not be.  The chances of this happening are on the order of 2^160 for a 160-bit q.  Try again.");
    }

    public static void validateZeroKnowledgeProof(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger[] object, String object2, Digest digest) {
        object = object[0];
        BigInteger bigInteger5 = object[1];
        object2 = JPAKEUtil.calculateHashForZeroKnowledgeProof(bigInteger3, (BigInteger)object, bigInteger4, (String)object2, digest);
        if (bigInteger4.compareTo(ZERO) == 1 && bigInteger4.compareTo(bigInteger) == -1 && bigInteger4.modPow(bigInteger2, bigInteger).compareTo(ONE) == 0 && bigInteger3.modPow(bigInteger5, bigInteger).multiply(bigInteger4.modPow((BigInteger)object2, bigInteger)).mod(bigInteger).compareTo((BigInteger)object) == 0) {
            return;
        }
        throw new CryptoException("Zero-knowledge proof validation failed");
    }

    public static BigInteger calculateKeyingMaterial(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        return bigInteger3.modPow(bigInteger4.multiply(bigInteger5).negate().mod(bigInteger2), bigInteger).multiply(bigInteger6).modPow(bigInteger4, bigInteger);
    }

    public static void validateParticipantIdsDiffer(String string, String string2) {
        if (!string.equals(string2)) {
            return;
        }
        throw new CryptoException(g.a("Both participants are using the same participantId (", string, "). This is not allowed. Each participant must use a unique participantId."));
    }

    public static void validateParticipantIdsEqual(String string, String string2) {
        if (string.equals(string2)) {
            return;
        }
        throw new CryptoException("Received payload from incorrect partner (" + string2 + "). Expected to receive payload from " + string + ".");
    }

    public static void validateNotNull(Object object, String string) {
        if (object != null) {
            return;
        }
        throw new NullPointerException(i.a(string, " must not be null"));
    }

    public static BigInteger calculateMacTag(String object, String string, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger object2, Digest digest) {
        HMac hMac;
        byte[] byArray = JPAKEUtil.calculateMacKey((BigInteger)object2, digest);
        object2 = byArray;
        HMac hMac2 = hMac;
        String string2 = object;
        HMac hMac3 = hMac2;
        hMac3(digest);
        object = new byte[hMac3.getMacSize()];
        hMac3.init(new KeyParameter((byte[])object2));
        JPAKEUtil.updateMac((Mac)hMac3, "KC_1_U");
        JPAKEUtil.updateMac((Mac)hMac2, string2);
        JPAKEUtil.updateMac((Mac)hMac2, string);
        JPAKEUtil.updateMac((Mac)hMac2, bigInteger);
        JPAKEUtil.updateMac((Mac)hMac2, bigInteger2);
        JPAKEUtil.updateMac((Mac)hMac2, bigInteger3);
        JPAKEUtil.updateMac((Mac)hMac, bigInteger4);
        hMac.doFinal((byte[])object, 0);
        Arrays.fill(byArray, (byte)0);
        return new BigInteger((byte[])object);
    }

    private static byte[] calculateMacKey(BigInteger bigInteger, Digest digest) {
        Digest digest2 = digest;
        digest.reset();
        JPAKEUtil.updateDigest(digest2, bigInteger);
        JPAKEUtil.updateDigest(digest2, "JPAKE_KC");
        byte[] byArray = new byte[digest2.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public static void validateMacTag(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, Digest digest, BigInteger bigInteger6) {
        if (JPAKEUtil.calculateMacTag(string2, string, bigInteger3, bigInteger4, bigInteger, bigInteger2, bigInteger5, digest).equals(bigInteger6)) {
            return;
        }
        throw new CryptoException("Partner MacTag validation failed. Therefore, the password, MAC, or digest algorithm of each participant does not match.");
    }

    private static void updateDigest(Digest digest, BigInteger object) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)object);
        object = byArray;
        int n = ((Object)object).length;
        digest.update((byte[])object, 0, n);
        Arrays.fill(byArray, (byte)0);
    }

    private static void updateDigestIncludingSize(Digest digest, BigInteger object) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)object);
        Object object2 = object = (Object)byArray;
        digest.update(JPAKEUtil.intToByteArray(((Object)object).length), 0, 4);
        digest.update((byte[])object2, 0, ((Object)object2).length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void updateDigest(Digest digest, String object) {
        byte[] byArray = Strings.toUTF8ByteArray((String)object);
        object = byArray;
        int n = ((Object)object).length;
        digest.update((byte[])object, 0, n);
        Arrays.fill(byArray, (byte)0);
    }

    private static void updateDigestIncludingSize(Digest digest, String object) {
        byte[] byArray = Strings.toUTF8ByteArray((String)object);
        Object object2 = object = (Object)byArray;
        digest.update(JPAKEUtil.intToByteArray(((Object)object).length), 0, 4);
        digest.update((byte[])object2, 0, ((Object)object2).length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void updateMac(Mac mac, BigInteger object) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)object);
        object = byArray;
        int n = ((Object)object).length;
        mac.update((byte[])object, 0, n);
        Arrays.fill(byArray, (byte)0);
    }

    private static void updateMac(Mac mac, String object) {
        byte[] byArray = Strings.toUTF8ByteArray((String)object);
        object = byArray;
        int n = ((Object)object).length;
        mac.update((byte[])object, 0, n);
        Arrays.fill(byArray, (byte)0);
    }

    private static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16);
        byArray2[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
        return byArray;
    }
}

