/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.Blake2sDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Blake2xsDigest
implements Xof {
    public static final int UNKNOWN_DIGEST_LENGTH = 65535;
    private static final int DIGEST_LENGTH = 32;
    private static final long MAX_NUMBER_BLOCKS = 0x100000000L;
    private int digestLength;
    private Blake2sDigest hash;
    private byte[] h0;
    private byte[] buf;
    private int bufPos;
    private int digestPos;
    private long blockPos;
    private long nodeOffset;

    public Blake2xsDigest() {
        this(65535);
    }

    public Blake2xsDigest(int n) {
        this(n, null, null, null);
    }

    public Blake2xsDigest(int n, byte[] byArray) {
        this(n, byArray, null, null);
    }

    public Blake2xsDigest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.h0 = null;
        this.buf = new byte[32];
        this.bufPos = 32;
        this.digestPos = 0;
        this.blockPos = 0L;
        if (n >= 1 && n <= 65535) {
            Blake2sDigest blake2sDigest;
            long l;
            this.digestLength = n;
            this.nodeOffset = l = this.computeNodeOffset();
            Blake2sDigest blake2sDigest2 = blake2sDigest;
            blake2sDigest = new Blake2sDigest(32, byArray, byArray2, byArray3, l);
            this.hash = blake2sDigest2;
            return;
        }
        throw new IllegalArgumentException("BLAKE2xs digest length must be between 1 and 2^16-1");
    }

    public Blake2xsDigest(Blake2xsDigest blake2xsDigest) {
        Blake2xsDigest blake2xsDigest2 = this;
        this.h0 = null;
        this.buf = new byte[32];
        this.bufPos = 32;
        this.digestPos = 0;
        this.blockPos = 0L;
        blake2xsDigest2.digestLength = blake2xsDigest.digestLength;
        blake2xsDigest2.hash = new Blake2sDigest(blake2xsDigest.hash);
        this.h0 = Arrays.clone(blake2xsDigest.h0);
        this.buf = Arrays.clone(blake2xsDigest.buf);
        this.bufPos = blake2xsDigest.bufPos;
        this.digestPos = blake2xsDigest.digestPos;
        this.blockPos = blake2xsDigest.blockPos;
        this.nodeOffset = blake2xsDigest.nodeOffset;
    }

    private int computeStepLength() {
        int n = this.digestLength;
        if (n == 65535) {
            return 32;
        }
        return Math.min(32, n - this.digestPos);
    }

    private long computeNodeOffset() {
        return (long)this.digestLength * 0x100000000L;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2xs";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return this.hash.getByteLength();
    }

    public long getUnknownMaxLength() {
        return 0x2000000000L;
    }

    @Override
    public void update(byte by) {
        this.hash.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.hash.update(byArray, n, n2);
    }

    @Override
    public void reset() {
        Blake2xsDigest blake2xsDigest = this;
        blake2xsDigest.hash.reset();
        blake2xsDigest.h0 = null;
        blake2xsDigest.bufPos = 32;
        blake2xsDigest.digestPos = 0;
        blake2xsDigest.blockPos = 0L;
        blake2xsDigest.nodeOffset = blake2xsDigest.computeNodeOffset();
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return this.doFinal(byArray, n, byArray.length);
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        block10: {
            block9: {
                block8: {
                    if (this.h0 == null) {
                        Blake2xsDigest blake2xsDigest = this;
                        byte[] byArray2 = new byte[blake2xsDigest.hash.getDigestSize()];
                        blake2xsDigest.h0 = byArray2;
                        blake2xsDigest.hash.doFinal(byArray2, 0);
                    }
                    if ((n = this.digestLength) == 65535) break block8;
                    if (this.digestPos + n2 > n) {
                        throw new IllegalArgumentException("Output length is above the digest length");
                    }
                    break block9;
                }
                if (this.blockPos << 5 >= this.getUnknownMaxLength()) break block10;
            }
            for (n = 0; n < n2; ++n) {
                Object object;
                if (this.bufPos >= 32) {
                    Blake2sDigest blake2sDigest;
                    Blake2xsDigest blake2xsDigest = this;
                    object = blake2sDigest;
                    Blake2xsDigest blake2xsDigest2 = this;
                    Blake2xsDigest blake2xsDigest3 = this;
                    int n3 = blake2xsDigest3.computeStepLength();
                    long l = blake2xsDigest3.nodeOffset;
                    ((Blake2sDigest)object)(n3, 32, l);
                    ((Blake2sDigest)object).update(this.h0, 0, this.h0.length);
                    Arrays.fill(blake2xsDigest2.buf, (byte)0);
                    blake2sDigest.doFinal(blake2xsDigest2.buf, 0);
                    blake2xsDigest.bufPos = 0;
                    ++blake2xsDigest.nodeOffset;
                    ++blake2xsDigest.blockPos;
                }
                Blake2xsDigest blake2xsDigest = this;
                object = blake2xsDigest.buf;
                int n4 = blake2xsDigest.bufPos;
                byArray[n] = object[n4];
                blake2xsDigest.bufPos = n4 + 1;
                ++blake2xsDigest.digestPos;
            }
            return n2;
        }
        throw new IllegalArgumentException("Maximum length is 2^32 blocks of 32 bytes");
    }
}

