/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;

public class MD2Digest
implements ExtendedDigest,
Memoable {
    private static final int DIGEST_LENGTH = 16;
    private static final byte[] S = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};
    private byte[] X;
    private int xOff;
    private byte[] M;
    private int mOff;
    private byte[] C;
    private int COff;

    public MD2Digest() {
        MD2Digest mD2Digest = this;
        mD2Digest.X = new byte[48];
        mD2Digest.M = new byte[16];
        mD2Digest.C = new byte[16];
        mD2Digest.reset();
    }

    public MD2Digest(MD2Digest mD2Digest) {
        this.X = new byte[48];
        this.M = new byte[16];
        this.C = new byte[16];
        this.copyIn(mD2Digest);
    }

    private void copyIn(MD2Digest object) {
        MD2Digest mD2Digest = object2;
        MD2Digest mD2Digest2 = object;
        MD2Digest mD2Digest3 = object;
        MD2Digest mD2Digest4 = object;
        object = ((MD2Digest)object2).X;
        int n = mD2Digest4.X.length;
        System.arraycopy(mD2Digest4.X, 0, object, 0, n);
        ((MD2Digest)object2).xOff = mD2Digest4.xOff;
        object = ((MD2Digest)object2).M;
        n = mD2Digest3.M.length;
        System.arraycopy(mD2Digest3.M, 0, object, 0, n);
        ((MD2Digest)object2).mOff = mD2Digest3.mOff;
        Object object2 = ((MD2Digest)object2).C;
        int n2 = mD2Digest2.C.length;
        System.arraycopy(mD2Digest2.C, 0, object2, 0, n2);
        mD2Digest.COff = mD2Digest2.COff;
    }

    @Override
    public String getAlgorithmName() {
        return "MD2";
    }

    @Override
    public int getDigestSize() {
        return 16;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2;
        int n2 = this.mOff;
        byte by = (byte)(this.M.length - n2);
        while (true) {
            byArray2 = this.M;
            if (n2 >= this.M.length) break;
            byArray2[n2] = by;
            ++n2;
        }
        MD2Digest mD2Digest = this;
        mD2Digest.processCheckSum(byArray2);
        mD2Digest.processBlock(mD2Digest.M);
        mD2Digest.processBlock(mD2Digest.C);
        System.arraycopy(mD2Digest.X, this.xOff, byArray, n, 16);
        mD2Digest.reset();
        return 16;
    }

    @Override
    public void reset() {
        byte[] byArray;
        this.xOff = 0;
        int n = 0;
        while (true) {
            byArray = this.X;
            if (n == this.X.length) break;
            byArray[n] = 0;
            ++n;
        }
        this.mOff = 0;
        n = 0;
        while (true) {
            byArray = this.M;
            if (n == this.M.length) break;
            byArray[n] = 0;
            ++n;
        }
        this.COff = 0;
        n = 0;
        while (true) {
            byArray = this.C;
            if (n == this.C.length) break;
            byArray[n] = 0;
            ++n;
        }
    }

    @Override
    public void update(byte by) {
        int n;
        MD2Digest mD2Digest = this;
        byte[] byArray = mD2Digest.M;
        int n2 = mD2Digest.mOff;
        this.mOff = n = n2 + 1;
        byArray[n2] = by;
        if (n == 16) {
            MD2Digest mD2Digest2 = this;
            mD2Digest2.processCheckSum(byArray);
            mD2Digest2.processBlock(mD2Digest2.M);
            mD2Digest2.mOff = 0;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        while (this.mOff != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > 16) {
            MD2Digest mD2Digest = this;
            System.arraycopy(byArray, n, this.M, 0, 16);
            mD2Digest.processCheckSum(mD2Digest.M);
            mD2Digest.processBlock(mD2Digest.M);
            n2 -= 16;
            n += 16;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    public void processCheckSum(byte[] byArray) {
        byte by = this.C[15];
        for (int k = 0; k < 16; ++k) {
            this.C[k] = by = (byte)(this.C[k] ^ S[(byArray[k] ^ by) & 0xFF]);
        }
    }

    public void processBlock(byte[] byArray) {
        int n;
        for (n = 0; n < 16; ++n) {
            byte[] byArray2 = this.X;
            int n2 = n;
            int n3 = n2 + 16;
            byArray2[n3] = byArray[n2];
            n3 = n + 32;
            this.X[n3] = (byte)(byArray[n] ^ byArray2[n]);
        }
        int n4 = 0;
        for (n = 0; n < 18; ++n) {
            for (int k = 0; k < 48; ++k) {
                byte[] byArray3 = this.X;
                byte by = (byte)(this.X[k] ^ S[n4]);
                byArray3[k] = n4 = (int)by;
                n4 = by & 0xFF;
            }
            n4 = (n4 + n) % 256;
        }
    }

    @Override
    public int getByteLength() {
        return 16;
    }

    @Override
    public Memoable copy() {
        return new MD2Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        this.copyIn((MD2Digest)memoable);
    }
}

