/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECPairTransform;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewPublicKeyTransform
implements ECPairTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(CipherParameters cipherParameters) {
        block5: {
            block4: {
                block2: {
                    block3: {
                        if (!(cipherParameters instanceof ParametersWithRandom)) break block2;
                        if (!(((ParametersWithRandom)(cipherParameters = (ParametersWithRandom)cipherParameters)).getParameters() instanceof ECPublicKeyParameters)) break block3;
                        this.key = (ECPublicKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
                        this.random = ((ParametersWithRandom)cipherParameters).getRandom();
                        break block4;
                    }
                    throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
                }
                if (!(cipherParameters instanceof ECPublicKeyParameters)) break block5;
                ECNewPublicKeyTransform eCNewPublicKeyTransform = this;
                eCNewPublicKeyTransform.key = (ECPublicKeyParameters)cipherParameters;
                eCNewPublicKeyTransform.random = CryptoServicesRegistrar.getSecureRandom();
            }
            return;
        }
        throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        Object object = ((ECNewPublicKeyTransform)((Object)eCPoint)).key;
        if (object != null) {
            object = ((ECKeyParameters)object).getParameters();
            ECNewPublicKeyTransform eCNewPublicKeyTransform = eCPoint;
            ECMultiplier eCMultiplier = eCNewPublicKeyTransform.createBasePointMultiplier();
            BigInteger bigInteger = ECUtil.generateK(((ECDomainParameters)object).getN(), eCNewPublicKeyTransform.random);
            ECPoint[] eCPointArray = new ECPoint[2];
            ECPoint[] eCPointArray2 = eCPointArray;
            eCPointArray2[0] = eCMultiplier.multiply(((ECDomainParameters)object).getG(), bigInteger);
            eCPointArray[1] = ((ECNewPublicKeyTransform)((Object)eCPoint)).key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(((ECDomainParameters)object).getCurve(), eCPair.getY()));
            ((ECDomainParameters)object).getCurve().normalizeAll(eCPointArray2);
            ECPoint eCPoint = eCPointArray2[0];
            return new ECPair(eCPoint, eCPointArray2[1]);
        }
        throw new IllegalStateException("ECNewPublicKeyTransform not initialised");
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

