/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SM3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Engine {
    private final Digest digest;
    private final Mode mode;
    private boolean forEncryption;
    private ECKeyParameters ecKey;
    private ECDomainParameters ecParams;
    private int curveLength;
    private SecureRandom random;

    public SM2Engine() {
        SM3Digest sM3Digest;
        SM2Engine sM2Engine = sM3Digest2;
        SM3Digest sM3Digest2 = sM3Digest;
        sM3Digest = new SM3Digest();
        sM2Engine(sM3Digest2);
    }

    public SM2Engine(Mode mode) {
        SM3Digest sM3Digest;
        SM2Engine sM2Engine = sM3Digest2;
        SM3Digest sM3Digest2 = sM3Digest;
        sM3Digest = new SM3Digest();
        sM2Engine(sM3Digest2, mode);
    }

    public SM2Engine(Digest digest) {
        this(digest, Mode.C1C2C3);
    }

    public SM2Engine(Digest digest, Mode mode) {
        if (mode != null) {
            SM2Engine sM2Engine = this;
            sM2Engine.digest = digest;
            sM2Engine.mode = mode;
            return;
        }
        throw new IllegalArgumentException("mode cannot be NULL");
    }

    private byte[] encrypt(byte[] object, int n, int n2) {
        byte[] byArray;
        Object object2;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(object, n, byArray2, 0, n2);
        Object object3 = this.createBasePointMultiplier();
        do {
            SM2Engine sM2Engine = this;
            SM2Engine sM2Engine2 = this;
            object2 = sM2Engine2.nextK();
            byArray = object3.multiply(sM2Engine2.ecParams.getG(), (BigInteger)object2).normalize().getEncoded(false);
            object2 = ((ECPublicKeyParameters)sM2Engine.ecKey).getQ().multiply((BigInteger)object2).normalize();
            sM2Engine.kdf(sM2Engine.digest, (ECPoint)object2, byArray2);
        } while (this.notEncrypted(byArray2, (byte[])object, n));
        SM2Engine sM2Engine = this;
        Object object4 = object2;
        SM2Engine sM2Engine3 = this;
        Object object5 = object2;
        SM2Engine sM2Engine4 = this;
        object3 = new byte[sM2Engine4.digest.getDigestSize()];
        object2 = sM2Engine4.digest;
        sM2Engine3.addFieldElement((Digest)object2, ((ECPoint)object5).getAffineXCoord());
        sM2Engine3.digest.update((byte[])object, n, n2);
        object = sM2Engine3.digest;
        sM2Engine.addFieldElement((Digest)object, ((ECPoint)object4).getAffineYCoord());
        sM2Engine.digest.doFinal((byte[])object3, 0);
        if (1.$SwitchMap$com$fis$ekyc$nfc$build_in$bouncycastle$crypto$engines$SM2Engine$Mode[this.mode.ordinal()] != 1) {
            return Arrays.concatenate(byArray, byArray2, (byte[])object3);
        }
        return Arrays.concatenate(byArray, (byte[])object3, byArray2);
    }

    private byte[] decrypt(byte[] byArray, int n, int n2) {
        int n3 = this.curveLength * 2 + 1;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        ECPoint eCPoint = this.ecParams.getCurve().decodePoint(byArray2);
        if (!eCPoint.multiply(this.ecParams.getH()).isInfinity()) {
            Object object = eCPoint.multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
            int n4 = this.digest.getDigestSize();
            int n5 = n2 - n3 - n4;
            byte[] byArray3 = new byte[n5];
            Mode mode = Mode.C1C3C2;
            if (this.mode == mode) {
                System.arraycopy(byArray, n + n3 + n4, byArray3, 0, n5);
            } else {
                System.arraycopy(byArray, n + n3, byArray3, 0, n5);
            }
            SM2Engine sM2Engine = this;
            ECPoint eCPoint2 = object;
            SM2Engine sM2Engine2 = this;
            ECPoint eCPoint3 = object;
            SM2Engine sM2Engine3 = this;
            sM2Engine3.kdf(sM2Engine3.digest, (ECPoint)object, byArray3);
            int n6 = sM2Engine3.digest.getDigestSize();
            object = new byte[n6];
            Digest digest = sM2Engine3.digest;
            sM2Engine2.addFieldElement(digest, eCPoint3.getAffineXCoord());
            sM2Engine2.digest.update(byArray3, 0, n5);
            digest = sM2Engine2.digest;
            sM2Engine.addFieldElement(digest, eCPoint2.getAffineYCoord());
            sM2Engine.digest.doFinal((byte[])object, 0);
            int n7 = 0;
            if (sM2Engine.mode == mode) {
                for (n5 = 0; n5 != n6; ++n5) {
                    n7 |= object[n5] ^ byArray[n + n3 + n5];
                }
            } else {
                for (int k = 0; k != n6; ++k) {
                    n7 |= object[k] ^ byArray[a.a(n, n3, n5, k)];
                }
            }
            Arrays.fill(byArray2, (byte)0);
            Arrays.fill((byte[])object, (byte)0);
            if (n7 == 0) {
                return byArray3;
            }
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        throw new InvalidCipherTextException("[h]C1 at infinity");
    }

    private boolean notEncrypted(byte[] byArray, byte[] byArray2, int n) {
        for (int k = 0; k != byArray.length; ++k) {
            if (byArray[k] == byArray2[n + k]) continue;
            return false;
        }
        return true;
    }

    private void kdf(Digest digest, ECPoint eCPoint, byte[] byArray) {
        Digest digest2 = digest;
        int n = digest2.getDigestSize();
        byte[] byArray2 = new byte[Math.max(4, n)];
        int n2 = 0;
        Memoable memoable = null;
        Memoable memoable2 = null;
        if (digest2 instanceof Memoable) {
            this.addFieldElement(digest, eCPoint.getAffineXCoord());
            this.addFieldElement(digest, eCPoint.getAffineYCoord());
            memoable = (Memoable)((Object)digest);
            memoable2 = memoable.copy();
        }
        int n3 = 0;
        while (n2 < byArray.length) {
            if (memoable != null) {
                memoable.reset(memoable2);
            } else {
                this.addFieldElement(digest, eCPoint.getAffineXCoord());
                this.addFieldElement(digest, eCPoint.getAffineYCoord());
            }
            Pack.intToBigEndian(++n3, byArray2, 0);
            digest.update(byArray2, 0, 4);
            digest.doFinal(byArray2, 0);
            int n4 = Math.min(n, byArray.length - n2);
            this.xor(byArray, byArray2, n2, n4);
            n2 += n4;
        }
    }

    private void xor(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int k = 0; k != n2; ++k) {
            int n3 = n + k;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[k]);
        }
    }

    private BigInteger nextK() {
        BigInteger bigInteger;
        int n = this.ecParams.getN().bitLength();
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).equals(BigIntegers.ZERO) || bigInteger.compareTo(this.ecParams.getN()) >= 0) {
        }
        return bigInteger;
    }

    private void addFieldElement(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.curveLength, eCFieldElement.toBigInteger());
        digest.update(byArray, 0, byArray.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncryption = bl;
        if (bl) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = (ECKeyParameters)parametersWithRandom.getParameters();
            this.ecKey = cipherParameters;
            this.ecParams = ((ECKeyParameters)cipherParameters).getParameters();
            if (((ECPublicKeyParameters)this.ecKey).getQ().multiply(this.ecParams.getH()).isInfinity()) throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            this.random = parametersWithRandom.getRandom();
        } else {
            ECKeyParameters eCKeyParameters;
            SM2Engine sM2Engine = this;
            sM2Engine.ecKey = eCKeyParameters = (ECKeyParameters)cipherParameters;
            sM2Engine.ecParams = eCKeyParameters.getParameters();
        }
        this.curveLength = (this.ecParams.getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) {
        if (this.forEncryption) {
            return this.encrypt(byArray, n, n2);
        }
        return this.decrypt(byArray, n, n2);
    }

    public int getOutputSize(int n) {
        SM2Engine sM2Engine = this;
        int n2 = sM2Engine.curveLength * 2 + 1 + n;
        return sM2Engine.digest.getDigestSize() + n2;
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode C1C2C3;
        public static final /* enum */ Mode C1C3C2;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }

        static {
            Mode mode;
            Mode mode2;
            Mode mode3 = mode2;
            C1C2C3 = new Mode();
            Mode mode4 = mode;
            C1C3C2 = new Mode();
            $VALUES = new Mode[]{mode3, mode4};
        }
    }
}

