/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class VMPCEngine
implements StreamCipher {
    public byte n = 0;
    public byte[] P = null;
    public byte s = 0;
    public byte[] workingIV;
    public byte[] workingKey;

    @Override
    public String getAlgorithmName() {
        return "VMPC";
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        if (object instanceof ParametersWithIV) {
            CipherParameters cipherParameters = (ParametersWithIV)object;
            if (((ParametersWithIV)cipherParameters).getParameters() instanceof KeyParameter) {
                ParametersWithIV parametersWithIV = cipherParameters;
                cipherParameters = (KeyParameter)parametersWithIV.getParameters();
                byte[] byArray = parametersWithIV.getIV();
                object = byArray;
                ((VMPCEngine)object2).workingIV = (byte[])object;
                if (byArray != null && ((Object)object).length >= 1 && ((Object)object).length <= 768) {
                    VMPCEngine vMPCEngine = object2;
                    byte[] byArray2 = ((KeyParameter)cipherParameters).getKey();
                    Object object2 = byArray2;
                    vMPCEngine.workingKey = byArray2;
                    vMPCEngine.initKey((byte[])object2, vMPCEngine.workingIV);
                    return;
                }
                throw new IllegalArgumentException("VMPC requires 1 to 768 bytes of IV");
            }
            throw new IllegalArgumentException("VMPC init parameters must include a key");
        }
        throw new IllegalArgumentException("VMPC init parameters must include an IV");
    }

    public void initKey(byte[] byArray, byte[] byArray2) {
        byte by;
        int n;
        VMPCEngine vMPCEngine = this;
        vMPCEngine.s = 0;
        vMPCEngine.P = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3 = n2++;
            this.P[n3] = (byte)n3;
        }
        for (n2 = 0; n2 < 768; ++n2) {
            byte by2;
            byte[] byArray3 = this.P;
            n = n2 & 0xFF;
            by = byArray3[n];
            this.s = by2 = byArray3[this.s + by + byArray[n2 % byArray.length] & 0xFF];
            byArray3[n] = byArray3[by2 & 0xFF];
            this.P[by2 & 0xFF] = by;
        }
        for (int k = 0; k < 768; ++k) {
            byte[] byArray4 = this.P;
            int n4 = k & 0xFF;
            n = byArray4[n4];
            this.s = by = byArray4[this.s + n + byArray2[k % byArray2.length] & 0xFF];
            byArray4[n4] = byArray4[by & 0xFF];
            this.P[by & 0xFF] = n;
        }
        this.n = 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 <= byArray.length) {
            if (n3 + n2 <= byArray2.length) {
                for (int k = 0; k < n2; ++k) {
                    VMPCEngine vMPCEngine = this;
                    byte[] byArray3 = vMPCEngine.P;
                    int n4 = vMPCEngine.s;
                    int n5 = vMPCEngine.n;
                    int n6 = n5;
                    int n7 = byArray3[n4 + byArray3[n6 & 0xFF] & 0xFF];
                    int n8 = this.s = (n4 = n7);
                    byte by = byArray3[byArray3[byArray3[n4 & 0xFF] & 0xFF] + 1 & 0xFF];
                    n4 = byArray3[n6 & 0xFF];
                    byArray3[n6 &= 0xFF] = byArray3[n8 & 0xFF];
                    byArray3[n7 & 0xFF] = n4;
                    vMPCEngine.n = (byte)(n5 + 1 & 0xFF);
                    n4 = k + n3;
                    byArray2[n4] = (byte)(byArray[k + n] ^ by);
                }
                return n2;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    @Override
    public void reset() {
        VMPCEngine vMPCEngine = object;
        Object object = vMPCEngine.workingKey;
        vMPCEngine.initKey((byte[])object, vMPCEngine.workingIV);
    }

    @Override
    public byte returnByte(byte by) {
        VMPCEngine vMPCEngine = this;
        byte[] byArray = vMPCEngine.P;
        int n = vMPCEngine.s;
        byte by2 = vMPCEngine.n;
        int n2 = byArray[n + byArray[by2 & 0xFF] & 0xFF];
        int n3 = this.s = (n = n2);
        byte by3 = byArray[byArray[byArray[n & 0xFF] & 0xFF] + 1 & 0xFF];
        byte by4 = byArray[by2 & 0xFF];
        n = by2 & 0xFF;
        byArray[n] = byArray[n3 & 0xFF];
        byArray[n2 & 0xFF] = by4;
        vMPCEngine.n = (byte)(by2 + 1 & 0xFF);
        return (byte)(by ^ by3);
    }
}

