/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Ed25519ctxSigner
implements Signer {
    private final Buffer buffer = new Buffer(null);
    private final byte[] context;
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public Ed25519ctxSigner(byte[] byArray) {
        this.context = Arrays.clone(byArray);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            Ed25519ctxSigner ed25519ctxSigner = this;
            ed25519ctxSigner.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            ed25519ctxSigner.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        ((OutputStream)this.buffer).write(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        ((OutputStream)this.buffer).write(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters;
        if (this.forSigning && (ed25519PrivateKeyParameters = this.privateKey) != null) {
            return this.buffer.generateSignature(ed25519PrivateKeyParameters, this.context);
        }
        throw new IllegalStateException("Ed25519ctxSigner not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters;
        if (!this.forSigning && (ed25519PublicKeyParameters = this.publicKey) != null) {
            return this.buffer.verifySignature(ed25519PublicKeyParameters, this.context, byArray);
        }
        throw new IllegalStateException("Ed25519ctxSigner not initialised for verification");
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    public static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        public /* synthetic */ Buffer(1 var1_1) {
            this();
        }

        public synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters, byte[] byArray) {
            byte[] byArray2 = new byte[64];
            Buffer buffer = object;
            Buffer buffer2 = object;
            Object object = buffer2.buf;
            int n = buffer2.count;
            ed25519PrivateKeyParameters.sign(1, byArray, (byte[])object, 0, n, byArray2, 0);
            buffer.reset();
            return byArray2;
        }

        public synchronized boolean verifySignature(Ed25519PublicKeyParameters object, byte[] byArray, byte[] byArray2) {
            if (64 != byArray2.length) {
                this.reset();
                return false;
            }
            byte[] byArray3 = byArray2;
            Buffer buffer = this;
            object = ((Ed25519PublicKeyParameters)object).getEncoded();
            byArray2 = buffer.buf;
            int n = buffer.count;
            boolean bl = Ed25519.verify(byArray3, 0, (byte[])object, 0, byArray, byArray2, 0, n);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

