/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.its.asn1;

import c.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.its.asn1.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class BitmapSspRange
extends ASN1Object {
    private final byte[] sspValue;
    private final byte[] sspBitmask;

    private BitmapSspRange(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.sspValue = Utils.octetStringFixed(a.a(aSN1Sequence, 0));
            this.sspBitmask = Utils.octetStringFixed(a.a(aSN1Sequence, 1));
            return;
        }
        throw new IllegalArgumentException("expected sequence with sspValue and sspBitmask");
    }

    public static BitmapSspRange getInstance(Object object) {
        if (object instanceof BitmapSspRange) {
            return (BitmapSspRange)object;
        }
        if (object != null) {
            return new BitmapSspRange(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public byte[] getSspValue() {
        return Arrays.clone(this.sspValue);
    }

    public byte[] getSspBitmask() {
        return Arrays.clone(this.sspBitmask);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new DEROctetString(this.sspValue));
        aSN1EncodableVector2.add(new DEROctetString(this.sspBitmask));
        return new DERSequence(aSN1EncodableVector2);
    }
}

