/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;

public class HybridValueParameterSpec
implements AlgorithmParameterSpec,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed;
    private volatile byte[] t;
    private volatile AlgorithmParameterSpec baseSpec;

    public HybridValueParameterSpec(byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) {
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.hasBeenDestroyed = atomicBoolean2;
        v1.t = byArray;
        v1.baseSpec = algorithmParameterSpec;
    }

    private void checkDestroyed() {
        if (!this.isDestroyed()) {
            return;
        }
        throw new IllegalStateException("spec has been destroyed");
    }

    public byte[] getT() {
        HybridValueParameterSpec hybridValueParameterSpec = this;
        hybridValueParameterSpec.checkDestroyed();
        return hybridValueParameterSpec.t;
    }

    public AlgorithmParameterSpec getBaseParameterSpec() {
        HybridValueParameterSpec hybridValueParameterSpec = this;
        hybridValueParameterSpec.checkDestroyed();
        return hybridValueParameterSpec.baseSpec;
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.t);
            this.t = null;
            this.baseSpec = null;
        }
    }
}

