/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SM2P256V1_AFFINE_ZS;
    public SM2P256V1Point infinity;

    public SM2P256V1Curve() {
        SM2P256V1Curve sM2P256V1Curve = this;
        super(q);
        sM2P256V1Curve.infinity = new SM2P256V1Point(this, null, null);
        sM2P256V1Curve.a = sM2P256V1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        sM2P256V1Curve.b = sM2P256V1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        sM2P256V1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        sM2P256V1Curve.cofactor = BigInteger.valueOf(1L);
        sM2P256V1Curve.coord = 2;
    }

    static {
        SM2P256V1FieldElement sM2P256V1FieldElement;
        q = SM2P256V1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SM2P256V1FieldElement sM2P256V1FieldElement2 = sM2P256V1FieldElement;
        sM2P256V1FieldElement = new SM2P256V1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = sM2P256V1FieldElement2;
        SM2P256V1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SM2P256V1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SM2P256V1FieldElement sM2P256V1FieldElement;
                SM2P256V1FieldElement sM2P256V1FieldElement2 = sM2P256V1FieldElement;
                sM2P256V1FieldElement = new SM2P256V1FieldElement(nArray2);
                return sM2P256V1FieldElement2.SM2P256V1Curve.this.createRawPoint(new SM2P256V1FieldElement(nArray3), sM2P256V1FieldElement2, SM2P256V1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 8 + i2] & n3;
                    }
                    n22 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = n * 8 * 2;
                for (int k = 0; k < 8; ++k) {
                    int[] nArray3 = nArray;
                    nArray4[k] = nArray3[n22 + k];
                    nArray2[k] = nArray[n22 + 8 + k];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SM2P256V1Field.random(secureRandom, nArray);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SM2P256V1Field.randomMult(secureRandom, nArray);
        return new SM2P256V1FieldElement((int[])object);
    }
}

