/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192K1Field {
    public static final int[] P = new int[]{-4553, -2, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{20729809, 9106, 1, 0, 0, 0, -9106, -3, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-20729809, -9107, -2, -1, -1, -1, 9105, 2};
    private static final int P5 = -1;
    private static final int PExt11 = -1;
    private static final int PInv33 = 4553;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat192.add(nArray, nArray2, nArray3) != 0 || nArray3[5] == -1 && Nat192.gte(nArray3, P)) {
            Nat.add33To(6, 4553, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(12, nArray, nArray2, nArray3) != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(12, nArray3, n);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(6, nArray, nArray2) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat192.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[5] == -1) {
            int[] nArray2 = P;
            if (Nat192.gte((int[])object, P)) {
                Nat192.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(6, nArray, 0, nArray2);
        } else {
            int n = Nat192.add(nArray, P, nArray2);
            Nat.shiftDownBit(6, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 6; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat192.createExt();
        Nat192.mul(nArray, nArray2, nArray4);
        SecP192K1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat192.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(12, nArray3, n);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP192K1Field.isZero(nArray) != 0) {
            Nat192.sub(P, P, nArray2);
        } else {
            Nat192.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[24];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 6);
        } while (Nat.lessThan(6, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP192K1Field.random(secureRandom, nArray);
        } while (SecP192K1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = Nat192.mul33Add(4553, nArray, 6, nArray, 0, nArray2, 0);
        if (Nat192.mul33DWordAdd(4553, l, nArray2, 0) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat192.mul33WordAdd(4553, n, nArray, 0) != 0 || nArray[5] == -1 && Nat192.gte(nArray, P)) {
            Nat.add33To(6, 4553, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square(nArray, nArray3);
        SecP192K1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square(nArray, nArray3);
        SecP192K1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat192.square(nArray2, nArray3);
            SecP192K1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat192.sub(nArray, nArray2, nArray3) != 0) {
            Nat.sub33From(6, 4553, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(12, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.decAt(12, nArray3, n);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(6, nArray, 0, nArray2) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }
}

