/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCSphincs256PublicKey
implements PublicKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.params = sPHINCSPublicKeyParameters;
    }

    public BCSphincs256PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCSphincs256PublicKey bCSphincs256PublicKey = this;
        bCSphincs256PublicKey.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.treeDigest = SPHINCS256KeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PublicKey) {
            object = (BCSphincs256PublicKey)object;
            return this.treeDigest.equals(((BCSphincs256PublicKey)object).treeDigest) && Arrays.areEqual(this.params.getKeyData(), ((BCSphincs256PublicKey)object).params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        BCSphincs256PublicKey bCSphincs256PublicKey = this;
        int n = bCSphincs256PublicKey.treeDigest.hashCode();
        return Arrays.hashCode(bCSphincs256PublicKey.params.getKeyData()) * 37 + n;
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        block8: {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            AlgorithmIdentifier algorithmIdentifier;
            Object object;
            block7: {
                try {
                    if (((BCSphincs256PublicKey)object).params.getTreeDigest() == null) break block7;
                }
                catch (IOException iOException) {
                    return null;
                }
                object = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(((BCSphincs256PublicKey)object).params);
                break block8;
            }
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(((BCSphincs256PublicKey)object).treeDigest)));
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo;
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier2, ((BCSphincs256PublicKey)object).params.getKeyData());
            object = subjectPublicKeyInfo2;
        }
        return ((ASN1Object)object).getEncoded();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    public ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    public CipherParameters getKeyParams() {
        return this.params;
    }
}

