/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest digest;
    private XMSSSigner signer;
    private SecureRandom random;
    private ASN1ObjectIdentifier treeDigest;

    public XMSSSignatureSpi(String string) {
        super(string);
    }

    public XMSSSignatureSpi(String string, Digest digest, XMSSSigner xMSSSigner) {
        super(string);
        this.digest = digest;
        this.signer = xMSSSigner;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof BCXMSSPublicKey) {
            XMSSSignatureSpi xMSSSignatureSpi = cipherParameters;
            CipherParameters cipherParameters = ((BCXMSSPublicKey)publicKey).getKeyParams();
            xMSSSignatureSpi.treeDigest = null;
            xMSSSignatureSpi.digest.reset();
            xMSSSignatureSpi.signer.init(false, cipherParameters);
            return;
        }
        throw new InvalidKeyException("unknown public key passed to XMSS");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey bCXMSSPrivateKey = (BCXMSSPrivateKey)object;
            object = bCXMSSPrivateKey.getKeyParams();
            this.treeDigest = bCXMSSPrivateKey.getTreeDigestOID();
            SecureRandom secureRandom = this.random;
            if (secureRandom != null) {
                ParametersWithRandom parametersWithRandom;
                ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
                parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
                object = parametersWithRandom2;
            }
            XMSSSignatureSpi xMSSSignatureSpi = this;
            xMSSSignatureSpi.digest.reset();
            xMSSSignatureSpi.signer.init(true, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("unknown private key passed to XMSS");
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        XMSSSignatureSpi xMSSSignatureSpi = object;
        Object object = DigestUtil.getDigestResult(xMSSSignatureSpi.digest);
        try {
            return xMSSSignatureSpi.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage(), exception);
            }
            throw new SignatureException(((Object)exception).toString(), exception);
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        XMSSSignatureSpi xMSSSignatureSpi = object;
        Object object = DigestUtil.getDigestResult(xMSSSignatureSpi.digest);
        return xMSSSignatureSpi.signer.verifySignature((byte[])object, byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public boolean isSigningCapable() {
        return this.treeDigest != null && this.signer.getUsagesRemaining() != 0L;
    }

    @Override
    public PrivateKey getUpdatedPrivateKey() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.treeDigest;
        if (aSN1ObjectIdentifier != null) {
            this.treeDigest = null;
            return new BCXMSSPrivateKey(aSN1ObjectIdentifier, (XMSSPrivateKeyParameters)this.signer.getUpdatedPrivateKey());
        }
        throw new IllegalStateException("signature object not in a signing state");
    }

    public static class withShake256andPrehash
    extends XMSSSignatureSpi {
        public withShake256andPrehash() {
            XMSSSigner xMSSSigner;
            SHAKEDigest sHAKEDigest;
            withShake256andPrehash withShake256andPrehash2 = sHAKEDigest2;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest = new SHAKEDigest(256);
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("SHAKE256withXMSS-SHAKE256", sHAKEDigest2, xMSSSigner2);
        }
    }

    public static class withSha512andPrehash
    extends XMSSSignatureSpi {
        public withSha512andPrehash() {
            XMSSSigner xMSSSigner;
            SHA512Digest sHA512Digest;
            withSha512andPrehash withSha512andPrehash2 = sHA512Digest2;
            SHA512Digest sHA512Digest2 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("SHA512withXMSS-SHA512", sHA512Digest2, xMSSSigner2);
        }
    }

    public static class withShake128andPrehash
    extends XMSSSignatureSpi {
        public withShake128andPrehash() {
            XMSSSigner xMSSSigner;
            SHAKEDigest sHAKEDigest;
            withShake128andPrehash withShake128andPrehash2 = sHAKEDigest2;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest = new SHAKEDigest(128);
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("SHAKE128withXMSSMT-SHAKE128", sHAKEDigest2, xMSSSigner2);
        }
    }

    public static class withSha256andPrehash
    extends XMSSSignatureSpi {
        public withSha256andPrehash() {
            XMSSSigner xMSSSigner;
            SHA256Digest sHA256Digest;
            withSha256andPrehash withSha256andPrehash2 = sHA256Digest2;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("SHA256withXMSS-SHA256", sHA256Digest2, xMSSSigner2);
        }
    }

    public static class withShake256
    extends XMSSSignatureSpi {
        public withShake256() {
            XMSSSigner xMSSSigner;
            NullDigest nullDigest;
            withShake256 withShake2562 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("XMSS-SHAKE256", nullDigest2, xMSSSigner2);
        }
    }

    public static class withSha512
    extends XMSSSignatureSpi {
        public withSha512() {
            XMSSSigner xMSSSigner;
            NullDigest nullDigest;
            withSha512 withSha5122 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("XMSS-SHA512", nullDigest2, xMSSSigner2);
        }
    }

    public static class withShake128
    extends XMSSSignatureSpi {
        public withShake128() {
            XMSSSigner xMSSSigner;
            NullDigest nullDigest;
            withShake128 withShake1282 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("XMSS-SHAKE128", nullDigest2, xMSSSigner2);
        }
    }

    public static class withSha256
    extends XMSSSignatureSpi {
        public withSha256() {
            XMSSSigner xMSSSigner;
            NullDigest nullDigest;
            withSha256 withSha2562 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("XMSS-SHA256", nullDigest2, xMSSSigner2);
        }
    }

    public static class generic
    extends XMSSSignatureSpi {
        public generic() {
            XMSSSigner xMSSSigner;
            NullDigest nullDigest;
            generic generic2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner = new XMSSSigner();
            super("XMSS", nullDigest2, xMSSSigner2);
        }
    }
}

