/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.StreamOverflowException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private static int BUFFER_SIZE = 4096;

    public static void drain(InputStream inputStream) {
        int n = BUFFER_SIZE;
        byte[] byArray = new byte[n];
        while (inputStream.read(byArray, 0, n) >= 0) {
        }
    }

    public static byte[] readAll(InputStream closeable) {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        Streams.pipeAll(inputStream, new ByteArrayOutputStream());
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static byte[] readAllLimited(InputStream closeable, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = closeable;
        closeable = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAllLimited(inputStream, n, (OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public static int readFully(InputStream inputStream, byte[] byArray) {
        return Streams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = n + n3;
            int n5 = n2 - n3;
            if ((n4 = inputStream.read(byArray, n4, n5)) < 0) break;
        }
        return n3;
    }

    public static void pipeAll(InputStream inputStream, OutputStream outputStream) {
        int n;
        int n2 = BUFFER_SIZE;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static long pipeAllLimited(InputStream inputStream, long l, OutputStream outputStream) {
        int n;
        long l2 = 0L;
        int n2 = BUFFER_SIZE;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
            long l3 = n;
            if (l - l2 >= l3) {
                l2 += l3;
                outputStream.write(byArray, 0, n);
                continue;
            }
            throw new StreamOverflowException("Data Overflow");
        }
        return l2;
    }

    public static void writeBufTo(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) {
        byteArrayOutputStream.writeTo(outputStream);
    }
}

