/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Enumerated;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.AnnotatedException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXPolicyNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Store;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.StoreException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.CertStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.PKIXCRLUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509CertStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Store;
import f.a;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class CertPathValidatorUtilities {
    public static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    public static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    public static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    public static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    public static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    public static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    public static final String KEY_USAGE = Extension.keyUsage.getId();
    public static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    public static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    public static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    public static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    public static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    public static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    public static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    public static final String ANY_POLICY = "2.5.29.32.0";
    public static final String CRL_NUMBER = Extension.cRLNumber.getId();
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    public static X500Principal getEncodedIssuerPrincipal(Object object) {
        if (object instanceof X509Certificate) {
            return ((X509Certificate)object).getIssuerX500Principal();
        }
        return (X500Principal)((X509AttributeCertificate)object).getIssuer().getPrincipals()[0];
    }

    public static Date getValidDate(PKIXParameters cloneable) {
        if ((cloneable = cloneable.getDate()) == null) {
            Date date;
            cloneable = date;
            date = new Date();
        }
        return cloneable;
    }

    public static X500Principal getSubjectPrincipal(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal();
    }

    public static boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    public static ASN1Primitive getExtensionValue(java.security.cert.X509Extension object, String string) {
        byte[] byArray = object.getExtensionValue(string);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(string, (byte[])object);
    }

    private static ASN1Primitive getObject(String string, byte[] object) {
        try {
            object = (ASN1OctetString)new ASN1InputStream((byte[])object).readObject();
        }
        catch (Exception exception) {
            throw new AnnotatedException(i.a("exception processing extension ", string), exception);
        }
        return new ASN1InputStream(((ASN1OctetString)object).getOctets()).readObject();
    }

    public static X500Principal getIssuerPrincipal(X509CRL x509CRL) {
        return x509CRL.getIssuerX500Principal();
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(new ASN1InputStream(publicKey.getEncoded()).readObject()).getAlgorithmId();
        }
        catch (Exception exception) {
            throw new ExtCertPathValidatorException("Subject public key cannot be decoded.", exception);
        }
    }

    public static final Set getQualifierSet(ASN1Sequence object) {
        ByteArrayOutputStream byteArrayOutputStream;
        HashSet<PolicyQualifierInfo> hashSet;
        HashSet<PolicyQualifierInfo> hashSet2 = hashSet;
        hashSet = new HashSet<PolicyQualifierInfo>();
        if (object == null) {
            return hashSet2;
        }
        ASN1Sequence aSN1Sequence = object;
        object = byteArrayOutputStream;
        ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(new ByteArrayOutputStream());
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object object2;
            try {
                object2 = object;
                aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
                hashSet2.add(new PolicyQualifierInfo(((ByteArrayOutputStream)object).toByteArray()));
            }
            catch (IOException iOException) {
                throw new ExtCertPathValidatorException("Policy qualifier info cannot be decoded.", iOException);
            }
            ((ByteArrayOutputStream)object2).reset();
        }
        return hashSet2;
    }

    public static PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode object) {
        PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)((PKIXPolicyNode)object).getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode2 == null) {
            for (int k = 0; k < listArray.length; ++k) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
                listArray[k] = object;
            }
            return null;
        }
        pKIXPolicyNode2.removeChild((PKIXPolicyNode)object);
        CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, (PKIXPolicyNode)object);
        return pKIXPolicyNode;
    }

    private static void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode object) {
        listArray[((PKIXPolicyNode)object).getDepth()].remove(object);
        if (((PKIXPolicyNode)object).hasChildren()) {
            object = ((PKIXPolicyNode)object).getChildren();
            while (object.hasNext()) {
                CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, (PKIXPolicyNode)object.next());
            }
        }
    }

    public static boolean processCertD1i(int n, List[] object, ASN1ObjectIdentifier object2, Set set) {
        Object object3 = object[n - 1];
        for (int k = 0; k < object3.size(); ++k) {
            ArrayList arrayList;
            PKIXPolicyNode pKIXPolicyNode;
            HashSet hashSet;
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)object3.get(k);
            if (!pKIXPolicyNode2.getExpectedPolicies().contains(((ASN1ObjectIdentifier)object2).getId())) continue;
            List[] listArray = object;
            object = hashSet;
            object();
            hashSet.add(((ASN1ObjectIdentifier)object2).getId());
            object3 = pKIXPolicyNode;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            String string = aSN1ObjectIdentifier.getId();
            pKIXPolicyNode2.addChild(new PKIXPolicyNode((List)object2, n, (Set)object, pKIXPolicyNode2, set, string, false));
            listArray[n].add(object3);
            return true;
        }
        return false;
    }

    public static void processCertD1ii(int n, List[] object, ASN1ObjectIdentifier object2, Set set) {
        Object object3 = object[n - 1];
        for (int k = 0; k < object3.size(); ++k) {
            ArrayList arrayList;
            PKIXPolicyNode pKIXPolicyNode;
            HashSet hashSet;
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)object3.get(k);
            if (!ANY_POLICY.equals(pKIXPolicyNode2.getValidPolicy())) continue;
            List[] listArray = object;
            object = hashSet;
            object();
            hashSet.add(((ASN1ObjectIdentifier)object2).getId());
            object3 = pKIXPolicyNode;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            String string = aSN1ObjectIdentifier.getId();
            pKIXPolicyNode2.addChild(new PKIXPolicyNode((List)object2, n, (Set)object, pKIXPolicyNode2, set, string, false));
            listArray[n].add(object3);
            return;
        }
    }

    public static void prepareNextCertB1(int n, List[] object, String string, Map object2, X509Certificate object3) {
        boolean bl = false;
        for (Object object4 : object[n]) {
            if (!((PKIXPolicyNode)object4).getValidPolicy().equals(string)) continue;
            bl = true;
            ((PKIXPolicyNode)object4).setExpectedPolicies((Set)object2.get(string));
            break;
        }
        if (!bl) {
            Object object5 = object[n].iterator();
            while (object5.hasNext()) {
                ArrayList arrayList;
                PKIXPolicyNode pKIXPolicyNode;
                Object object4;
                Object object6 = (PKIXPolicyNode)object5.next();
                if (!ANY_POLICY.equals(((PKIXPolicyNode)object6).getValidPolicy())) continue;
                object5 = null;
                try {
                    object4 = ASN1Sequence.getInstance(CertPathValidatorUtilities.getExtensionValue((java.security.cert.X509Extension)object3, CERTIFICATE_POLICIES)).getObjects();
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certificate policies cannot be decoded.", exception);
                }
                while (object4.hasMoreElements()) {
                    PolicyInformation policyInformation;
                    try {
                        policyInformation = PolicyInformation.getInstance(object4.nextElement());
                        if (!ANY_POLICY.equals(policyInformation.getPolicyIdentifier().getId())) continue;
                    }
                    catch (Exception exception) {
                        throw new AnnotatedException("Policy information cannot be decoded.", exception);
                    }
                    try {
                        object5 = CertPathValidatorUtilities.getQualifierSet(policyInformation.getPolicyQualifiers());
                        break;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        throw new ExtCertPathValidatorException("Policy qualifier info set could not be built.", certPathValidatorException);
                    }
                }
                boolean bl2 = false;
                if (object3.getCriticalExtensionOIDs() != null) {
                    bl2 = object3.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!ANY_POLICY.equals(((PKIXPolicyNode)(object3 = (PKIXPolicyNode)((PKIXPolicyNode)object6).getParent())).getValidPolicy())) break;
                List[] listArray = object;
                object = pKIXPolicyNode;
                Map map = object2;
                object2 = arrayList;
                arrayList = new ArrayList();
                object6 = (Set)map.get(string);
                ((PKIXPolicyNode)object3).addChild(new PKIXPolicyNode((List)object2, n, (Set)object6, (PolicyNode)object3, (Set)object5, string, bl2));
                listArray[n].add(object);
                break;
            }
        }
    }

    public static PKIXPolicyNode prepareNextCertB2(int n, List[] listArray, String string, PKIXPolicyNode pKIXPolicyNode) {
        Iterator iterator = listArray[n].iterator();
        while (iterator.hasNext()) {
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode2.getValidPolicy().equals(string)) continue;
            ((PKIXPolicyNode)pKIXPolicyNode2.getParent()).removeChild(pKIXPolicyNode2);
            iterator.remove();
            for (int k = n - 1; k >= 0; --k) {
                PKIXPolicyNode pKIXPolicyNode3;
                List list = listArray[k];
                for (int i2 = 0; i2 < list.size() && ((pKIXPolicyNode3 = (PKIXPolicyNode)list.get(i2)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3)) != null); ++i2) {
                }
            }
        }
        return pKIXPolicyNode;
    }

    public static boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Collection findCertificates(X509CertStoreSelector var0, List var1_5) {
        v0 = var1_5;
        var1_5 = v1;
        v1 = new HashSet<E>();
        var2_6 = v0.iterator();
        var3_7 = v2;
        v2 = new CertificateFactory();
        block12: while (var2_6.hasNext()) {
            block15: {
                var4_8 /* !! */  = var2_6.next();
                if (!(var4_8 /* !! */  instanceof Store)) break block15;
                var4_8 /* !! */  = ((Store)var4_8 /* !! */ ).getMatches(var0).iterator();
                block13: while (true) {
                    if (!var4_8 /* !! */ .hasNext()) continue block12;
                    var5_9 = var4_8 /* !! */ .next();
                    if (!(var5_9 instanceof Encodable)) break;
                    v3 = var1_5.add(var3_7.engineGenerateCertificate(new ByteArrayInputStream(((Encodable)var5_9).getEncoded())));
lbl21:
                    // 2 sources

                    continue block13;
                    break;
                }
                if (!(var5_9 instanceof Certificate)) ** GOTO lbl28
                try {
                    v3 = var1_5.add((Certificate)var5_9);
                    ** continue;
lbl28:
                    // 1 sources

                    throw new AnnotatedException("Unknown object found in certificate store.");
                }
                catch (CertificateException var0_1) {
                    throw new AnnotatedException("Problem while extracting certificates from X.509 store.", var0_1);
                }
                catch (IOException var0_2) {
                    throw new AnnotatedException("Problem while extracting certificates from X.509 store.", var0_2);
                }
                catch (StoreException var0_3) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", var0_3);
                }
            }
            try {
                var1_5.addAll(((CertStore)var4_8 /* !! */ ).getCertificates(var0));
            }
            catch (CertStoreException var0_4) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", var0_4);
            }
        }
        return var1_5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection findCertificates(PKIXCertStoreSelector pKIXCertStoreSelector, List collection) {
        HashSet hashSet;
        Collection<Object> collection2 = collection;
        collection = hashSet;
        hashSet = new HashSet();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object e2 = iterator.next();
            if (e2 instanceof Store) {
                try {
                    bl = collection.addAll(((Store)e2).getMatches(pKIXCertStoreSelector));
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
                }
            }
            try {
                bl = collection.addAll(PKIXCertStoreSelector.getCertificates(pKIXCertStoreSelector, (CertStore)e2));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return collection;
    }

    public static Collection findCertificates(X509AttributeCertStoreSelector x509AttributeCertStoreSelector, List collection) {
        HashSet hashSet;
        List list = collection;
        collection = hashSet;
        hashSet = new HashSet();
        for (Object e2 : list) {
            if (!(e2 instanceof X509Store)) continue;
            try {
                collection.addAll(((X509Store)e2).getMatches((Selector)x509AttributeCertStoreSelector));
            }
            catch (StoreException storeException) {
                throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
            }
        }
        return collection;
    }

    private static BigInteger getSerialNumber(Object object) {
        if (object instanceof X509Certificate) {
            return ((X509Certificate)object).getSerialNumber();
        }
        return ((X509AttributeCertificate)object).getSerialNumber();
    }

    public static void getCertStatus(Date date, X509CRL object, Object object2, CertStatus certStatus) {
        X509CRLEntry x509CRLEntry;
        block12: {
            block10: {
                X500Principal x500Principal;
                block11: {
                    try {
                        if (!CertPathValidatorUtilities.isIndirectCRL((X509CRL)object)) break block10;
                        x509CRLEntry = ((X509CRL)object).getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(object2));
                        if (x509CRLEntry == null) {
                            return;
                        }
                        x500Principal = x509CRLEntry.getCertificateIssuer();
                        if (x500Principal != null) break block11;
                    }
                    catch (CRLException cRLException) {
                        throw new AnnotatedException("Failed check for indirect CRL.", cRLException);
                    }
                    x500Principal = CertPathValidatorUtilities.getIssuerPrincipal((X509CRL)object);
                }
                if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(object2).equals(x500Principal)) {
                    return;
                }
                break block12;
            }
            if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(object2).equals(CertPathValidatorUtilities.getIssuerPrincipal((X509CRL)object))) {
                return;
            }
            x509CRLEntry = ((X509CRL)object).getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(object2));
            if (x509CRLEntry == null) {
                return;
            }
        }
        object = null;
        if (x509CRLEntry.hasExtensions()) {
            try {
                object = ASN1Enumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRLEntry, X509Extension.reasonCode.getId()));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", exception);
            }
        }
        int n = object == null ? 0 : ((ASN1Enumerated)object).intValueExact();
        if (date.getTime() >= x509CRLEntry.getRevocationDate().getTime() || n == 0 || n == 1 || n == 2 || n == 10) {
            certStatus.setCertStatus(n);
            certStatus.setRevocationDate(x509CRLEntry.getRevocationDate());
        }
    }

    public static PublicKey getNextWorkingKey(List object, int n) {
        Serializable serializable = ((Certificate)object.get(n)).getPublicKey();
        if (!(serializable instanceof DSAPublicKey)) {
            return serializable;
        }
        if ((serializable = (DSAPublicKey)serializable).getParams() != null) {
            return serializable;
        }
        while (++n < object.size()) {
            Serializable serializable2 = ((X509Certificate)object.get(n)).getPublicKey();
            if (serializable2 instanceof DSAPublicKey) {
                DSAPublicKeySpec dSAPublicKeySpec;
                if ((serializable2 = (DSAPublicKey)serializable2).getParams() == null) continue;
                object = serializable2.getParams();
                DSAPublicKeySpec dSAPublicKeySpec2 = dSAPublicKeySpec;
                Object object2 = object;
                object = serializable.getY();
                serializable = object2.getP();
                serializable2 = object2.getQ();
                BigInteger bigInteger = object2.getG();
                dSAPublicKeySpec = new DSAPublicKeySpec((BigInteger)object, (BigInteger)serializable, (BigInteger)serializable2, bigInteger);
                try {
                    return KeyFactory.getInstance("DSA", "BC").generatePublic(dSAPublicKeySpec2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
            throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    public static void verifyX509Certificate(X509Certificate x509Certificate, PublicKey publicKey, String string) {
        if (string == null) {
            x509Certificate.verify(publicKey);
        } else {
            x509Certificate.verify(publicKey, string);
        }
    }

    public static boolean isIndirectCRL(X509CRL object) {
        boolean bl;
        block5: {
            block4: {
                byte[] byArray;
                try {
                    byArray = object.getExtensionValue(Extension.issuingDistributionPoint.getId());
                }
                catch (Exception exception) {
                    throw new CRLException(a.a("Exception reading IssuingDistributionPoint: ", exception));
                }
                object = byArray;
                if (byArray != null) {
                    if (!IssuingDistributionPoint.getInstance(ASN1OctetString.getInstance(object).getOctets()).isIndirectCRL()) break block4;
                    bl = true;
                    break block5;
                }
            }
            bl = false;
        }
        return bl;
    }
}

