/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OtherHash
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString sha1Hash;
    private OtherHashAlgAndValue otherHash;

    public static OtherHash getInstance(Object object) {
        if (object instanceof OtherHash) {
            return (OtherHash)object;
        }
        if (object instanceof ASN1OctetString) {
            return new OtherHash((ASN1OctetString)object);
        }
        return new OtherHash(OtherHashAlgAndValue.getInstance(object));
    }

    private OtherHash(ASN1OctetString aSN1OctetString) {
        this.sha1Hash = aSN1OctetString;
    }

    public OtherHash(OtherHashAlgAndValue otherHashAlgAndValue) {
        this.otherHash = otherHashAlgAndValue;
    }

    public OtherHash(byte[] byArray) {
        DEROctetString dEROctetString;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        v1.sha1Hash = aSN1Object;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        ASN1Object aSN1Object = ((OtherHash)aSN1Object).otherHash;
        if (aSN1Object == null) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }
        return ((OtherHashAlgAndValue)aSN1Object).getHashAlgorithm();
    }

    public byte[] getHashValue() {
        OtherHashAlgAndValue otherHashAlgAndValue = this.otherHash;
        if (otherHashAlgAndValue == null) {
            return this.sha1Hash.getOctets();
        }
        return otherHashAlgAndValue.getHashValue().getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        OtherHashAlgAndValue otherHashAlgAndValue = this.otherHash;
        if (otherHashAlgAndValue == null) {
            return this.sha1Hash;
        }
        return otherHashAlgAndValue.toASN1Primitive();
    }
}

