/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERPrintableString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class MonetaryLimit
extends ASN1Object {
    public DERPrintableString currency;
    public ASN1Integer amount;
    public ASN1Integer exponent;

    public static MonetaryLimit getInstance(Object object) {
        if (object != null && !(object instanceof MonetaryLimit)) {
            if (object instanceof ASN1Sequence) {
                return new MonetaryLimit(ASN1Sequence.getInstance(object));
            }
            throw new IllegalArgumentException("unknown object in getInstance");
        }
        return (MonetaryLimit)object;
    }

    private MonetaryLimit(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 3) {
            MonetaryLimit monetaryLimit = enumeration;
            Enumeration enumeration = aSN1Sequence.getObjects();
            monetaryLimit.currency = DERPrintableString.getInstance(enumeration.nextElement());
            monetaryLimit.amount = ASN1Integer.getInstance(enumeration.nextElement());
            monetaryLimit.exponent = ASN1Integer.getInstance(enumeration.nextElement());
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, b.b.a("Bad sequence size: ")));
    }

    public MonetaryLimit(String string, int n, int n2) {
        this.currency = new DERPrintableString(string, true);
        this.amount = new ASN1Integer(n);
        this.exponent = new ASN1Integer(n2);
    }

    public String getCurrency() {
        return this.currency.getString();
    }

    public BigInteger getAmount() {
        return this.amount.getValue();
    }

    public BigInteger getExponent() {
        return this.exponent.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(this.currency);
        aSN1EncodableVector2.add(this.amount);
        aSN1EncodableVector.add(this.exponent);
        return new DERSequence(aSN1EncodableVector2);
    }
}

