/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SRP6GroupParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Server {
    public BigInteger N;
    public BigInteger g;
    public BigInteger v;
    public SecureRandom random;
    public Digest digest;
    public BigInteger A;
    public BigInteger b;
    public BigInteger B;
    public BigInteger u;
    public BigInteger S;
    public BigInteger M1;
    public BigInteger M2;
    public BigInteger Key;

    private BigInteger calculateS() {
        SRP6Server sRP6Server = bigInteger2;
        BigInteger bigInteger = sRP6Server.u;
        SRP6Server sRP6Server2 = bigInteger2;
        BigInteger bigInteger2 = sRP6Server2.b;
        return ((SRP6Server)((Object)bigInteger2)).v.modPow(bigInteger, sRP6Server.N).multiply(((SRP6Server)((Object)bigInteger2)).A).mod(((SRP6Server)((Object)bigInteger2)).N).modPow(bigInteger2, sRP6Server2.N);
    }

    public void init(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, Digest digest, SecureRandom secureRandom) {
        SRP6Server sRP6Server = this;
        sRP6Server.N = bigInteger;
        sRP6Server.g = bigInteger2;
        sRP6Server.v = bigInteger3;
        sRP6Server.random = secureRandom;
        sRP6Server.digest = digest;
    }

    public void init(SRP6GroupParameters sRP6GroupParameters, BigInteger bigInteger, Digest digest, SecureRandom secureRandom) {
        SRP6Server sRP6Server = bigInteger2;
        SRP6GroupParameters sRP6GroupParameters2 = sRP6GroupParameters;
        BigInteger bigInteger2 = sRP6GroupParameters2.getN();
        sRP6Server.init(bigInteger2, sRP6GroupParameters2.getG(), bigInteger, digest, secureRandom);
    }

    public BigInteger generateServerCredentials() {
        SRP6Server sRP6Server = this;
        BigInteger bigInteger = sRP6Server.N;
        SRP6Server sRP6Server2 = this;
        sRP6Server2.b = sRP6Server2.selectPrivateValue();
        BigInteger bigInteger2 = SRP6Util.calculateK(this.digest, bigInteger, sRP6Server.g).multiply(sRP6Server2.v).mod(this.N);
        SRP6Server sRP6Server3 = this;
        bigInteger = sRP6Server3.b;
        this.B = bigInteger2.add(this.g.modPow(bigInteger, sRP6Server3.N)).mod(this.N);
        return this.B;
    }

    public BigInteger calculateSecret(BigInteger bigInteger) {
        SRP6Server sRP6Server = this;
        sRP6Server.A = bigInteger = SRP6Util.validatePublicValue(sRP6Server.N, bigInteger);
        SRP6Server sRP6Server2 = this;
        BigInteger bigInteger2 = sRP6Server2.N;
        BigInteger bigInteger3 = sRP6Server2.B;
        sRP6Server.u = SRP6Util.calculateU(sRP6Server.digest, bigInteger2, bigInteger, bigInteger3);
        this.S = sRP6Server.calculateS();
        return this.S;
    }

    public BigInteger selectPrivateValue() {
        SRP6Server sRP6Server = bigInteger;
        BigInteger bigInteger = sRP6Server.N;
        BigInteger bigInteger2 = sRP6Server.g;
        SecureRandom secureRandom = sRP6Server.random;
        return SRP6Util.generatePrivateValue(((SRP6Server)((Object)bigInteger)).digest, bigInteger, bigInteger2, secureRandom);
    }

    public boolean verifyClientEvidenceMessage(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = this.A;
        if (bigInteger4 != null && (bigInteger3 = this.B) != null && (bigInteger2 = this.S) != null) {
            if (SRP6Util.calculateM1(this.digest, this.N, bigInteger4, bigInteger3, bigInteger2).equals(bigInteger)) {
                this.M1 = bigInteger;
                return true;
            }
            return false;
        }
        throw new CryptoException("Impossible to compute and verify M1: some data are missing from the previous operations (A,B,S)");
    }

    public BigInteger calculateServerEvidenceMessage() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = this.A;
        if (bigInteger3 != null && (bigInteger2 = this.M1) != null && (bigInteger = this.S) != null) {
            this.M2 = SRP6Util.calculateM2(this.digest, this.N, bigInteger3, bigInteger2, bigInteger);
            return this.M2;
        }
        throw new CryptoException("Impossible to compute M2: some data are missing from the previous operations (A,M1,S)");
    }

    public BigInteger calculateSessionKey() {
        BigInteger bigInteger = this.S;
        if (bigInteger != null && this.M1 != null && this.M2 != null) {
            this.Key = SRP6Util.calculateKey(this.digest, this.N, bigInteger);
            return this.Key;
        }
        throw new CryptoException("Impossible to compute Key: some data are missing from the previous operations (S,M1,M2)");
    }
}

