/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

class SSHBuilder {
    private final ByteArrayOutputStream bos;

    public SSHBuilder() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.bos = byteArrayOutputStream2;
    }

    public void u32(int n) {
        SSHBuilder sSHBuilder = this;
        sSHBuilder.bos.write(n >>> 24 & 0xFF);
        sSHBuilder.bos.write(n >>> 16 & 0xFF);
        sSHBuilder.bos.write(n >>> 8 & 0xFF);
        sSHBuilder.bos.write(n & 0xFF);
    }

    public void writeBigNum(BigInteger bigInteger) {
        this.writeBlock(bigInteger.toByteArray());
    }

    public void writeBlock(byte[] byArray) {
        SSHBuilder sSHBuilder = this;
        sSHBuilder.u32(byArray.length);
        try {
            sSHBuilder.bos.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            this.bos.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void writeString(String string) {
        this.writeBlock(Strings.toByteArray(string));
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }

    public byte[] getPaddedBytes() {
        return this.getPaddedBytes(8);
    }

    public byte[] getPaddedBytes(int n) {
        int n2 = this.bos.size() % n;
        if (n2 != 0) {
            n -= n2;
            for (n2 = 1; n2 <= n; ++n2) {
                this.bos.write(n2);
            }
        }
        return this.bos.toByteArray();
    }
}

