/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithID;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.SM2Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.SM2ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class GMSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper helper;
    private AlgorithmParameters engineParams;
    private SM2ParameterSpec paramSpec;
    private final SM2Signer signer;

    public GMSignatureSpi(SM2Signer sM2Signer) {
        BCJcaJceHelper bCJcaJceHelper;
        BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.helper = bCJcaJceHelper2;
        v1.signer = sM2Signer;
    }

    @Override
    public void engineInitVerify(PublicKey object) {
        object = ECUtils.generatePublicKeyParameter((PublicKey)object);
        SM2ParameterSpec sM2ParameterSpec = this.paramSpec;
        if (sM2ParameterSpec != null) {
            ParametersWithID parametersWithID;
            ParametersWithID parametersWithID2 = parametersWithID;
            parametersWithID = new ParametersWithID((CipherParameters)object, sM2ParameterSpec.getID());
            object = parametersWithID2;
        }
        this.signer.init(false, (CipherParameters)object);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        object = ECUtil.generatePrivateKeyParameter((PrivateKey)object);
        Object object2 = ((SignatureSpi)((Object)parametersWithID2)).appRandom;
        if (object2 != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, (SecureRandom)object2);
            object = parametersWithRandom2;
        }
        if ((object2 = ((GMSignatureSpi)((Object)parametersWithID2)).paramSpec) != null) {
            ParametersWithID parametersWithID;
            ParametersWithID parametersWithID2 = parametersWithID;
            parametersWithID = new ParametersWithID((CipherParameters)object, ((SM2ParameterSpec)object2).getID());
            ((GMSignatureSpi)((Object)parametersWithID2)).signer.init(true, parametersWithID2);
        } else {
            ((GMSignatureSpi)((Object)parametersWithID2)).signer.init(true, (CipherParameters)object);
        }
    }

    @Override
    public void engineUpdate(byte by) {
        this.signer.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.signer.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(b.a("unable to create signature: ").append(cryptoException.getMessage()).toString());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        return this.signer.verifySignature(byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof SM2ParameterSpec) {
            this.paramSpec = (SM2ParameterSpec)algorithmParameterSpec;
            return;
        }
        throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            AlgorithmParameters algorithmParameters;
            try {
                algorithmParameters = this.helper.createAlgorithmParameters("PSS");
            }
            catch (Exception exception) {
                throw new RuntimeException(((Object)exception).toString());
            }
            this.engineParams = algorithmParameters;
            algorithmParameters.init(this.paramSpec);
        }
        return this.engineParams;
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class sm3WithSM2
    extends GMSignatureSpi {
        public sm3WithSM2() {
            SM2Signer sM2Signer;
            sm3WithSM2 sm3WithSM22 = sM2Signer2;
            SM2Signer sM2Signer2 = sM2Signer;
            sM2Signer = new SM2Signer();
            super(sM2Signer2);
        }
    }

    public static class sha256WithSM2
    extends GMSignatureSpi {
        public sha256WithSM2() {
            SHA256Digest sHA256Digest;
            SM2Signer sM2Signer;
            sha256WithSM2 sha256WithSM22 = sM2Signer2;
            SM2Signer sM2Signer2 = sM2Signer;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            sM2Signer = new SM2Signer(sHA256Digest2);
            super(sM2Signer2);
        }
    }
}

