/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class JCEECPublicKey
implements ECPublicKey,
com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey,
ECPointEncoder {
    private String algorithm;
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    public JCEECPublicKey(String string, JCEECPublicKey jCEECPublicKey) {
        this.algorithm = string;
        this.q = jCEECPublicKey.q;
        this.ecSpec = jCEECPublicKey.ecSpec;
        this.withCompression = jCEECPublicKey.withCompression;
        this.gostParams = jCEECPublicKey.gostParams;
    }

    public JCEECPublicKey(String object, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = object;
        this.ecSpec = object = eCPublicKeySpec.getParams();
        this.q = EC5Util.convertPoint((ECParameterSpec)object, eCPublicKeySpec.getW());
    }

    public JCEECPublicKey(String string, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        if (eCPublicKeySpec.getParams() != null) {
            this.ecSpec = EC5Util.convertSpec(EC5Util.convertCurve(eCPublicKeySpec.getParams().getCurve(), eCPublicKeySpec.getParams().getSeed()), eCPublicKeySpec.getParams());
        } else {
            if (this.q.getCurve() == null) {
                this.q = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve().createPoint(this.q.getAffineXCoord().toBigInteger(), this.q.getAffineYCoord().toBigInteger());
            }
            this.ecSpec = null;
        }
    }

    public JCEECPublicKey(String object, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        String string = object;
        this.algorithm = "EC";
        object = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? this.createSpec(EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed()), (ECDomainParameters)object) : eCParameterSpec;
    }

    public JCEECPublicKey(String object, ECPublicKeyParameters eCPublicKeyParameters, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        String string = object;
        this.algorithm = "EC";
        object = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? this.createSpec(EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed()), (ECDomainParameters)object) : EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec);
    }

    public JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        JCEECPublicKey jCEECPublicKey = this;
        this.algorithm = string;
        jCEECPublicKey.q = eCPublicKeyParameters.getQ();
        jCEECPublicKey.ecSpec = null;
    }

    private ECParameterSpec createSpec(EllipticCurve object, ECDomainParameters eCDomainParameters) {
        EllipticCurve ellipticCurve = object;
        ECDomainParameters eCDomainParameters2 = eCDomainParameters;
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint(eCDomainParameters2.getG());
        object = eCDomainParameters2.getN();
        int n = eCDomainParameters2.getH().intValue();
        return new ECParameterSpec(ellipticCurve, eCPoint, (BigInteger)object, n);
    }

    public JCEECPublicKey(ECPublicKey eCPublicKey) {
        ECParameterSpec eCParameterSpec;
        this.algorithm = "EC";
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCParameterSpec = eCPublicKey.getParams();
        this.q = EC5Util.convertPoint(eCParameterSpec, eCPublicKey.getW());
    }

    public JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        JCEECPublicKey jCEECPublicKey = this;
        jCEECPublicKey.algorithm = "EC";
        jCEECPublicKey.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo object) {
        block11: {
            Object object2;
            DEROctetString dEROctetString;
            ECCurve eCCurve;
            Object object3;
            Object object4;
            block10: {
                object4 = ((SubjectPublicKeyInfo)object).getAlgorithm();
                if (!((AlgorithmIdentifier)object4).getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3410_2001)) break block10;
                object = ((SubjectPublicKeyInfo)object).getPublicKeyData();
                ((JCEECPublicKey)((Object)string)).algorithm = "ECGOST3410";
                try {
                    object = ((ASN1OctetString)ASN1Primitive.fromByteArray(((ASN1BitString)object).getBytes())).getOctets();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
                byte[] byArray = new byte[65];
                Object object5 = byArray;
                byArray[0] = 4;
                for (int k = 1; k <= 32; ++k) {
                    object5[k] = (byte)object[32 - k];
                    int n = k + 32;
                    object5[n] = (byte)object[64 - k];
                }
                JCEECPublicKey jCEECPublicKey = string;
                object = GOST3410PublicKeyAlgParameters.getInstance(((AlgorithmIdentifier)object4).getParameters());
                jCEECPublicKey.gostParams = object;
                object = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet()));
                ECCurve eCCurve2 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object).getCurve();
                object4 = EC5Util.convertCurve(eCCurve2, ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object).getSeed());
                jCEECPublicKey.q = eCCurve2.decodePoint((byte[])object5);
                Object object6 = object;
                String string = ECGOST3410NamedCurves.getName(((JCEECPublicKey)((Object)string)).gostParams.getPublicKeyParamSet());
                object = EC5Util.convertPoint(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getG());
                object5 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getN();
                BigInteger bigInteger = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getH();
                jCEECPublicKey.ecSpec = new ECNamedCurveSpec(string, (EllipticCurve)object4, (java.security.spec.ECPoint)object, (BigInteger)object5, bigInteger);
                break block11;
            }
            if (((X962Parameters)(object4 = X962Parameters.getInstance(((AlgorithmIdentifier)object4).getParameters()))).isNamedCurve()) {
                object4 = (ASN1ObjectIdentifier)((X962Parameters)object4).getParameters();
                object3 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)object4);
                eCCurve = ((X9ECParameters)object3).getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, ((X9ECParameters)object3).getSeed());
                Object object7 = object3;
                object4 = ECUtil.getCurveName((ASN1ObjectIdentifier)object4);
                object3 = EC5Util.convertPoint(((X9ECParameters)object7).getG());
                BigInteger bigInteger = ((X9ECParameters)object7).getN();
                BigInteger bigInteger2 = ((X9ECParameters)object7).getH();
                ((JCEECPublicKey)((Object)string)).ecSpec = new ECNamedCurveSpec((String)object4, ellipticCurve, (java.security.spec.ECPoint)object3, bigInteger, bigInteger2);
            } else if (((X962Parameters)object4).isImplicitlyCA()) {
                ((JCEECPublicKey)((Object)string)).ecSpec = null;
                eCCurve = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
            } else {
                object4 = X9ECParameters.getInstance(((X962Parameters)object4).getParameters());
                eCCurve = ((X9ECParameters)object4).getCurve();
                Object object8 = object3 = EC5Util.convertCurve(eCCurve, ((X9ECParameters)object4).getSeed());
                ASN1Object aSN1Object = object4;
                object4 = EC5Util.convertPoint(((X9ECParameters)aSN1Object).getG());
                object3 = ((X9ECParameters)aSN1Object).getN();
                int n = ((X9ECParameters)aSN1Object).getH().intValue();
                ((JCEECPublicKey)((Object)string)).ecSpec = new ECParameterSpec((EllipticCurve)object8, (java.security.spec.ECPoint)object4, (BigInteger)object3, n);
            }
            byte[] byArray = ((SubjectPublicKeyInfo)object).getPublicKeyData().getBytes();
            object = byArray;
            object4 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            if (byArray[0] == 4 && object[1] == ((Object)object).length - 2 && ((object2 = object[2]) == 2 || object2 == 3) && new X9IntegerConverter().getByteLength(eCCurve) >= ((Object)object).length - 3) {
                try {
                    object4 = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            ((JCEECPublicKey)((Object)string)).q = new X9ECPoint(eCCurve, (ASN1OctetString)object4).getPoint();
        }
    }

    private void extractBytes(byte[] byArray, int n, BigInteger bigInteger) {
        int n2;
        byte[] byArray2 = bigInteger.toByteArray();
        Object object = byArray2;
        if (byArray2.length < 32) {
            Object object2 = object;
            object = new byte[32];
            int n3 = 32 - ((Object)object2).length;
            n2 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, n3, n2);
        }
        for (int k = 0; k != 32; ++k) {
            Object object3 = object;
            n2 = n + k;
            byArray[n2] = (byte)object3[((Object)object3).length - 1 - k];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])objectInputStream.readObject())));
        this.algorithm = (String)objectInputStream.readObject();
        this.withCompression = objectInputStream.readBoolean();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getEncoded());
        objectOutputStream.writeObject(this.algorithm);
        objectOutputStream.writeBoolean(this.withCompression);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        Object object;
        if (((JCEECPublicKey)object).algorithm.equals("ECGOST3410")) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            Object object2;
            Object object3;
            Object object4 = ((JCEECPublicKey)object).gostParams;
            if (object4 == null) {
                object4 = ((JCEECPublicKey)object).ecSpec;
                if (object4 instanceof ECNamedCurveSpec) {
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters;
                    object3 = gOST3410PublicKeyAlgParameters;
                    gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)object4).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
                    object4 = object3;
                } else {
                    X962Parameters x962Parameters;
                    X9ECPoint x9ECPoint;
                    X9ECParameters x9ECParameters;
                    object4 = EC5Util.convertCurve(((ECParameterSpec)object4).getCurve());
                    object3 = x9ECParameters;
                    Object object5 = object4;
                    Serializable serializable = object;
                    object2 = x9ECPoint;
                    object4 = EC5Util.convertPoint((ECCurve)object4, ((JCEECPublicKey)object).ecSpec.getGenerator());
                    x9ECPoint = new X9ECPoint((ECPoint)object4, ((JCEECPublicKey)object).withCompression);
                    object4 = ((JCEECPublicKey)serializable).ecSpec.getOrder();
                    BigInteger bigInteger = BigInteger.valueOf(((JCEECPublicKey)serializable).ecSpec.getCofactor());
                    byte[] byArray = ((JCEECPublicKey)serializable).ecSpec.getCurve().getSeed();
                    x9ECParameters = new X9ECParameters((ECCurve)object5, (X9ECPoint)object2, (BigInteger)object4, bigInteger, byArray);
                    object4 = x962Parameters;
                    x962Parameters = new X962Parameters((X9ECParameters)object3);
                }
            }
            JCEECPublicKey jCEECPublicKey = object;
            object = jCEECPublicKey.q.getAffineXCoord().toBigInteger();
            object3 = jCEECPublicKey.q.getAffineYCoord().toBigInteger();
            object2 = new byte[64];
            jCEECPublicKey.extractBytes((byte[])object2, 0, (BigInteger)object);
            jCEECPublicKey.extractBytes((byte[])object2, 32, (BigInteger)object3);
            object = subjectPublicKeyInfo;
            try {
                algorithmIdentifier = new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, (ASN1Encodable)object4);
            }
            catch (IOException iOException) {
                return null;
            }
            object4 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object2);
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, (ASN1Encodable)object4);
        } else {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            Object object6;
            Object object7 = ((JCEECPublicKey)object).ecSpec;
            if (object7 instanceof ECNamedCurveSpec) {
                X962Parameters x962Parameters;
                if ((object7 = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)object7).getName())) == null) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    object7 = aSN1ObjectIdentifier;
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)((JCEECPublicKey)object).ecSpec).getName());
                }
                object6 = x962Parameters;
                x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object7);
            } else if (object7 == null) {
                X962Parameters x962Parameters;
                object6 = x962Parameters;
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                X962Parameters x962Parameters;
                X9ECPoint x9ECPoint;
                X9ECParameters x9ECParameters;
                object7 = EC5Util.convertCurve(((ECParameterSpec)object7).getCurve());
                object6 = x9ECParameters;
                Object object8 = object7;
                Serializable serializable = object;
                X9ECPoint x9ECPoint2 = x9ECPoint;
                object7 = EC5Util.convertPoint((ECCurve)object7, ((JCEECPublicKey)object).ecSpec.getGenerator());
                x9ECPoint = new X9ECPoint((ECPoint)object7, ((JCEECPublicKey)object).withCompression);
                object7 = ((JCEECPublicKey)serializable).ecSpec.getOrder();
                BigInteger bigInteger = BigInteger.valueOf(((JCEECPublicKey)serializable).ecSpec.getCofactor());
                byte[] byArray = ((JCEECPublicKey)serializable).ecSpec.getCurve().getSeed();
                x9ECParameters = new X9ECParameters((ECCurve)object8, x9ECPoint2, (BigInteger)object7, bigInteger, byArray);
                object7 = x962Parameters;
                x962Parameters = new X962Parameters((X9ECParameters)object6);
                object6 = object7;
            }
            object = ((JCEECPublicKey)object).getQ().getEncoded(((JCEECPublicKey)object).withCompression);
            object7 = subjectPublicKeyInfo;
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)object6), (byte[])object);
            object = object7;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)object);
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((JCEECPublicKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    @Override
    public java.security.spec.ECPoint getW() {
        return EC5Util.convertPoint(this.q);
    }

    @Override
    public ECPoint getQ() {
        if (this.ecSpec == null) {
            return this.q.getDetachedPoint();
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = ((JCEECPublicKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.q.getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.q.getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    @Override
    public void setPointFormat(String string) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPublicKey)) {
            return false;
        }
        object = (JCEECPublicKey)object;
        return this.engineGetQ().equals(((JCEECPublicKey)object).engineGetQ()) && this.engineGetSpec().equals(((JCEECPublicKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }
}

