/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SM2P256V1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF"));
    public int[] x;

    public SM2P256V1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SM2P256V1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SM2P256V1FieldElement");
    }

    public SM2P256V1FieldElement() {
        this.x = Nat256.create();
    }

    public SM2P256V1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SM2P256V1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.add(sM2P256V1FieldElement.x, ((SM2P256V1FieldElement)eCFieldElement).x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.addOne(sM2P256V1FieldElement.x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.subtract(sM2P256V1FieldElement.x, ((SM2P256V1FieldElement)eCFieldElement).x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.multiply(sM2P256V1FieldElement.x, ((SM2P256V1FieldElement)eCFieldElement).x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.inv(((SM2P256V1FieldElement)eCFieldElement).x, nArray);
        SM2P256V1Field.multiply(nArray, this.x, nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.negate(sM2P256V1FieldElement.x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.square(sM2P256V1FieldElement.x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SM2P256V1FieldElement sM2P256V1FieldElement = object;
        Object object = Nat256.create();
        SM2P256V1Field.inv(sM2P256V1FieldElement.x, (int[])object);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SM2P256V1FieldElement)object).x;
        if (!Nat256.isZero(((SM2P256V1FieldElement)object).x) && !Nat256.isOne(nArray)) {
            int[] nArray2 = Nat256.create();
            Object object = nArray2;
            SM2P256V1Field.square(nArray, (int[])object);
            SM2P256V1Field.multiply(nArray2, nArray, (int[])object);
            int[] nArray3 = Nat256.create();
            Object object2 = object;
            SM2P256V1Field.squareN((int[])object2, 2, nArray3);
            SM2P256V1Field.multiply(nArray3, (int[])object2, nArray3);
            int[] nArray4 = Nat256.create();
            SM2P256V1Field.squareN(nArray3, 2, nArray4);
            SM2P256V1Field.multiply(nArray4, (int[])object, nArray4);
            SM2P256V1Field.squareN(nArray4, 6, (int[])object);
            SM2P256V1Field.multiply(nArray2, nArray4, (int[])object);
            int[] nArray5 = Nat256.create();
            int[] nArray6 = nArray4;
            Object object3 = object;
            SM2P256V1Field.squareN((int[])object3, 12, nArray5);
            SM2P256V1Field.multiply(nArray5, (int[])object3, nArray5);
            SM2P256V1Field.squareN(nArray5, 6, (int[])object);
            SM2P256V1Field.multiply((int[])object, nArray4, (int[])object);
            SM2P256V1Field.square((int[])object, nArray4);
            SM2P256V1Field.multiply(nArray6, nArray, nArray4);
            SM2P256V1Field.squareN(nArray6, 31, nArray5);
            SM2P256V1Field.multiply(nArray5, nArray4, (int[])object);
            SM2P256V1Field.squareN(nArray5, 32, nArray5);
            SM2P256V1Field.multiply(nArray5, (int[])object, nArray5);
            SM2P256V1Field.squareN(nArray5, 62, nArray5);
            SM2P256V1Field.multiply(nArray5, (int[])object, nArray5);
            SM2P256V1Field.squareN(nArray5, 4, nArray5);
            SM2P256V1Field.multiply(nArray5, nArray3, nArray5);
            SM2P256V1Field.squareN(nArray5, 32, nArray5);
            SM2P256V1Field.multiply(nArray5, nArray, nArray5);
            SM2P256V1Field.squareN(nArray5, 62, nArray5);
            SM2P256V1Field.square(nArray5, nArray3);
            if (Nat256.eq(nArray, nArray3)) {
                SM2P256V1FieldElement sM2P256V1FieldElement;
                object = sM2P256V1FieldElement;
                sM2P256V1FieldElement = new SM2P256V1FieldElement(nArray5);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == sM2P256V1FieldElement2) {
            return true;
        }
        if (!(object instanceof SM2P256V1FieldElement)) {
            return false;
        }
        SM2P256V1FieldElement sM2P256V1FieldElement = sM2P256V1FieldElement2;
        SM2P256V1FieldElement sM2P256V1FieldElement2 = (SM2P256V1FieldElement)object;
        return Nat256.eq(sM2P256V1FieldElement.x, sM2P256V1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

