/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;

public class FrodoKEMExtractor
implements EncapsulatedSecretExtractor {
    private FrodoEngine engine;
    private FrodoKeyParameters key;

    public FrodoKEMExtractor(FrodoKeyParameters frodoKeyParameters) {
        this.key = frodoKeyParameters;
        this.initCipher(frodoKeyParameters.getParameters());
    }

    private void initCipher(FrodoParameters frodoParameters) {
        this.engine = frodoParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getSessionKeySize()];
        this.engine.kem_dec(byArray2, byArray, ((FrodoPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

