/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import java.io.ByteArrayOutputStream;

public class Composer {
    private final ByteArrayOutputStream bos;

    private Composer() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.bos = byteArrayOutputStream2;
    }

    public static Composer compose() {
        return new Composer();
    }

    public Composer u64str(long l) {
        Composer composer = this;
        this.u32str((int)(l >>> 32));
        composer.u32str((int)l);
        return composer;
    }

    public Composer u32str(int n) {
        Composer composer = this;
        composer.bos.write((byte)(n >>> 24));
        composer.bos.write((byte)(n >>> 16));
        composer.bos.write((byte)(n >>> 8));
        composer.bos.write((byte)n);
        return composer;
    }

    public Composer u16str(int n) {
        Composer composer = this;
        int n2 = n & 0xFFFF;
        composer.bos.write((byte)(n2 >>> 8));
        composer.bos.write((byte)n2);
        return composer;
    }

    public Composer bytes(Encodable[] encodableArray) {
        int n;
        try {
            n = encodableArray.length;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        for (int k = 0; k < n; ++k) {
            Composer composer = this;
            Encodable encodable = encodableArray[k];
            composer.bos.write(encodable.getEncoded());
            continue;
        }
        return this;
    }

    public Composer bytes(Encodable encodable) {
        try {
            Composer composer = this;
            composer.bos.write(encodable.getEncoded());
            return composer;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public Composer pad(int n, int n2) {
        while (n2 >= 0) {
            try {
                this.bos.write(n);
                --n2;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this;
    }

    public Composer bytes(byte[][] byArray) {
        int n;
        try {
            n = byArray.length;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        for (int k = 0; k < n; ++k) {
            Composer composer = this;
            byte[] byArray2 = byArray[k];
            composer.bos.write(byArray2);
            continue;
        }
        return this;
    }

    public Composer bytes(byte[][] byArray, int n, int n2) {
        while (n != n2) {
            try {
                this.bos.write(byArray[n]);
                ++n;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this;
    }

    public Composer bytes(byte[] byArray) {
        try {
            Composer composer = this;
            composer.bos.write(byArray);
            return composer;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public Composer bytes(byte[] byArray, int n, int n2) {
        try {
            Composer composer = this;
            composer.bos.write(byArray, n, n2);
            return composer;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public byte[] build() {
        return this.bos.toByteArray();
    }

    public Composer padUntil(int n, int n2) {
        while (this.bos.size() < n2) {
            this.bos.write(n);
        }
        return this;
    }

    public Composer bool(boolean bl) {
        Composer composer = this;
        composer.bos.write(bl ? 1 : 0);
        return composer;
    }
}

